/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jws.handlers;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.forgerock.json.jose.exceptions.JwsSigningException;
import org.forgerock.json.jose.jws.JwsAlgorithm;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.json.jose.utils.Utils;
import org.forgerock.util.Reject;

public class HmacSigningHandler
implements SigningHandler {
    private final byte[] sharedSecret;

    public HmacSigningHandler(byte[] sharedSecret) {
        Reject.ifNull((Object)sharedSecret, (String)"Shared secret cannot be null.");
        this.sharedSecret = (byte[])sharedSecret.clone();
    }

    @Override
    public byte[] sign(JwsAlgorithm algorithm, String data) {
        return this.signWithHMAC(algorithm.getAlgorithm(), this.sharedSecret, data.getBytes(Utils.CHARSET));
    }

    @Override
    public byte[] sign(JwsAlgorithm algorithm, byte[] data) {
        return this.signWithHMAC(algorithm.getAlgorithm(), this.sharedSecret, data);
    }

    private byte[] signWithHMAC(String algorithm, byte[] sharedSecret, byte[] data) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            SecretKeySpec secretKey = new SecretKeySpec(sharedSecret, algorithm.toUpperCase());
            mac.init(secretKey);
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JwsSigningException("Unsupported Signing Algorithm, " + algorithm, e);
        }
        catch (InvalidKeyException e) {
            throw new JwsSigningException(e);
        }
    }

    @Override
    public boolean verify(JwsAlgorithm algorithm, byte[] data, byte[] signature) {
        byte[] signed = this.signWithHMAC(algorithm.getAlgorithm(), this.sharedSecret, data);
        return MessageDigest.isEqual(signed, signature);
    }
}

