/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jws.handlers;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.forgerock.json.jose.exceptions.JwsException;
import org.forgerock.json.jose.exceptions.JwsSigningException;
import org.forgerock.json.jose.jws.JwsAlgorithm;
import org.forgerock.json.jose.jws.JwsAlgorithmType;
import org.forgerock.json.jose.jws.SupportedEllipticCurve;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.json.jose.utils.DerUtils;
import org.forgerock.json.jose.utils.Utils;
import org.forgerock.util.Reject;

public class ECDSASigningHandler
implements SigningHandler {
    private final ECPrivateKey signingKey;
    private final ECPublicKey verificationKey;
    private final SupportedEllipticCurve curve;

    public ECDSASigningHandler(ECPrivateKey signingKey) {
        this.signingKey = signingKey;
        this.verificationKey = null;
        this.curve = this.validateKey(signingKey);
    }

    public ECDSASigningHandler(ECPublicKey verificationKey) {
        this.signingKey = null;
        this.verificationKey = verificationKey;
        this.curve = this.validateKey(verificationKey);
    }

    @Override
    public byte[] sign(JwsAlgorithm algorithm, String data) {
        return this.sign(algorithm, data.getBytes(Utils.CHARSET));
    }

    @Override
    public byte[] sign(JwsAlgorithm algorithm, byte[] data) {
        this.validateAlgorithm(algorithm);
        try {
            Signature signature = Signature.getInstance(algorithm.getAlgorithm());
            signature.initSign(this.signingKey);
            signature.update(data);
            return ECDSASigningHandler.derDecode(signature.sign(), this.curve.getSignatureSize());
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new JwsSigningException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JwsSigningException("Unsupported Signing Algorithm, " + algorithm.getAlgorithm(), e);
        }
    }

    @Override
    public boolean verify(JwsAlgorithm algorithm, byte[] data, byte[] signature) {
        this.validateAlgorithm(algorithm);
        try {
            Signature validator = Signature.getInstance(algorithm.getAlgorithm());
            validator.initVerify(this.verificationKey);
            validator.update(data);
            return validator.verify(this.JOSEToDER(signature));
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new JwsSigningException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JwsSigningException("Unsupported Signing Algorithm, " + algorithm.getAlgorithm(), e);
        }
    }

    private void validateAlgorithm(JwsAlgorithm algorithm) {
        Reject.ifNull((Object)algorithm, (String)"Algorithm must not be null.");
        Reject.ifTrue((algorithm.getAlgorithmType() != JwsAlgorithmType.ECDSA ? 1 : 0) != 0, (String)"Not an ECDSA algorithm.");
    }

    private SupportedEllipticCurve validateKey(ECKey key) {
        Reject.ifNull((Object)key);
        try {
            return SupportedEllipticCurve.forKey(key);
        }
        catch (IllegalArgumentException ex) {
            throw new JwsException(ex);
        }
    }

    private static byte[] derDecode(byte[] signature, int signatureSize) {
        ByteBuffer buffer = ByteBuffer.wrap(signature);
        if (buffer.get() != 48) {
            throw new JwsSigningException("Unable to decode DER signature");
        }
        DerUtils.readLength(buffer);
        byte[] output = new byte[signatureSize];
        int componentSize = signatureSize >> 1;
        DerUtils.readUnsignedInteger(buffer, output, 0, componentSize);
        DerUtils.readUnsignedInteger(buffer, output, componentSize, componentSize);
        return output;
    }

    byte[] JOSEToDER(byte[] joseSignature) throws SignatureException {
        int offset;
        byte[] derSignature;
        int sPadding;
        int sLength;
        int rPadding;
        SupportedEllipticCurve curve = SupportedEllipticCurve.forSignature(joseSignature);
        int ecNumberSize = curve.getSignatureSize() >> 1;
        int rLength = ecNumberSize - (rPadding = this.countPadding(joseSignature, 0, ecNumberSize));
        int length = 2 + rLength + 2 + (sLength = ecNumberSize - (sPadding = this.countPadding(joseSignature, ecNumberSize, joseSignature.length)));
        if (length > 255) {
            throw new SignatureException("Invalid JOSE signature format.");
        }
        if (length > 127) {
            derSignature = new byte[3 + length];
            derSignature[1] = -127;
            offset = 2;
        } else {
            derSignature = new byte[2 + length];
            offset = 1;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)(length & 0xFF);
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)rLength;
        if (rPadding < 0) {
            derSignature[offset++] = 0;
            System.arraycopy(joseSignature, 0, derSignature, offset, ecNumberSize);
            offset += ecNumberSize;
        } else {
            int copyLength = Math.min(ecNumberSize, rLength);
            System.arraycopy(joseSignature, rPadding, derSignature, offset, copyLength);
            offset += copyLength;
        }
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)sLength;
        if (sPadding < 0) {
            derSignature[offset++] = 0;
            System.arraycopy(joseSignature, ecNumberSize, derSignature, offset, ecNumberSize);
        } else {
            System.arraycopy(joseSignature, ecNumberSize + sPadding, derSignature, offset, Math.min(ecNumberSize, sLength));
        }
        return derSignature;
    }

    private int countPadding(byte[] bytes, int fromIndex, int toIndex) {
        int padding = 0;
        while (fromIndex + padding < toIndex && bytes[fromIndex + padding] == 0) {
            ++padding;
        }
        return (bytes[fromIndex + padding] & 0xFF) > 127 ? padding - 1 : padding;
    }
}

