/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jws;

import java.math.BigInteger;
import java.security.interfaces.ECKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import org.forgerock.json.jose.jws.JwsAlgorithm;

public enum SupportedEllipticCurve {
    P256("P-256", StandardCurve.access$000(), 64, JwsAlgorithm.ES256),
    P384("P-384", StandardCurve.access$100(), 96, JwsAlgorithm.ES384),
    P521("P-521", StandardCurve.access$200(), 132, JwsAlgorithm.ES512);

    private final ECParameterSpec parameters;
    private final String standardName;
    private final int signatureSize;
    private final JwsAlgorithm jwsAlgorithm;

    private SupportedEllipticCurve(String standardName, ECParameterSpec curve, int signatureSize, JwsAlgorithm jwsAlgorithm) {
        this.parameters = curve;
        this.standardName = standardName;
        this.signatureSize = signatureSize;
        this.jwsAlgorithm = jwsAlgorithm;
    }

    public ECParameterSpec getParameters() {
        return this.parameters;
    }

    public String getStandardName() {
        return this.standardName;
    }

    public int getSignatureSize() {
        return this.signatureSize;
    }

    public JwsAlgorithm getJwsAlgorithm() {
        return this.jwsAlgorithm;
    }

    public static SupportedEllipticCurve forName(String curveName) {
        for (SupportedEllipticCurve candidate : SupportedEllipticCurve.values()) {
            if (!candidate.getStandardName().equals(curveName)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Unsupported curve: " + curveName);
    }

    public static SupportedEllipticCurve forKey(ECKey key) {
        ECParameterSpec params = key.getParams();
        for (SupportedEllipticCurve supported : SupportedEllipticCurve.values()) {
            ECParameterSpec candidateParams = supported.getParameters();
            if (candidateParams.getCofactor() != params.getCofactor() || !Objects.equals(candidateParams.getCurve(), params.getCurve()) || !Objects.equals(candidateParams.getGenerator(), params.getGenerator()) || !Objects.equals(candidateParams.getOrder(), params.getOrder())) continue;
            return supported;
        }
        throw new IllegalArgumentException("Unsupported ECKey parameters");
    }

    public static SupportedEllipticCurve forSignature(byte[] signature) {
        for (SupportedEllipticCurve candidate : SupportedEllipticCurve.values()) {
            if (signature.length != candidate.getSignatureSize()) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Unsupported signature size: " + signature.length);
    }

    private static class StandardCurve {
        private static final int H = 1;
        private static final ECParameterSpec P_256 = new ECParameterSpec(new EllipticCurve(StandardCurve.p("115792089210356248762697446949407573530086143415290314195533631308867097853951"), StandardCurve.a("115792089210356248762697446949407573530086143415290314195533631308867097853948"), StandardCurve.b("41058363725152142129326129780047268409114441015993725554835256314039467401291"), StandardCurve.seed("c49d3608 86e70493 6a6678e1 139d26b7 819f7e90")), new ECPoint(StandardCurve.x("48439561293906451759052585252797914202762949526041747995844080717082404635286"), StandardCurve.y("36134250956749795798585127919587881956611106672985015071877198253568414405109")), StandardCurve.n("115792089210356248762697446949407573529996955224135760342422259061068512044369"), 1);
        private static final ECParameterSpec P_384 = new ECParameterSpec(new EllipticCurve(StandardCurve.p("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319"), StandardCurve.a("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112316"), StandardCurve.b("27580193559959705877849011840389048093056905856361568521428707301988689241309860865136260764883745107765439761230575"), StandardCurve.seed("a335926a a319a27a 1d00896a 6773a482 7acdac73")), new ECPoint(StandardCurve.x("26247035095799689268623156744566981891852923491109213387815615900925518854738050089022388053975719786650872476732087"), StandardCurve.y("8325710961489029985546751289520108179287853048861315594709205902480503199884419224438643760392947333078086511627871")), StandardCurve.n("39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643"), 1);
        private static final ECParameterSpec P_521 = new ECParameterSpec(new EllipticCurve(StandardCurve.p("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151"), StandardCurve.a("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057148"), StandardCurve.b("1093849038073734274511112390766805569936207598951683748994586394495953116150735016013708737573759623248592132296706313309438452531591012912142327488478985984"), StandardCurve.seed("d09e8800 291cb853 96cc6717 393284aa a0da64ba")), new ECPoint(StandardCurve.x("2661740802050217063228768716723360960729859168756973147706671368418802944996427808491545080627771902352094241225065558662157113545570916814161637315895999846"), StandardCurve.y("3757180025770020463545507224491183603594455134769762486694567779615544477440556316691234405012945539562144444537289428522585666729196580810124344277578376784")), StandardCurve.n("6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449"), 1);

        private StandardCurve() {
        }

        private static ECFieldFp p(String value) {
            return new ECFieldFp(new BigInteger(value));
        }

        private static BigInteger a(String value) {
            return new BigInteger(value);
        }

        private static BigInteger b(String value) {
            return new BigInteger(value);
        }

        private static BigInteger x(String value) {
            return new BigInteger(value);
        }

        private static BigInteger y(String value) {
            return new BigInteger(value);
        }

        private static BigInteger n(String value) {
            return new BigInteger(value);
        }

        private static byte[] seed(String hex) {
            return DatatypeConverter.parseHexBinary((String)hex.replaceAll("\\s+", ""));
        }

        static /* synthetic */ ECParameterSpec access$000() {
            return P_256;
        }

        static /* synthetic */ ECParameterSpec access$100() {
            return P_384;
        }

        static /* synthetic */ ECParameterSpec access$200() {
            return P_521;
        }
    }
}

