/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jws;

import org.forgerock.json.jose.jws.JwsAlgorithmType;
import org.forgerock.json.jose.jwt.Algorithm;

public enum JwsAlgorithm implements Algorithm
{
    NONE(null, null, JwsAlgorithmType.NONE),
    HS256("HmacSHA256", "SHA-256", JwsAlgorithmType.HMAC),
    HS384("HmacSHA384", "SHA-384", JwsAlgorithmType.HMAC),
    HS512("HmacSHA512", "SHA-512", JwsAlgorithmType.HMAC),
    RS256("SHA256withRSA", "SHA-256", JwsAlgorithmType.RSA),
    RS384("SHA384withRSA", "SHA-384", JwsAlgorithmType.RSA),
    RS512("SHA512withRSA", "SHA-512", JwsAlgorithmType.RSA),
    ES256("SHA256WithECDSA", "SHA-256", JwsAlgorithmType.ECDSA),
    ES384("SHA384WithECDSA", "SHA-384", JwsAlgorithmType.ECDSA),
    ES512("SHA512WithECDSA", "SHA-512", JwsAlgorithmType.ECDSA);

    private final String algorithm;
    private final String mdAlgorithm;
    private final JwsAlgorithmType algorithmType;

    private JwsAlgorithm(String algorithm, String mdAlgorithm, JwsAlgorithmType algorithmType) {
        this.algorithm = algorithm;
        this.mdAlgorithm = mdAlgorithm;
        this.algorithmType = algorithmType;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getMdAlgorithm() {
        return this.mdAlgorithm;
    }

    public String getEllipticCurveName() {
        switch (this) {
            case ES256: {
                return "P-256";
            }
            case ES384: {
                return "P-384";
            }
            case ES512: {
                return "P-521";
            }
        }
        return null;
    }

    public JwsAlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    public static JwsAlgorithm getJwsAlgorithm(String algorithm) {
        for (JwsAlgorithm jwsAlgorithm : JwsAlgorithm.values()) {
            if (!algorithm.equalsIgnoreCase(jwsAlgorithm.getAlgorithm())) continue;
            return jwsAlgorithm;
        }
        throw new IllegalArgumentException("Unknown JwsAlgorithm, " + algorithm);
    }

    public String toString() {
        return super.toString();
    }
}

