/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jwk.KeyType;
import org.forgerock.json.jose.jwk.KeyUse;
import org.forgerock.util.encode.Base64url;

public class RsaJWK
extends JWK {
    private static final int BIG_INTEGER_POSITIVE = 1;
    private static final String N = "n";
    private static final String E = "e";
    private static final String D = "d";
    private static final String P = "p";
    private static final String Q = "q";
    private static final String DP = "dp";
    private static final String DQ = "dq";
    private static final String QI = "qi";
    private static final String FACTORS = "factors";

    public RsaJWK(KeyUse use, String alg, String kid, String n, String e, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, n, e, null, null, null, null, null, null, null, x5u, x5t, x5c);
    }

    public RsaJWK(KeyUse use, String alg, String kid, String n, String e, String d, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, n, e, d, null, null, null, null, null, null, x5u, x5t, x5c);
    }

    public RsaJWK(KeyUse use, String alg, String kid, String n, String e, String p, String q, String dp, String dq, String qi, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, n, e, null, p, q, dp, dq, qi, null, x5u, x5t, x5c);
    }

    public RsaJWK(KeyUse use, String alg, String kid, String n, String e, String d, String p, String q, String dp, String dq, String qi, List<OtherFactors> factors, String x5u, String x5t, List<String> x5c) {
        super(KeyType.RSA, use, alg, kid, x5u, x5t, x5c);
        if (n != null && !n.isEmpty()) {
            this.put(N, n);
        }
        if (e != null && !e.isEmpty()) {
            this.put(E, e);
        }
        if (d != null && !d.isEmpty()) {
            this.put(D, d);
        }
        if (p != null && !p.isEmpty()) {
            this.put(P, p);
        }
        if (q != null && !q.isEmpty()) {
            this.put(Q, q);
        }
        if (dp != null && !dp.isEmpty()) {
            this.put(DP, dp);
        }
        if (dq != null && !dq.isEmpty()) {
            this.put(DQ, dq);
        }
        if (qi != null && !qi.isEmpty()) {
            this.put(QI, qi);
        }
        if (factors == null) {
            this.put(FACTORS, Collections.EMPTY_LIST);
        } else {
            this.put(FACTORS, factors);
        }
        if (x5u != null && !x5u.isEmpty()) {
            this.put("x5u", x5u);
        }
        if (x5t != null && !x5t.isEmpty()) {
            this.put("x5t", x5t);
        }
        if (x5c != null && !x5c.isEmpty()) {
            this.put("x5c", x5c);
        }
    }

    public RsaJWK(RSAPublicKey key, KeyUse use, String alg, String kid, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, Base64url.encode((byte[])key.getModulus().toByteArray()), Base64url.encode((byte[])key.getPublicExponent().toByteArray()), x5u, x5t, x5c);
    }

    public RsaJWK(RSAPublicKey pubKey, RSAPrivateKey privKey, KeyUse use, String alg, String kid, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, Base64url.encode((byte[])pubKey.getModulus().toByteArray()), Base64url.encode((byte[])pubKey.getPublicExponent().toByteArray()), Base64url.encode((byte[])privKey.getPrivateExponent().toByteArray()), x5u, x5t, x5c);
    }

    public RsaJWK(RSAPublicKey pubKey, RSAPrivateCrtKey privCert, KeyUse use, String alg, String kid, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, Base64url.encode((byte[])pubKey.getModulus().toByteArray()), Base64url.encode((byte[])pubKey.getPublicExponent().toByteArray()), Base64url.encode((byte[])privCert.getPrivateExponent().toByteArray()), Base64url.encode((byte[])privCert.getPrimeP().toByteArray()), Base64url.encode((byte[])privCert.getPrimeQ().toByteArray()), Base64url.encode((byte[])privCert.getPrimeExponentP().toByteArray()), Base64url.encode((byte[])privCert.getPrimeExponentQ().toByteArray()), Base64url.encode((byte[])privCert.getCrtCoefficient().toByteArray()), null, x5u, x5t, x5c);
    }

    public String getModulus() {
        return this.get(N).asString();
    }

    public String getPublicExponent() {
        return this.get(E).asString();
    }

    public String getPrivateExponent() {
        return this.get(D).asString();
    }

    public String getPrimeP() {
        return this.get(P).asString();
    }

    public String getPrimeQ() {
        return this.get(Q).asString();
    }

    public String getPrimePExponent() {
        return this.get(DP).asString();
    }

    public String getPrimeQExponent() {
        return this.get(DQ).asString();
    }

    public String getCRTCoefficient() {
        return this.get(QI).asString();
    }

    public List<Object> getOtherFactors() {
        return this.get(FACTORS).asList();
    }

    public RSAPublicKey toRSAPublicKey() {
        try {
            RSAPublicKeySpec spec = new RSAPublicKeySpec(this.asPositiveBigInteger(this.getModulus()), this.asPositiveBigInteger(this.getPublicExponent()));
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)factory.generatePublic(spec);
        }
        catch (Exception e) {
            throw new JsonException("Unable to create RSA Public Key", (Throwable)e);
        }
    }

    public RSAPrivateKey toRSAPrivateKey() {
        RSAPrivateKeySpec spec;
        if (this.getPrivateExponent() == null) {
            return null;
        }
        BigInteger modulus = this.asPositiveBigInteger(this.getModulus());
        BigInteger privateExponent = this.asPositiveBigInteger(this.getPrivateExponent());
        if (this.getPrimeP() == null) {
            spec = new RSAPrivateKeySpec(modulus, privateExponent);
        } else {
            BigInteger publicExponent = this.asPositiveBigInteger(this.getPublicExponent());
            BigInteger p = this.asPositiveBigInteger(this.getPrimeP());
            BigInteger q = this.asPositiveBigInteger(this.getPrimeQ());
            BigInteger dp = this.asPositiveBigInteger(this.getPrimePExponent());
            BigInteger dq = this.asPositiveBigInteger(this.getPrimeQExponent());
            BigInteger qi = this.asPositiveBigInteger(this.getCRTCoefficient());
            if (this.getOtherFactors() != null && !this.getOtherFactors().isEmpty()) {
                RSAOtherPrimeInfo[] otherInfo = new RSAOtherPrimeInfo[this.getOtherFactors().size()];
                for (int i = 0; i < this.getOtherFactors().size(); ++i) {
                    OtherFactors factor = (OtherFactors)((Object)this.getOtherFactors().get(i));
                    BigInteger factorR = this.asPositiveBigInteger(factor.getFactor());
                    BigInteger factorD = this.asPositiveBigInteger(factor.getCRTExponent());
                    BigInteger factorT = this.asPositiveBigInteger(factor.getCRTCoefficient());
                    otherInfo[i] = new RSAOtherPrimeInfo(factorR, factorD, factorT);
                }
                spec = new RSAMultiPrimePrivateCrtKeySpec(modulus, publicExponent, privateExponent, p, q, dp, dq, qi, otherInfo);
            } else {
                spec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, p, q, dp, dq, qi);
            }
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            RSAPrivateKey priv = (RSAPrivateKey)factory.generatePrivate(spec);
            return priv;
        }
        catch (Exception e) {
            throw new JsonException("Unable to create private RSA Key", (Throwable)e);
        }
    }

    public KeyPair toKeyPair() {
        return new KeyPair(this.toRSAPublicKey(), this.toRSAPrivateKey());
    }

    public static RsaJWK parse(String json) {
        JsonValue jwk = new JsonValue((Object)RsaJWK.toJsonValue(json));
        return RsaJWK.parse(jwk);
    }

    public static RsaJWK parse(JsonValue json) {
        String n = null;
        String e = null;
        String d = null;
        String p = null;
        String q = null;
        String dq = null;
        String dp = null;
        String qi = null;
        String x5u = null;
        String x5t = null;
        List x5c = null;
        List factors = null;
        ArrayList<OtherFactors> listOfFactors = null;
        KeyType kty = null;
        KeyUse use = null;
        String alg = null;
        String kid = null;
        kty = KeyType.getKeyType(json.get("kty").asString());
        if (!kty.equals((Object)KeyType.RSA)) {
            throw new JsonException("Unable to parse RSA JWK; Not an RSA type");
        }
        use = KeyUse.getKeyUse(json.get("use").asString());
        alg = json.get("alg").asString();
        kid = json.get("kid").asString();
        n = json.get(N).asString();
        e = json.get(E).asString();
        d = json.get(D).asString();
        p = json.get(P).asString();
        q = json.get(Q).asString();
        dp = json.get(DP).asString();
        dq = json.get(DQ).asString();
        qi = json.get(QI).asString();
        factors = json.get(FACTORS).asList();
        x5u = json.get("x5u").asString();
        x5t = json.get("x5t").asString();
        x5c = json.get("x5c").asList(String.class);
        if (factors != null && !factors.isEmpty()) {
            listOfFactors = new ArrayList<OtherFactors>(factors.size());
            for (Object factor : factors) {
                String r = null;
                String dd = null;
                String t = null;
                r = ((JsonValue)factor).get("r").asString();
                dd = ((JsonValue)factor).get(D).asString();
                t = ((JsonValue)factor).get("t").asString();
                OtherFactors of = new OtherFactors(r, dd, t);
                listOfFactors.add(of);
            }
        }
        return new RsaJWK(use, alg, kid, n, e, d, p, q, dp, dq, qi, listOfFactors, x5u, x5t, x5c);
    }

    @Override
    public String toJsonString() {
        return super.toString();
    }

    private BigInteger asPositiveBigInteger(String toConvert) {
        return new BigInteger(1, Base64url.decode((String)toConvert));
    }

    public static class OtherFactors
    extends JsonValue {
        private static final String R = "r";
        private static final String D = "d";
        private static final String T = "t";

        public OtherFactors(String r, String d, String t) {
            super(new HashMap());
            this.put(R, r);
            this.put("d", d);
            this.put(T, t);
        }

        public OtherFactors(RSAOtherPrimeInfo info) {
            super(new HashMap());
            this.put(R, Base64url.encode((byte[])info.getPrime().toByteArray()));
            this.put("d", Base64url.encode((byte[])info.getExponent().toByteArray()));
            this.put(T, Base64url.encode((byte[])info.getCrtCoefficient().toByteArray()));
        }

        public String getFactor() {
            return this.get(R).asString();
        }

        public String getCRTExponent() {
            return this.get("d").asString();
        }

        public String getCRTCoefficient() {
            return this.get(T).asString();
        }
    }
}

