/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import java.util.List;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jwk.KeyType;
import org.forgerock.json.jose.jwk.KeyUse;

public class OctJWK
extends JWK {
    private static final String K = "k";

    public OctJWK(KeyUse use, String alg, String kid, String key, String x5u, String x5t, List<String> x5c) {
        super(KeyType.OCT, use, alg, kid, x5u, x5t, x5c);
        if (key == null || key.isEmpty()) {
            throw new JsonException("key is a required field for an OctJWK");
        }
        this.put(K, key);
    }

    public String getKey() {
        return this.get(K).asString();
    }

    public static OctJWK parse(String json) {
        JsonValue jwk = new JsonValue((Object)OctJWK.toJsonValue(json));
        return OctJWK.parse(jwk);
    }

    public static OctJWK parse(JsonValue json) {
        if (json == null) {
            throw new JsonException("Cant parse OctJWK. No json data.");
        }
        KeyType kty = null;
        KeyUse use = null;
        String k = null;
        String alg = null;
        String kid = null;
        String x5u = null;
        String x5t = null;
        List x5c = null;
        k = json.get(K).asString();
        kty = KeyType.getKeyType(json.get("kty").asString());
        if (!kty.equals((Object)KeyType.OCT)) {
            throw new JsonException("Invalid key type. Not an Oct JWK");
        }
        use = KeyUse.getKeyUse(json.get("use").asString());
        alg = json.get("alg").asString();
        kid = json.get("kid").asString();
        x5u = json.get("x5u").asString();
        x5t = json.get("x5t").asString();
        x5c = json.get("x5c").asList(String.class);
        return new OctJWK(use, alg, kid, k, x5u, x5t, (List<String>)x5c);
    }

    @Override
    public String toJsonString() {
        return super.toString();
    }
}

