/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.jwk.EcJWK;
import org.forgerock.json.jose.jwk.KeyType;
import org.forgerock.json.jose.jwk.KeyUse;
import org.forgerock.json.jose.jwk.OctJWK;
import org.forgerock.json.jose.jwk.RsaJWK;
import org.forgerock.json.jose.jwt.JWObject;

public abstract class JWK
extends JWObject {
    protected static final String KTY = "kty";
    protected static final String USE = "use";
    protected static final String ALG = "alg";
    protected static final String KID = "kid";
    protected static final String X5U = "x5u";
    protected static final String X5T = "x5t";
    protected static final String X5C = "x5c";

    protected JWK(KeyType kty, KeyUse use, String alg, String kid) {
        this(kty, use, alg, kid, null, null, null);
    }

    protected JWK(KeyType kty, KeyUse use, String alg, String kid, String x5u, String x5t, List<String> x5c) {
        if (kty == null) {
            new JsonException("kty is a required field");
        }
        this.put(KTY, kty.toString());
        if (kid == null || kid.isEmpty()) {
            new JsonException("kid is a required field");
        }
        this.put(KID, kid);
        if (use != null) {
            this.put(USE, use.toString());
        }
        if (alg != null && !alg.isEmpty()) {
            this.put(ALG, alg);
        }
        if (x5c != null && !x5c.isEmpty()) {
            this.put(X5C, x5c);
        }
        if (x5t != null && !x5t.isEmpty()) {
            this.put(X5T, x5t);
        }
        if (x5u != null && !x5u.isEmpty()) {
            this.put(X5U, x5u);
        }
    }

    public KeyType getKeyType() {
        return KeyType.getKeyType(this.get(KTY).asString());
    }

    public KeyUse getUse() {
        return KeyUse.getKeyUse(this.get(USE).asString());
    }

    public String getAlgorithm() {
        return this.get(ALG).asString();
    }

    public String getKeyId() {
        return this.get(KID).asString();
    }

    public String toJsonString() {
        return this.toString();
    }

    public static JWK parse(String json) {
        JsonValue jwk = new JsonValue((Object)JWK.toJsonValue(json));
        return JWK.parse(jwk);
    }

    public static JWK parse(JsonValue jwk) {
        KeyType kty = KeyType.getKeyType(jwk.get(KTY).asString());
        if (kty.equals((Object)KeyType.RSA)) {
            return RsaJWK.parse(jwk);
        }
        if (kty.equals((Object)KeyType.OCT)) {
            return OctJWK.parse(jwk);
        }
        if (kty.equals((Object)KeyType.EC)) {
            return EcJWK.parse(jwk);
        }
        throw new JsonException("Failed to parse json invalid kty parameter");
    }

    protected static JsonValue toJsonValue(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return new JsonValue(mapper.readValue(json, Map.class));
        }
        catch (IOException e) {
            throw new JsonException("Failed to parse json", (Throwable)e);
        }
    }

    public String getX509URL() {
        return this.get(X5U).asString();
    }

    public String getX509Thumbnail() {
        return this.get(X5T).asString();
    }

    public List<String> getX509Chain() {
        return this.get(X5C).asList(String.class);
    }
}

