/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.util.List;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jwk.KeyType;
import org.forgerock.json.jose.jwk.KeyUse;
import org.forgerock.json.jose.jws.SupportedEllipticCurve;
import org.forgerock.util.encode.Base64url;

public class EcJWK
extends JWK {
    private static final String X = "x";
    private static final String Y = "y";
    private static final String D = "d";
    private static final String CURVE = "crv";

    public EcJWK(KeyUse use, String alg, String kid, String x, String y, String d, String curve, String x5u, String x5t, List<String> x5c) {
        super(KeyType.EC, use, alg, kid, x5u, x5t, x5c);
        if (x == null || x.isEmpty()) {
            throw new JsonException("x is required for an EcJWK");
        }
        this.put(X, x);
        if (y == null || y.isEmpty()) {
            throw new JsonException("y is required for an EcJWK");
        }
        this.put(Y, y);
        if (curve == null || curve.isEmpty()) {
            throw new JsonException("curve is required for an EcJWK");
        }
        this.put(CURVE, curve);
        this.put(D, d);
    }

    public EcJWK(KeyUse use, String alg, String kid, String x, String y, String curve, String x5u, String x5t, List<String> x5c) {
        this(use, alg, kid, x, y, null, curve, x5u, x5t, x5c);
    }

    public String getX() {
        return this.get(X).asString();
    }

    public String getY() {
        return this.get(Y).asString();
    }

    public String getD() {
        return this.get(D).asString();
    }

    public String getCurve() {
        return this.get(CURVE).asString();
    }

    public static EcJWK parse(String json) {
        JsonValue jwk = new JsonValue((Object)EcJWK.toJsonValue(json));
        return EcJWK.parse(jwk);
    }

    public static EcJWK parse(JsonValue json) {
        if (json == null) {
            throw new JsonException("Cant parse OctJWK. No json data.");
        }
        KeyType kty = null;
        KeyUse use = null;
        String x = null;
        String y = null;
        String d = null;
        String curve = null;
        String alg = null;
        String kid = null;
        String x5u = null;
        String x5t = null;
        List x5c = null;
        kty = KeyType.getKeyType(json.get("kty").asString());
        if (!kty.equals((Object)KeyType.EC)) {
            throw new JsonException("Invalid key type. Not an EC JWK");
        }
        x = json.get(X).asString();
        y = json.get(Y).asString();
        d = json.get(D).asString();
        curve = json.get(CURVE).asString();
        use = KeyUse.getKeyUse(json.get("use").asString());
        alg = json.get("alg").asString();
        kid = json.get("kid").asString();
        x5u = json.get("x5u").asString();
        x5t = json.get("x5t").asString();
        x5c = json.get("x5c").asList(String.class);
        return new EcJWK(use, alg, kid, x, y, d, curve, x5u, x5t, x5c);
    }

    @Override
    public String toJsonString() {
        return super.toString();
    }

    public ECPublicKey toECPublicKey() {
        try {
            SupportedEllipticCurve curve = SupportedEllipticCurve.forName(this.getCurve());
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            ECPoint point = new ECPoint(new BigInteger(Base64url.decode((String)this.getX())), new BigInteger(Base64url.decode((String)this.getY())));
            return (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(point, curve.getParameters()));
        }
        catch (GeneralSecurityException e) {
            throw new JsonException("Unable to create EC Public Key", (Throwable)e);
        }
    }

    public ECPrivateKey toECPrivateKey() {
        try {
            SupportedEllipticCurve curve = SupportedEllipticCurve.forName(this.getCurve());
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            BigInteger s = new BigInteger(Base64url.decode((String)this.getD()));
            return (ECPrivateKey)keyFactory.generatePrivate(new ECPrivateKeySpec(s, curve.getParameters()));
        }
        catch (GeneralSecurityException e) {
            throw new JsonException("Unable to create EC Private Key", (Throwable)e);
        }
    }

    public KeyPair toKeyPair() {
        return new KeyPair(this.toECPublicKey(), this.toECPrivateKey());
    }
}

