/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.util.Reject;

public final class PatchOperation {
    public static final String FIELD_FIELD = "field";
    public static final String FIELD_FROM = "from";
    public static final String FIELD_OPERATION = "operation";
    public static final String FIELD_VALUE = "value";
    public static final String OPERATION_ADD = "add";
    public static final String OPERATION_INCREMENT = "increment";
    public static final String OPERATION_REMOVE = "remove";
    public static final String OPERATION_REPLACE = "replace";
    public static final String OPERATION_MOVE = "move";
    public static final String OPERATION_COPY = "copy";
    public static final String OPERATION_TRANSFORM = "transform";
    private final JsonPointer field;
    private final JsonPointer from;
    private final String operation;
    private final JsonValue value;
    private JsonValue json;

    public static PatchOperation add(JsonPointer field, Object value) {
        return PatchOperation.operation(OPERATION_ADD, field, value);
    }

    public static PatchOperation add(String field, Object value) {
        return PatchOperation.add(new JsonPointer(field), value);
    }

    public static PatchOperation increment(JsonPointer field, Number amount) {
        return PatchOperation.operation(OPERATION_INCREMENT, field, (Object)amount);
    }

    public static PatchOperation increment(String field, Number amount) {
        return PatchOperation.increment(new JsonPointer(field), amount);
    }

    public static PatchOperation remove(JsonPointer field) {
        return PatchOperation.remove(field, null);
    }

    public static PatchOperation remove(JsonPointer field, Object value) {
        return PatchOperation.operation(OPERATION_REMOVE, field, value);
    }

    public static PatchOperation remove(String field) {
        return PatchOperation.remove(new JsonPointer(field));
    }

    public static PatchOperation remove(String field, Object value) {
        return PatchOperation.remove(new JsonPointer(field), value);
    }

    public static PatchOperation replace(JsonPointer field, Object value) {
        return PatchOperation.operation(OPERATION_REPLACE, field, value);
    }

    public static PatchOperation replace(String field, Object value) {
        return PatchOperation.replace(new JsonPointer(field), value);
    }

    public static PatchOperation move(JsonPointer from, JsonPointer field) {
        return PatchOperation.operation(OPERATION_MOVE, from, field);
    }

    public static PatchOperation move(String from, String field) {
        return PatchOperation.operation(OPERATION_MOVE, new JsonPointer(from), new JsonPointer(field));
    }

    public static PatchOperation copy(JsonPointer from, JsonPointer field) {
        return PatchOperation.operation(OPERATION_COPY, from, field);
    }

    public static PatchOperation copy(String from, String field) {
        return PatchOperation.operation(OPERATION_COPY, new JsonPointer(from), new JsonPointer(field));
    }

    public static PatchOperation transform(JsonPointer field, Object transform) {
        return PatchOperation.operation(OPERATION_TRANSFORM, field, transform);
    }

    public static PatchOperation transform(String field, Object transform) {
        return PatchOperation.operation(OPERATION_TRANSFORM, new JsonPointer(field), transform);
    }

    public static PatchOperation operation(String operation, JsonPointer field, Object value) {
        return new PatchOperation(operation, field, null, JsonValue.json((Object)value), null);
    }

    private static PatchOperation operation(String operation, JsonPointer from, JsonPointer field) {
        return new PatchOperation(operation, field, from, JsonValue.json(null), null);
    }

    public static PatchOperation operation(String operation, String field, Object value) {
        return PatchOperation.operation(operation, new JsonPointer(field), value);
    }

    public static PatchOperation copyOf(PatchOperation operation) {
        return new PatchOperation(operation.getOperation(), operation.getField(), operation.getFrom(), operation.getValue().copy(), operation.toJsonValue().copy());
    }

    public static PatchOperation valueOf(JsonValue json) throws BadRequestException {
        if (!json.isMap()) {
            throw new BadRequestException("The request could not be processed because the provided content is not a valid JSON patch");
        }
        try {
            return new PatchOperation(json.get(FIELD_OPERATION).asString(), (JsonPointer)json.get(FIELD_FIELD).as(JsonValueFunctions.pointer()), (JsonPointer)json.get(FIELD_FROM).as(JsonValueFunctions.pointer()), json.get(FIELD_VALUE), json);
        }
        catch (Exception e) {
            throw new BadRequestException("The request could not be processed because the provided content is not a valid JSON patch: " + e.getMessage(), (Throwable)e);
        }
    }

    public static List<PatchOperation> valueOfList(JsonValue json) throws BadRequestException {
        if (!json.isList()) {
            throw new BadRequestException("The request could not be processed because the provided content is not a JSON array of patch operations");
        }
        ArrayList<PatchOperation> patch = new ArrayList<PatchOperation>(json.size());
        for (JsonValue operation : json) {
            patch.add(PatchOperation.valueOf(operation));
        }
        return patch;
    }

    private PatchOperation(String operation, JsonPointer field, JsonPointer from, JsonValue value, JsonValue json) {
        Reject.checkNotNull((Object)operation, (String)"Cannot instantiate PatchOperation with null 'operation' value");
        Reject.checkNotNull((Object)field, (String)"Cannot instantiate PatchOperation with null 'field' value");
        Reject.checkNotNull((Object)value, (String)"Cannot instantiate PatchOperation with null 'value' value");
        this.operation = operation;
        this.checkOperationType();
        this.field = field;
        this.value = value;
        this.from = from;
        this.json = json;
        if (this.isAdd() || this.isIncrement() || this.isReplace() || this.isTransform()) {
            if (value.isNull()) {
                throw new NullPointerException("No value field provided for '" + operation + "' operation");
            }
            if (from != null) {
                throw new IllegalArgumentException("'" + operation + "' does not accept from field");
            }
            if (this.isIncrement() && !value.isNumber()) {
                throw new IllegalArgumentException("Non-numeric value provided for increment operation");
            }
        } else if (this.isRemove()) {
            if (from != null) {
                throw new IllegalArgumentException("'" + operation + "' does not accept from field");
            }
        } else if (this.isCopy() || this.isMove()) {
            if (from == null || from.isEmpty()) {
                throw new NullPointerException("No from field provided for '" + operation + "' operation");
            }
            if (value.isNotNull()) {
                throw new IllegalArgumentException("'" + operation + "' does not accept value field");
            }
        }
    }

    private void checkOperationType() {
        if (!(this.isAdd() || this.isRemove() || this.isIncrement() || this.isReplace() || this.isTransform() || this.isMove() || this.isCopy())) {
            throw new IllegalArgumentException("Invalid patch operation type " + this.operation);
        }
    }

    public JsonPointer getField() {
        return this.field;
    }

    public JsonPointer getFrom() {
        return this.from;
    }

    public String getOperation() {
        return this.operation;
    }

    public JsonValue getValue() {
        return this.value;
    }

    public boolean isAdd() {
        return this.is(OPERATION_ADD);
    }

    public boolean isIncrement() {
        return this.is(OPERATION_INCREMENT);
    }

    public boolean isRemove() {
        return this.is(OPERATION_REMOVE);
    }

    public boolean isReplace() {
        return this.is(OPERATION_REPLACE);
    }

    public boolean isMove() {
        return this.is(OPERATION_MOVE);
    }

    public boolean isCopy() {
        return this.is(OPERATION_COPY);
    }

    public boolean isTransform() {
        return this.is(OPERATION_TRANSFORM);
    }

    public JsonValue toJsonValue() {
        if (this.json == null) {
            this.json = new JsonValue(new LinkedHashMap());
            this.json.put(FIELD_OPERATION, (Object)this.operation);
            this.json.put(FIELD_FIELD, (Object)this.field.toString());
            if (this.from != null) {
                this.json.put(FIELD_FROM, (Object)this.from.toString());
            }
            if (this.value.isNotNull()) {
                this.json.put(FIELD_VALUE, this.value.getObject());
            }
        }
        return this.json;
    }

    public String toString() {
        return this.toJsonValue().toString();
    }

    private boolean is(String type) {
        return this.operation.equalsIgnoreCase(type);
    }
}

