/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.ConflictException;
import org.forgerock.json.resource.CountPolicy;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.json.resource.SortKey;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.util.encode.Base64;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

public final class MemoryBackend
implements CollectionResourceProvider {
    private static final QueryFilterVisitor<FilterResult, ResourceResponse, JsonPointer> RESOURCE_FILTER = new QueryFilterVisitor<FilterResult, ResourceResponse, JsonPointer>(){

        public FilterResult visitAndFilter(ResourceResponse p, List<QueryFilter<JsonPointer>> subFilters) {
            FilterResult result = FilterResult.TRUE;
            for (QueryFilter<JsonPointer> subFilter : subFilters) {
                FilterResult r = (FilterResult)((Object)subFilter.accept((QueryFilterVisitor)this, (Object)p));
                if (r.ordinal() < result.ordinal()) {
                    result = r;
                }
                if (result != FilterResult.FALSE) continue;
                break;
            }
            return result;
        }

        public FilterResult visitBooleanLiteralFilter(ResourceResponse p, boolean value) {
            return FilterResult.valueOf(value);
        }

        public FilterResult visitContainsFilter(ResourceResponse p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value)) continue;
                if (valueAssertion instanceof String) {
                    String s1 = ((String)valueAssertion).toLowerCase(Locale.ENGLISH);
                    String s2 = ((String)value).toLowerCase(Locale.ENGLISH);
                    if (!s2.contains(s1)) continue;
                    return FilterResult.TRUE;
                }
                if (MemoryBackend.compareValues(valueAssertion, value) != 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        public FilterResult visitEqualsFilter(ResourceResponse p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value) || MemoryBackend.compareValues(valueAssertion, value) != 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        public FilterResult visitExtendedMatchFilter(ResourceResponse p, JsonPointer field, String matchingRuleId, Object valueAssertion) {
            return FilterResult.UNDEFINED;
        }

        public FilterResult visitGreaterThanFilter(ResourceResponse p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value) || MemoryBackend.compareValues(valueAssertion, value) >= 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        public FilterResult visitGreaterThanOrEqualToFilter(ResourceResponse p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value) || MemoryBackend.compareValues(valueAssertion, value) > 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        public FilterResult visitLessThanFilter(ResourceResponse p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value) || MemoryBackend.compareValues(valueAssertion, value) <= 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        public FilterResult visitLessThanOrEqualToFilter(ResourceResponse p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value) || MemoryBackend.compareValues(valueAssertion, value) < 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        public FilterResult visitNotFilter(ResourceResponse p, QueryFilter<JsonPointer> subFilter) {
            switch ((FilterResult)((Object)subFilter.accept((QueryFilterVisitor)this, (Object)p))) {
                case FALSE: {
                    return FilterResult.TRUE;
                }
                case UNDEFINED: {
                    return FilterResult.UNDEFINED;
                }
            }
            return FilterResult.FALSE;
        }

        public FilterResult visitOrFilter(ResourceResponse p, List<QueryFilter<JsonPointer>> subFilters) {
            FilterResult result = FilterResult.FALSE;
            for (QueryFilter<JsonPointer> subFilter : subFilters) {
                FilterResult r = (FilterResult)((Object)subFilter.accept((QueryFilterVisitor)this, (Object)p));
                if (r.ordinal() > result.ordinal()) {
                    result = r;
                }
                if (result != FilterResult.TRUE) continue;
                break;
            }
            return result;
        }

        public FilterResult visitPresentFilter(ResourceResponse p, JsonPointer field) {
            JsonValue value = p.getContent().get(field);
            return FilterResult.valueOf(value != null);
        }

        public FilterResult visitStartsWithFilter(ResourceResponse p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value)) continue;
                if (valueAssertion instanceof String) {
                    String s1 = ((String)valueAssertion).toLowerCase(Locale.ENGLISH);
                    String s2 = ((String)value).toLowerCase(Locale.ENGLISH);
                    if (!s2.startsWith(s1)) continue;
                    return FilterResult.TRUE;
                }
                if (MemoryBackend.compareValues(valueAssertion, value) != 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        private List<Object> getValues(ResourceResponse resource, JsonPointer field) {
            JsonValue value = resource.getContent().get(field);
            if (value == null) {
                return Collections.emptyList();
            }
            if (value.isList()) {
                return value.asList();
            }
            return Collections.singletonList(value.getObject());
        }
    };
    private static final Comparator<Object> VALUE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return MemoryBackend.compareValues(o1, o2);
        }
    };
    private final AtomicLong nextResourceId = new AtomicLong();
    private final Map<String, ResourceResponse> resources = new ConcurrentHashMap<String, ResourceResponse>();
    private final Object writeLock = new Object();

    private static int compareValues(Object v1, Object v2) {
        if (v1 instanceof String && v2 instanceof String) {
            String s1 = (String)v1;
            String s2 = (String)v2;
            return s1.compareToIgnoreCase(s2);
        }
        if (v1 instanceof Number && v2 instanceof Number) {
            Double n1 = ((Number)v1).doubleValue();
            Double n2 = ((Number)v2).doubleValue();
            return n1.compareTo(n2);
        }
        if (v1 instanceof Boolean && v2 instanceof Boolean) {
            Boolean b1 = (Boolean)v1;
            Boolean b2 = (Boolean)v2;
            return b1.compareTo(b2);
        }
        return v1.getClass().getName().compareTo(v2.getClass().getName());
    }

    private static boolean isCompatible(Object v1, Object v2) {
        return v1 instanceof String && v2 instanceof String || v1 instanceof Number && v2 instanceof Number || v1 instanceof Boolean && v2 instanceof Boolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ActionResponse, ResourceException> actionCollection(Context context, ActionRequest request) {
        try {
            if (request.getAction().equals("clear")) {
                int size;
                Object object = this.writeLock;
                synchronized (object) {
                    size = this.resources.size();
                    this.resources.clear();
                }
                JsonValue result = new JsonValue(new LinkedHashMap(1));
                result.put("cleared", (Object)size);
                return Promises.newResultPromise((Object)Responses.newActionResponse(result));
            }
            throw new NotSupportedException("Unrecognized action ID '" + request.getAction() + "'. Supported action IDs: clear");
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    @Override
    public Promise<ActionResponse, ResourceException> actionInstance(Context context, String id, ActionRequest request) {
        NotSupportedException e = new NotSupportedException("Actions are not supported for resource instances");
        return Promises.newExceptionPromise((Exception)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ResourceResponse, ResourceException> createInstance(Context context, CreateRequest request) {
        JsonValue value = request.getContent();
        String id = request.getNewResourceId();
        String rev = "0";
        try {
            ResourceResponse resource;
            while (true) {
                String eid = id != null ? id : String.valueOf(this.nextResourceId.getAndIncrement());
                ResourceResponse tmp = Responses.newResourceResponse(eid, "0", value);
                Object object = this.writeLock;
                synchronized (object) {
                    ResourceResponse existingResource = this.resources.put(eid, tmp);
                    if (existingResource == null) {
                        this.addIdAndRevision(tmp);
                        resource = tmp;
                        break;
                    }
                    if (id != null) {
                        this.resources.put(id, existingResource);
                        throw new PreconditionFailedException("The resource with ID '" + id + "' could not be created because there is already another resource with the same ID");
                    }
                }
            }
            return Promises.newResultPromise((Object)resource);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ResourceResponse, ResourceException> deleteInstance(Context context, String id, DeleteRequest request) {
        String rev = request.getRevision();
        try {
            ResourceResponse resource;
            Object object = this.writeLock;
            synchronized (object) {
                resource = this.getResourceForUpdate(id, rev);
                this.resources.remove(id);
            }
            return Promises.newResultPromise((Object)resource);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ResourceResponse, ResourceException> patchInstance(Context context, String id, PatchRequest request) {
        String rev = request.getRevision();
        try {
            ResourceResponse resource;
            Object object = this.writeLock;
            synchronized (object) {
                ResourceResponse existingResource = this.getResourceForUpdate(id, rev);
                String newRev = this.getNextRevision(existingResource.getRevision());
                JsonValue newContent = existingResource.getContent().copy();
                for (PatchOperation operation : request.getPatchOperations()) {
                    try {
                        JsonValue value;
                        if (operation.isAdd()) {
                            newContent.putPermissive(operation.getField(), operation.getValue().getObject());
                            continue;
                        }
                        if (operation.isRemove()) {
                            Object valueToBeRemoved;
                            if (operation.getValue().isNull()) {
                                newContent.remove(operation.getField());
                                continue;
                            }
                            value = newContent.get(operation.getField());
                            if (value == null) continue;
                            if (value.isList()) {
                                valueToBeRemoved = operation.getValue().getObject();
                                Iterator iterator = value.asList().iterator();
                                while (iterator.hasNext()) {
                                    if (!valueToBeRemoved.equals(iterator.next())) continue;
                                    iterator.remove();
                                }
                                continue;
                            }
                            valueToBeRemoved = operation.getValue().getObject();
                            if (!valueToBeRemoved.equals(value.getObject())) continue;
                            newContent.remove(operation.getField());
                            continue;
                        }
                        if (operation.isReplace()) {
                            newContent.remove(operation.getField());
                            if (operation.getValue().isNull()) continue;
                            newContent.putPermissive(operation.getField(), operation.getValue().getObject());
                            continue;
                        }
                        if (!operation.isIncrement()) continue;
                        value = newContent.get(operation.getField());
                        Number amount = operation.getValue().asNumber();
                        if (value == null) {
                            throw new BadRequestException("The field '" + operation.getField() + "' does not exist");
                        }
                        if (value.isList()) {
                            List elements = value.asList();
                            for (int i = 0; i < elements.size(); ++i) {
                                elements.set(i, this.increment(operation, elements.get(i), amount));
                            }
                            continue;
                        }
                        newContent.put(operation.getField(), this.increment(operation, value.getObject(), amount));
                    }
                    catch (JsonValueException e) {
                        throw new ConflictException("The field '" + operation.getField() + "' does not exist");
                    }
                }
                resource = Responses.newResourceResponse(id, newRev, newContent);
                this.addIdAndRevision(resource);
                this.resources.put(id, resource);
            }
            return Promises.newResultPromise((Object)resource);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    @Override
    public Promise<QueryResponse, ResourceException> queryCollection(Context context, QueryRequest request, QueryResourceHandler handler) {
        int resultCount;
        int firstResultIndex;
        if (request.getQueryId() != null) {
            return new NotSupportedException("Query by ID not supported").asPromise();
        }
        if (request.getQueryExpression() != null) {
            return new NotSupportedException("Query by expression not supported").asPromise();
        }
        QueryFilter<JsonPointer> filter = request.getQueryFilter();
        int pageSize = request.getPageSize();
        String pagedResultsCookie = request.getPagedResultsCookie();
        boolean pagedResultsRequested = pageSize > 0;
        List<SortKey> sortKeys = request.getSortKeys();
        if (pageSize > 0 && pagedResultsCookie != null) {
            if (request.getPagedResultsOffset() > 0) {
                return new BadRequestException("Cookies and offsets are mutually exclusive").asPromise();
            }
            firstResultIndex = Cookie.valueOf(pagedResultsCookie).getLastResultIndex();
        } else {
            firstResultIndex = request.getPagedResultsOffset() > 0 ? request.getPagedResultsOffset() : 0;
        }
        int lastResultIndex = pagedResultsRequested ? firstResultIndex + pageSize : Integer.MAX_VALUE;
        int resultIndex = 0;
        if (sortKeys.isEmpty()) {
            for (ResourceResponse resource : this.resources.values()) {
                if (filter != null && !((FilterResult)((Object)filter.accept(RESOURCE_FILTER, (Object)resource))).toBoolean()) continue;
                if (resultIndex >= firstResultIndex && resultIndex < lastResultIndex) {
                    handler.handleResource(resource);
                }
                ++resultIndex;
            }
            resultCount = this.resources.values().size();
        } else {
            ArrayList<ResourceResponse> results = new ArrayList<ResourceResponse>();
            for (ResourceResponse resource : this.resources.values()) {
                if (filter != null && !((FilterResult)((Object)filter.accept(RESOURCE_FILTER, (Object)resource))).toBoolean()) continue;
                results.add(resource);
            }
            Collections.sort(results, new ResourceComparator(sortKeys));
            for (ResourceResponse resource : results) {
                if (resultIndex >= firstResultIndex && resultIndex < lastResultIndex) {
                    handler.handleResource(resource);
                }
                if (resultIndex >= lastResultIndex) break;
                ++resultIndex;
            }
            resultCount = results.size();
        }
        if (pagedResultsRequested) {
            String nextCookie = resultIndex < this.resources.size() ? new Cookie(lastResultIndex, sortKeys).toBase64() : null;
            switch (request.getTotalPagedResultsPolicy()) {
                case NONE: {
                    return Promises.newResultPromise((Object)Responses.newQueryResponse(nextCookie));
                }
                case EXACT: 
                case ESTIMATE: {
                    return Promises.newResultPromise((Object)Responses.newQueryResponse(nextCookie, CountPolicy.EXACT, resultCount));
                }
            }
            throw new UnsupportedOperationException("totalPagedResultsPolicy: " + request.getTotalPagedResultsPolicy().toString() + " not supported");
        }
        return Promises.newResultPromise((Object)Responses.newQueryResponse());
    }

    @Override
    public Promise<ResourceResponse, ResourceException> readInstance(Context context, String id, ReadRequest request) {
        try {
            ResourceResponse resource = this.resources.get(id);
            if (resource == null) {
                throw new NotFoundException("The resource with ID '" + id + "' could not be read because it does not exist");
            }
            return Promises.newResultPromise((Object)resource);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ResourceResponse, ResourceException> updateInstance(Context context, String id, UpdateRequest request) {
        String rev = request.getRevision();
        try {
            ResourceResponse resource;
            Object object = this.writeLock;
            synchronized (object) {
                ResourceResponse existingResource = this.getResourceForUpdate(id, rev);
                String newRev = this.getNextRevision(existingResource.getRevision());
                resource = Responses.newResourceResponse(id, newRev, request.getContent());
                this.addIdAndRevision(resource);
                this.resources.put(id, resource);
            }
            return Promises.newResultPromise((Object)resource);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    private void addIdAndRevision(ResourceResponse resource) throws ResourceException {
        JsonValue content = resource.getContent();
        try {
            content.asMap().put("_id", resource.getId());
            content.asMap().put("_rev", resource.getRevision());
        }
        catch (JsonValueException e) {
            throw new BadRequestException("The request could not be processed because the provided content is not a JSON object");
        }
    }

    private String getNextRevision(String rev) throws ResourceException {
        try {
            return String.valueOf(Integer.parseInt(rev) + 1);
        }
        catch (NumberFormatException e) {
            throw new InternalServerErrorException("Malformed revision number '" + rev + "' encountered while updating a resource");
        }
    }

    private ResourceResponse getResourceForUpdate(String id, String rev) throws NotFoundException, PreconditionFailedException {
        ResourceResponse existingResource = this.resources.get(id);
        if (existingResource == null) {
            throw new NotFoundException("The resource with ID '" + id + "' could not be updated because it does not exist");
        }
        if (rev != null && !existingResource.getRevision().equals(rev)) {
            throw new PreconditionFailedException("The resource with ID '" + id + "' could not be updated because it does not have the required version");
        }
        return existingResource;
    }

    private Object increment(PatchOperation operation, Object object, Number amount) throws BadRequestException {
        if (object instanceof Long) {
            return (Long)object + amount.longValue();
        }
        if (object instanceof Integer) {
            return (Integer)object + amount.intValue();
        }
        if (object instanceof Float) {
            return Float.valueOf(((Float)object).floatValue() + amount.floatValue());
        }
        if (object instanceof Double) {
            return (Double)object + amount.doubleValue();
        }
        throw new BadRequestException("The field '" + operation.getField() + "' is not a number");
    }

    private static final class ResourceComparator
    implements Comparator<ResourceResponse> {
        private final List<SortKey> sortKeys;

        private ResourceComparator(List<SortKey> sortKeys) {
            this.sortKeys = sortKeys;
        }

        @Override
        public int compare(ResourceResponse r1, ResourceResponse r2) {
            for (SortKey sortKey : this.sortKeys) {
                int result = this.compare(r1, r2, sortKey);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        private int compare(ResourceResponse r1, ResourceResponse r2, SortKey sortKey) {
            List<Object> vs1 = this.getValuesSorted(r1, sortKey.getField());
            List<Object> vs2 = this.getValuesSorted(r2, sortKey.getField());
            if (vs1.isEmpty() && vs2.isEmpty()) {
                return 0;
            }
            if (vs1.isEmpty()) {
                return 1;
            }
            if (vs2.isEmpty()) {
                return -1;
            }
            Object v1 = vs1.get(0);
            Object v2 = vs2.get(0);
            return sortKey.isAscendingOrder() ? MemoryBackend.compareValues(v1, v2) : -MemoryBackend.compareValues(v1, v2);
        }

        private List<Object> getValuesSorted(ResourceResponse resource, JsonPointer field) {
            JsonValue value = resource.getContent().get(field);
            if (value == null) {
                return Collections.emptyList();
            }
            if (value.isList()) {
                ArrayList results = value.asList();
                if (results.size() > 1) {
                    results = new ArrayList(results);
                    Collections.sort(results, VALUE_COMPARATOR);
                }
                return results;
            }
            return Collections.singletonList(value.getObject());
        }
    }

    private static final class Cookie {
        private final List<SortKey> sortKeys;
        private final int lastResultIndex;

        Cookie(int lastResultIndex, List<SortKey> sortKeys) {
            this.sortKeys = sortKeys;
            this.lastResultIndex = lastResultIndex;
        }

        static Cookie valueOf(String base64) {
            String[] splitKeys;
            String decoded = new String(Base64.decode((String)base64));
            String[] split = decoded.split(":");
            int lastOffset = Integer.parseInt(split[0]);
            ArrayList<SortKey> sortKeys = new ArrayList<SortKey>();
            for (String key : splitKeys = split[1].split(",")) {
                if (key.equals("")) continue;
                sortKeys.add(SortKey.valueOf(key));
            }
            return new Cookie(lastOffset, sortKeys);
        }

        String toBase64() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.lastResultIndex).append(":");
            for (int i = 0; i < this.sortKeys.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.sortKeys.get(i).toString());
            }
            return Base64.encode((byte[])buf.toString().getBytes());
        }

        public List<SortKey> getSortKeys() {
            return this.sortKeys;
        }

        public int getLastResultIndex() {
            return this.lastResultIndex;
        }
    }

    private static enum FilterResult {
        FALSE,
        TRUE,
        UNDEFINED;


        static FilterResult valueOf(boolean b) {
            return b ? TRUE : FALSE;
        }

        boolean toBoolean() {
            return this == TRUE;
        }
    }
}

