/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.Filter;
import org.forgerock.json.resource.FilterCondition;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.RequestType;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;

public final class Filters {
    public static FilterCondition and(final Collection<FilterCondition> conditions) {
        return new FilterCondition(){

            @Override
            public boolean matches(Context context, Request request) {
                for (FilterCondition condition : conditions) {
                    if (condition.matches(context, request)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static FilterCondition and(FilterCondition ... conditions) {
        return Filters.and(Arrays.asList(conditions));
    }

    public static Filter conditionalFilter(FilterCondition condition, Filter subFilter) {
        return new ConditionalFilter(condition, subFilter);
    }

    public static FilterCondition matchRequestType(RequestType ... types) {
        return Filters.matchRequestType(EnumSet.copyOf(Arrays.asList(types)));
    }

    public static FilterCondition matchRequestType(final Set<RequestType> types) {
        return new FilterCondition(){

            @Override
            public boolean matches(Context context, Request request) {
                return types.contains((Object)request.getRequestType());
            }
        };
    }

    public static FilterCondition matchResourcePath(final Pattern regex) {
        return new FilterCondition(){

            @Override
            public boolean matches(Context context, Request request) {
                return regex.matcher(request.getResourcePath()).matches();
            }
        };
    }

    public static FilterCondition matchResourcePath(String regex) {
        return Filters.matchResourcePath(Pattern.compile(regex));
    }

    public static FilterCondition not(final FilterCondition condition) {
        return new FilterCondition(){

            @Override
            public boolean matches(Context context, Request request) {
                return !condition.matches(context, request);
            }
        };
    }

    public static FilterCondition or(final Collection<FilterCondition> conditions) {
        return new FilterCondition(){

            @Override
            public boolean matches(Context context, Request request) {
                for (FilterCondition condition : conditions) {
                    if (!condition.matches(context, request)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FilterCondition or(FilterCondition ... conditions) {
        return Filters.or(Arrays.asList(conditions));
    }

    private Filters() {
    }

    private static final class ConditionalFilter
    implements Filter {
        private final FilterCondition condition;
        private final Filter subFilter;

        private ConditionalFilter(FilterCondition condition, Filter filter) {
            this.condition = condition;
            this.subFilter = filter;
        }

        @Override
        public Promise<ActionResponse, ResourceException> filterAction(Context context, ActionRequest request, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                return this.subFilter.filterAction(context, request, next);
            }
            return next.handleAction(context, request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> filterCreate(Context context, CreateRequest request, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                return this.subFilter.filterCreate(context, request, next);
            }
            return next.handleCreate(context, request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> filterDelete(Context context, DeleteRequest request, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                return this.subFilter.filterDelete(context, request, next);
            }
            return next.handleDelete(context, request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> filterPatch(Context context, PatchRequest request, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                return this.subFilter.filterPatch(context, request, next);
            }
            return next.handlePatch(context, request);
        }

        @Override
        public Promise<QueryResponse, ResourceException> filterQuery(Context context, QueryRequest request, QueryResourceHandler handler, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                return this.subFilter.filterQuery(context, request, handler, next);
            }
            return next.handleQuery(context, request, handler);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> filterRead(Context context, ReadRequest request, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                return this.subFilter.filterRead(context, request, next);
            }
            return next.handleRead(context, request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> filterUpdate(Context context, UpdateRequest request, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                return this.subFilter.filterUpdate(context, request, next);
            }
            return next.handleUpdate(context, request);
        }
    }
}

