/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.maintenance;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.Scope;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

@UML(identifier="MD_MaintenanceInformation", specification=Specification.ISO_19115)
public interface MaintenanceInformation {
    @UML(identifier="maintenanceAndUpdateFrequency", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public MaintenanceFrequency getMaintenanceAndUpdateFrequency() {
        return null;
    }

    @UML(identifier="maintenanceDate", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends CitationDate> getMaintenanceDates() {
        return Collections.emptyList();
    }

    @Deprecated
    @UML(identifier="dateOfNextUpdate", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Date getDateOfNextUpdate() {
        Date date = null;
        for (CitationDate citationDate : this.getMaintenanceDates()) {
            Date date2 = citationDate.getDate();
            DateType dateType = citationDate.getDateType();
            if (DateType.NEXT_UPDATE.equals(dateType)) {
                return date2;
            }
            if (date != null) continue;
            date = date2;
        }
        return date;
    }

    @UML(identifier="userDefinedMaintenanceFrequency", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public PeriodDuration getUserDefinedMaintenanceFrequency() {
        return null;
    }

    @UML(identifier="maintenanceScope", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Scope> getMaintenanceScopes() {
        return Collections.emptyList();
    }

    @Deprecated
    @UML(identifier="updateScope", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<ScopeCode> getUpdateScopes() {
        LinkedHashSet<ScopeCode> linkedHashSet = new LinkedHashSet<ScopeCode>();
        this.getMaintenanceScopes().forEach(scope -> linkedHashSet.add(scope.getLevel()));
        return linkedHashSet;
    }

    @Deprecated
    @UML(identifier="updateScopeDescription", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<? extends ScopeDescription> getUpdateScopeDescriptions() {
        for (Scope scope : this.getMaintenanceScopes()) {
            Collection<? extends ScopeDescription> collection = scope.getLevelDescription();
            if (collection == null) continue;
            return collection;
        }
        return Collections.emptyList();
    }

    @UML(identifier="maintenanceNote", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends InternationalString> getMaintenanceNotes() {
        return Collections.emptyList();
    }

    @UML(identifier="contact", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Responsibility> getContacts() {
        return Collections.emptyList();
    }
}

