/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.identification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.opengis.annotation.Classifier;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.Stereotype;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.AssociatedResource;
import org.opengis.metadata.identification.AssociationType;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.identification.InitiativeType;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.identification.Usage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.temporal.Duration;
import org.opengis.util.InternationalString;

@Classifier(value=Stereotype.ABSTRACT)
@UML(identifier="MD_Identification", specification=Specification.ISO_19115)
public interface Identification {
    @UML(identifier="citation", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Citation getCitation();

    @UML(identifier="abstract", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public InternationalString getAbstract();

    @UML(identifier="purpose", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public InternationalString getPurpose() {
        return null;
    }

    @UML(identifier="credit", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends InternationalString> getCredits() {
        return Collections.emptyList();
    }

    @UML(identifier="status", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<Progress> getStatus() {
        return Collections.emptySet();
    }

    @UML(identifier="pointOfContact", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Responsibility> getPointOfContacts() {
        return Collections.emptyList();
    }

    @UML(identifier="spatialRepresentationType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<SpatialRepresentationType> getSpatialRepresentationTypes() {
        return Collections.emptySet();
    }

    @UML(identifier="spatialResolution", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Resolution> getSpatialResolutions() {
        return Collections.emptyList();
    }

    @UML(identifier="temporalResolution", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Duration> getTemporalResolutions() {
        return Collections.emptyList();
    }

    @UML(identifier="topicCategory", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<TopicCategory> getTopicCategories();

    @UML(identifier="extent", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Extent> getExtents();

    @UML(identifier="additionalDocumentation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Citation> getAdditionalDocumentations() {
        return Collections.emptyList();
    }

    @UML(identifier="processingLevel", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Identifier getProcessingLevel() {
        return null;
    }

    @UML(identifier="resourceMaintenance", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends MaintenanceInformation> getResourceMaintenances() {
        return Collections.emptyList();
    }

    @UML(identifier="graphicOverview", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends BrowseGraphic> getGraphicOverviews() {
        return Collections.emptyList();
    }

    @UML(identifier="resourceFormat", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Format> getResourceFormats() {
        return Collections.emptyList();
    }

    @UML(identifier="descriptiveKeywords", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Keywords> getDescriptiveKeywords() {
        return Collections.emptyList();
    }

    @UML(identifier="resourceSpecificUsage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Usage> getResourceSpecificUsages() {
        return Collections.emptyList();
    }

    @UML(identifier="resourceConstraints", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Constraints> getResourceConstraints() {
        return Collections.emptyList();
    }

    @UML(identifier="associatedResource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends AssociatedResource> getAssociatedResources() {
        return Collections.emptyList();
    }

    @Deprecated
    @UML(identifier="aggregationInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<? extends AggregateInformation> getAggregationInfo() {
        ArrayList<1> arrayList = new ArrayList<1>();
        for (final AssociatedResource associatedResource : this.getAssociatedResources()) {
            arrayList.add(new AggregateInformation(){

                @Override
                public Citation getName() {
                    return associatedResource.getName();
                }

                @Override
                public AssociationType getAssociationType() {
                    return associatedResource.getAssociationType();
                }

                @Override
                public InitiativeType getInitiativeType() {
                    return associatedResource.getInitiativeType();
                }

                @Override
                public Citation getMetadataReference() {
                    return associatedResource.getMetadataReference();
                }

                @Override
                public Citation getAggregateDataSetName() {
                    return associatedResource.getName();
                }

                @Override
                public Identifier getAggregateDataSetIdentifier() {
                    Iterator<? extends Identifier> iterator;
                    Citation citation = associatedResource.getName();
                    if (citation != null && (iterator = citation.getIdentifiers().iterator()).hasNext()) {
                        return iterator.next();
                    }
                    return null;
                }
            });
        }
        return arrayList;
    }
}

