/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.MetadataExtensionInformation;
import org.opengis.metadata.MetadataScope;
import org.opengis.metadata.PortrayalCatalogueReference;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@UML(identifier="MD_Metadata", specification=Specification.ISO_19115)
public interface Metadata {
    @UML(identifier="metadataIdentifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Identifier getMetadataIdentifier() {
        return null;
    }

    @Deprecated
    @UML(identifier="fileIdentifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public String getFileIdentifier() {
        Identifier identifier = this.getMetadataIdentifier();
        return identifier != null ? identifier.getCode() : null;
    }

    @UML(identifier="defaultLocale+otherLocale", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    default public Map<Locale, Charset> getLocalesAndCharsets() {
        return Collections.emptyMap();
    }

    @Deprecated
    @UML(identifier="language", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Locale getLanguage() {
        for (Locale locale : this.getLocalesAndCharsets().keySet()) {
            if (locale == null) continue;
            return locale;
        }
        return null;
    }

    @Deprecated
    @UML(identifier="locale", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<Locale> getLocales() {
        Locale locale = null;
        LinkedHashSet<Locale> linkedHashSet = new LinkedHashSet<Locale>();
        for (Locale locale2 : this.getLocalesAndCharsets().keySet()) {
            if (locale == null) {
                locale = locale2;
            }
            linkedHashSet.add(locale2);
        }
        linkedHashSet.remove(locale);
        linkedHashSet.remove(null);
        return linkedHashSet;
    }

    @Deprecated
    @UML(identifier="characterSet", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public CharacterSet getCharacterSet() {
        for (Charset charset : this.getLocalesAndCharsets().values()) {
            if (charset == null) continue;
            return CharacterSet.fromCharset(charset);
        }
        return null;
    }

    @UML(identifier="parentMetadata", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    default public Citation getParentMetadata() {
        return null;
    }

    @Deprecated
    @UML(identifier="parentIdentifier", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    default public String getParentIdentifier() {
        InternationalString internationalString;
        Citation citation = this.getParentMetadata();
        if (citation != null && (internationalString = citation.getTitle()) != null) {
            return internationalString.toString();
        }
        return null;
    }

    @UML(identifier="metadataScope", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<? extends MetadataScope> getMetadataScopes();

    @Deprecated
    @UML(identifier="hierarchyLevel", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<ScopeCode> getHierarchyLevels() {
        LinkedHashSet<ScopeCode> linkedHashSet = new LinkedHashSet<ScopeCode>();
        this.getMetadataScopes().forEach(metadataScope -> linkedHashSet.add(metadataScope.getResourceScope()));
        return linkedHashSet;
    }

    @Deprecated
    @UML(identifier="hierarchyLevelName", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<String> getHierarchyLevelNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        this.getMetadataScopes().forEach(metadataScope -> {
            InternationalString internationalString = metadataScope.getName();
            if (internationalString != null) {
                linkedHashSet.add(internationalString.toString());
            }
        });
        return linkedHashSet;
    }

    @UML(identifier="contact", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<? extends Responsibility> getContacts();

    @UML(identifier="dateInfo", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<? extends CitationDate> getDateInfo();

    @Deprecated
    @UML(identifier="dateStamp", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115, version=2003)
    default public Date getDateStamp() {
        Date date = null;
        for (CitationDate citationDate : this.getDateInfo()) {
            Date date2 = citationDate.getDate();
            DateType dateType = citationDate.getDateType();
            if (DateType.CREATION.equals(dateType)) {
                return date2;
            }
            if (date != null) continue;
            date = date2;
        }
        return date;
    }

    @Deprecated
    @UML(identifier="metadataStandardName", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public String getMetadataStandardName() {
        for (Citation citation : this.getMetadataStandards()) {
            InternationalString internationalString = citation.getTitle();
            if (internationalString == null) continue;
            return internationalString.toString();
        }
        return null;
    }

    @Deprecated
    @UML(identifier="metadataStandardVersion", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public String getMetadataStandardVersion() {
        for (Citation citation : this.getMetadataStandards()) {
            InternationalString internationalString = citation.getEdition();
            if (internationalString == null) continue;
            return internationalString.toString();
        }
        return null;
    }

    @UML(identifier="metadataStandard", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Citation> getMetadataStandards() {
        return Collections.emptyList();
    }

    @UML(identifier="metadataProfile", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Citation> getMetadataProfiles() {
        return Collections.emptyList();
    }

    @UML(identifier="alternativeMetadataReference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Citation> getAlternativeMetadataReferences() {
        return Collections.emptyList();
    }

    @UML(identifier="metadataLinkage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends OnlineResource> getMetadataLinkages() {
        return Collections.emptyList();
    }

    @Deprecated
    @UML(identifier="dataSetURI", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public String getDataSetUri() {
        for (Identification identification : this.getIdentificationInfo()) {
            Citation citation = identification.getCitation();
            if (citation == null) continue;
            for (OnlineResource onlineResource : citation.getOnlineResources()) {
                URI uRI = onlineResource.getLinkage();
                if (uRI == null) continue;
                return uRI.toString();
            }
        }
        return null;
    }

    @UML(identifier="spatialRepresentationInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends SpatialRepresentation> getSpatialRepresentationInfo() {
        return Collections.emptyList();
    }

    @UML(identifier="referenceSystemInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends ReferenceSystem> getReferenceSystemInfo() {
        return Collections.emptyList();
    }

    @UML(identifier="metadataExtensionInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends MetadataExtensionInformation> getMetadataExtensionInfo() {
        return Collections.emptyList();
    }

    @UML(identifier="identificationInfo", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<? extends Identification> getIdentificationInfo();

    @UML(identifier="contentInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends ContentInformation> getContentInfo() {
        return Collections.emptyList();
    }

    @UML(identifier="distributionInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Distribution> getDistributionInfo() {
        return Collections.emptyList();
    }

    @UML(identifier="dataQualityInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends DataQuality> getDataQualityInfo() {
        return Collections.emptyList();
    }

    @UML(identifier="portrayalCatalogueInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends PortrayalCatalogueReference> getPortrayalCatalogueInfo() {
        return Collections.emptyList();
    }

    @UML(identifier="metadataConstraints", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Constraints> getMetadataConstraints() {
        return Collections.emptyList();
    }

    @UML(identifier="applicationSchemaInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends ApplicationSchemaInformation> getApplicationSchemaInfo() {
        return Collections.emptyList();
    }

    @UML(identifier="acquisitionInformation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115_2)
    default public Collection<? extends AcquisitionInformation> getAcquisitionInformation() {
        return Collections.emptyList();
    }

    @UML(identifier="metadataMaintenance", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public MaintenanceInformation getMetadataMaintenance() {
        return null;
    }

    @UML(identifier="resourceLineage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Lineage> getResourceLineages() {
        return Collections.emptyList();
    }
}

