/*$************************************************************************************************
 **
 ** $Id: Constraints.java 1438 2009-07-02 02:42:27Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.3-M2/geoapi/src/main/java/org/opengis/metadata/constraint/Constraints.java $
 **
 ** Copyright (C) 2004-2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.metadata.constraint;

import java.util.Collection;
import org.opengis.util.InternationalString;
import org.opengis.annotation.UML;

import static org.opengis.annotation.Obligation.*;
import static org.opengis.annotation.Specification.*;


/**
 * Restrictions on the access and use of a resource or metadata.
 *
 * @version <A HREF="http://www.opengeospatial.org/standards/as#01-111">ISO 19115</A>
 * @author  Martin Desruisseaux (IRD)
 * @since   GeoAPI 2.0
 */
@UML(identifier="MD_Constraints", specification=ISO_19115)
public interface Constraints {
    /**
     * Limitation affecting the fitness for use of the resource.
     * Example: "not to be used for navigation".
     *
     * @return Limitation affecting the fitness for use of the resource.
     *
     * @deprecated Renamed as {@link #getUseLimitations()} (with an "s").
     */
    @Deprecated
    @UML(identifier="useLimitation", obligation=OPTIONAL, specification=ISO_19115)
    Collection<? extends InternationalString> getUseLimitation();

    /**
     * Limitation affecting the fitness for use of the resource.
     * Example: "not to be used for navigation".
     *
     * @return Limitation affecting the fitness for use of the resource.
     */
    @UML(identifier="useLimitation", obligation=OPTIONAL, specification=ISO_19115)
    Collection<? extends InternationalString> getUseLimitations();
}
