/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.filter;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.opengis.filter.BetweenComparisonOperator;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinarySpatialOperator;
import org.opengis.filter.DistanceOperator;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.LikeOperator;
import org.opengis.filter.Literal;
import org.opengis.filter.LogicalOperator;
import org.opengis.filter.MatchAction;
import org.opengis.filter.NilOperator;
import org.opengis.filter.NullOperator;
import org.opengis.filter.ResourceId;
import org.opengis.filter.SortOrder;
import org.opengis.filter.SortProperty;
import org.opengis.filter.TemporalOperator;
import org.opengis.filter.ValueReference;
import org.opengis.filter.Version;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.geometry.Envelope;
import org.opengis.util.Factory;

public interface FilterFactory<R, G, T>
extends Factory {
    public FilterCapabilities getCapabilities();

    default public ResourceId<R> resourceId(String string) {
        return this.resourceId(string, null, null, null);
    }

    public ResourceId<R> resourceId(String var1, Version var2, Instant var3, Instant var4);

    default public ValueReference<R, ?> property(String string) {
        return this.property(string, Object.class);
    }

    public <V> ValueReference<R, V> property(String var1, Class<V> var2);

    public <V> Literal<R, V> literal(V var1);

    default public BinaryComparisonOperator<R> equal(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return this.equal(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> equal(Expression<? super R, ?> var1, Expression<? super R, ?> var2, boolean var3, MatchAction var4);

    default public BinaryComparisonOperator<R> notEqual(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return this.notEqual(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> notEqual(Expression<? super R, ?> var1, Expression<? super R, ?> var2, boolean var3, MatchAction var4);

    default public BinaryComparisonOperator<R> less(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return this.less(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> less(Expression<? super R, ?> var1, Expression<? super R, ?> var2, boolean var3, MatchAction var4);

    default public BinaryComparisonOperator<R> greater(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return this.greater(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> greater(Expression<? super R, ?> var1, Expression<? super R, ?> var2, boolean var3, MatchAction var4);

    default public BinaryComparisonOperator<R> lessOrEqual(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return this.lessOrEqual(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> lessOrEqual(Expression<? super R, ?> var1, Expression<? super R, ?> var2, boolean var3, MatchAction var4);

    default public BinaryComparisonOperator<R> greaterOrEqual(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return this.greaterOrEqual(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> greaterOrEqual(Expression<? super R, ?> var1, Expression<? super R, ?> var2, boolean var3, MatchAction var4);

    public BetweenComparisonOperator<R> between(Expression<? super R, ?> var1, Expression<? super R, ?> var2, Expression<? super R, ?> var3);

    default public LikeOperator<R> like(Expression<? super R, ?> expression, String string) {
        return this.like(Objects.requireNonNull(expression), Objects.requireNonNull(string), '%', '_', '\\', true);
    }

    public LikeOperator<R> like(Expression<? super R, ?> var1, String var2, char var3, char var4, char var5, boolean var6);

    public NullOperator<R> isNull(Expression<? super R, ?> var1);

    public NilOperator<R> isNil(Expression<? super R, ?> var1, String var2);

    default public LogicalOperator<R> and(Filter<? super R> filter, Filter<? super R> filter2) {
        return this.and(Arrays.asList(Objects.requireNonNull(filter), Objects.requireNonNull(filter2)));
    }

    public LogicalOperator<R> and(Collection<? extends Filter<? super R>> var1);

    default public LogicalOperator<R> or(Filter<? super R> filter, Filter<? super R> filter2) {
        return this.or(Arrays.asList(Objects.requireNonNull(filter), Objects.requireNonNull(filter2)));
    }

    public LogicalOperator<R> or(Collection<? extends Filter<? super R>> var1);

    public LogicalOperator<R> not(Filter<? super R> var1);

    public BinarySpatialOperator<R> bbox(Expression<? super R, ? extends G> var1, Envelope var2);

    public BinarySpatialOperator<R> equals(Expression<? super R, ? extends G> var1, Expression<? super R, ? extends G> var2);

    public BinarySpatialOperator<R> disjoint(Expression<? super R, ? extends G> var1, Expression<? super R, ? extends G> var2);

    public BinarySpatialOperator<R> intersects(Expression<? super R, ? extends G> var1, Expression<? super R, ? extends G> var2);

    public BinarySpatialOperator<R> touches(Expression<? super R, ? extends G> var1, Expression<? super R, ? extends G> var2);

    public BinarySpatialOperator<R> crosses(Expression<? super R, ? extends G> var1, Expression<? super R, ? extends G> var2);

    public BinarySpatialOperator<R> within(Expression<? super R, ? extends G> var1, Expression<? super R, ? extends G> var2);

    public BinarySpatialOperator<R> contains(Expression<? super R, ? extends G> var1, Expression<? super R, ? extends G> var2);

    public BinarySpatialOperator<R> overlaps(Expression<? super R, ? extends G> var1, Expression<? super R, ? extends G> var2);

    public DistanceOperator<R> beyond(Expression<? super R, ? extends G> var1, Expression<? super R, ? extends G> var2, Quantity<Length> var3);

    public DistanceOperator<R> within(Expression<? super R, ? extends G> var1, Expression<? super R, ? extends G> var2, Quantity<Length> var3);

    public TemporalOperator<R> after(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> before(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> begins(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> begunBy(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> tcontains(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> during(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> tequals(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> toverlaps(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> meets(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> ends(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> overlappedBy(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> metBy(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> endedBy(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public TemporalOperator<R> anyInteracts(Expression<? super R, ? extends T> var1, Expression<? super R, ? extends T> var2);

    public Expression<R, Number> add(Expression<? super R, ? extends Number> var1, Expression<? super R, ? extends Number> var2);

    public Expression<R, Number> subtract(Expression<? super R, ? extends Number> var1, Expression<? super R, ? extends Number> var2);

    public Expression<R, Number> multiply(Expression<? super R, ? extends Number> var1, Expression<? super R, ? extends Number> var2);

    public Expression<R, Number> divide(Expression<? super R, ? extends Number> var1, Expression<? super R, ? extends Number> var2);

    default public Expression<R, ?> function(String string, Expression<? super R, ?> expression) {
        return this.function(string, new Expression[]{Objects.requireNonNull(expression)});
    }

    default public Expression<R, ?> function(String string, Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return this.function(string, new Expression[]{Objects.requireNonNull(expression), Objects.requireNonNull(expression2)});
    }

    public Expression<R, ?> function(String var1, Expression<? super R, ?>[] var2);

    public SortProperty<R> sort(ValueReference<? super R, ?> var1, SortOrder var2);
}

