/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.util;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.util.ControlledVocabulary;

@UML(identifier="CodeList", specification=Specification.ISO_19103)
public abstract class CodeList<E extends CodeList<E>>
implements ControlledVocabulary,
Comparable<E>,
Serializable {
    private static final long serialVersionUID = 5655809691319522885L;
    private static final Map<Class<? extends CodeList<?>>, Collection<? extends CodeList<?>>> VALUES = new HashMap();
    private static final Class<String>[] CONSTRUCTOR_PARAMETERS = new Class[]{String.class};
    private final transient int ordinal;
    private final String name;
    private transient String identifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CodeList(String string, Collection<E> collection) {
        Collection<E> collection2;
        this.name = string = string.trim();
        Object object = collection;
        synchronized (object) {
            this.ordinal = collection.size();
            if (!collection.add(this)) {
                throw new IllegalArgumentException("Duplicated value: " + string);
            }
        }
        object = this.getClass();
        Map<Class<? extends CodeList<?>>, Collection<? extends CodeList<?>>> map = VALUES;
        synchronized (map) {
            collection2 = VALUES.putIfAbsent((Class<CodeList<?>>)object, (Collection<CodeList<?>>)collection);
        }
        if (collection2 != null && collection2 != collection) {
            throw new IllegalArgumentException("List already exists: " + collection);
        }
    }

    public static <T extends CodeList<T>> T valueOf(Class<T> clazz, String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        String string2 = string.trim();
        return CodeList.valueOf(clazz, codeList -> string2.equals(codeList.name), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CodeList<T>> T valueOf(Class<T> clazz, Predicate<CodeList<?>> predicate, String string) {
        Constructor<T> constructor;
        Collection<CodeList<?>> collection;
        Object object = VALUES;
        synchronized (object) {
            collection = VALUES.get(clazz);
            if (collection == null) {
                if (clazz == null) {
                    throw new IllegalArgumentException("Code type is null");
                }
                constructor = clazz.getName();
                try {
                    Class.forName((String)((Object)constructor), true, clazz.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new TypeNotPresentException((String)((Object)constructor), classNotFoundException);
                }
                collection = VALUES.get(clazz);
                if (collection == null) {
                    throw new IllegalStateException("No list of " + clazz.getSimpleName());
                }
            }
        }
        object = collection;
        synchronized (object) {
            for (CodeList object2 : collection) {
                if (!predicate.test(object2)) continue;
                return (T)((CodeList)clazz.cast(object2));
            }
            if (string == null || Modifier.isAbstract(clazz.getModifiers())) {
                return null;
            }
            try {
                constructor = clazz.getDeclaredConstructor(CONSTRUCTOR_PARAMETERS);
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    Package package_ = clazz.getPackage();
                    if (package_ != null && package_.getName().startsWith("org.opengis.")) {
                        AccessController.doPrivileged(() -> {
                            constructor.setAccessible(true);
                            return null;
                        });
                    } else {
                        constructor.setAccessible(true);
                    }
                }
                return (T)((CodeList)constructor.newInstance(string));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new IllegalArgumentException("Can not create code of type " + clazz.getSimpleName(), reflectiveOperationException);
            }
        }
    }

    public abstract E[] family();

    @Override
    public String[] names() {
        String string = this.name;
        String string2 = this.identifier();
        if (string2 != null && !string2.equals(string)) {
            return new String[]{string, string2};
        }
        return new String[]{string};
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public String identifier() {
        String string = this.identifier;
        if (string == null) {
            Field field;
            Class<?> clazz = this.getClass();
            try {
                field = clazz.getField(this.name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = null;
            }
            if (field != null && Modifier.isStatic(field.getModifiers())) {
                UML uML;
                Object object;
                try {
                    object = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
                if (this.equals(object) && (uML = field.getAnnotation(UML.class)) != null) {
                    string = uML.identifier();
                }
            }
            string = string == null ? "" : string.intern();
            this.identifier = string;
        }
        return string.length() != 0 ? string : null;
    }

    @Override
    public final int ordinal() {
        return this.ordinal;
    }

    @Override
    public final int compareTo(E e) {
        Class<?> clazz;
        Class<?> clazz2 = this.getClass();
        if (!clazz2.equals(clazz = e.getClass())) {
            throw new ClassCastException("Can't compare " + clazz2.getSimpleName() + " to " + clazz.getSimpleName());
        }
        return this.ordinal - ((CodeList)e).ordinal;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.name + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readResolve() throws ObjectStreamException {
        Collection<CodeList<?>> collection;
        Class<?> clazz = this.getClass();
        Object object = VALUES;
        synchronized (object) {
            collection = VALUES.get(clazz);
        }
        if (collection != null) {
            object = collection;
            synchronized (object) {
                for (CodeList<?> codeList : collection) {
                    if (!clazz.isInstance(codeList)) {
                        return this;
                    }
                    if (!codeList.name.equals(this.name)) continue;
                    return codeList;
                }
                Collection<CodeList<?>> collection2 = collection;
                if (!collection2.add(this)) {
                    throw new InvalidObjectException(this.name);
                }
            }
        }
        return this;
    }
}

