/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Medium;
import org.opengis.util.InternationalString;

@UML(identifier="MD_Format", specification=Specification.ISO_19115)
public interface Format {
    @UML(identifier="formatSpecificationCitation", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Citation getFormatSpecificationCitation();

    @Deprecated
    @UML(identifier="specification", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public InternationalString getSpecification() {
        Citation citation = this.getFormatSpecificationCitation();
        return citation != null ? citation.getTitle() : null;
    }

    @Deprecated
    @UML(identifier="name", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115, version=2003)
    default public InternationalString getName() {
        Iterator<? extends InternationalString> iterator;
        Citation citation = this.getFormatSpecificationCitation();
        if (citation != null && (iterator = citation.getAlternateTitles().iterator()).hasNext()) {
            iterator.next();
        }
        return null;
    }

    @Deprecated
    @UML(identifier="version", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115, version=2003)
    default public InternationalString getVersion() {
        Citation citation = this.getFormatSpecificationCitation();
        return citation != null ? citation.getEdition() : null;
    }

    @UML(identifier="amendmentNumber", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public InternationalString getAmendmentNumber() {
        return null;
    }

    @UML(identifier="fileDecompressionTechnique", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public InternationalString getFileDecompressionTechnique() {
        return null;
    }

    @UML(identifier="medium", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Medium> getMedia() {
        return Collections.emptyList();
    }

    @UML(identifier="formatDistributor", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Distributor> getFormatDistributors() {
        return Collections.emptyList();
    }
}

