/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.geometry;

import java.util.Set;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.geometry.Boundary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@UML(identifier="GM_Object", specification=Specification.ISO_19107)
public interface Geometry
extends TransfiniteSet {
    @UML(identifier="CRS", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    @UML(identifier="mbRegion", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Geometry getMbRegion();

    @UML(identifier="representativePoint", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public DirectPosition getRepresentativePoint();

    @UML(identifier="boundary", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Boundary getBoundary();

    @UML(identifier="closure", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Complex getClosure();

    @UML(identifier="isSimple", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public boolean isSimple();

    @UML(identifier="isCycle", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public boolean isCycle();

    @UML(identifier="distance", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public double distance(Geometry var1);

    @UML(identifier="dimension", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public int getDimension(DirectPosition var1);

    @UML(identifier="coordinateDimension", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public int getCoordinateDimension();

    @UML(identifier="maximalComplex", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Set<? extends Complex> getMaximalComplex();

    @UML(identifier="transform", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Geometry transform(CoordinateReferenceSystem var1) throws TransformException;

    @UML(identifier="envelope", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Envelope getEnvelope();

    @UML(identifier="centroid", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public DirectPosition getCentroid();

    @UML(identifier="convexHull", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Geometry getConvexHull();

    @UML(identifier="buffer", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Geometry getBuffer(double var1);
}

