/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.distribution;

import java.util.Collection;
import java.util.Collections;
import javax.measure.Unit;
import org.opengis.annotation.Classifier;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.Stereotype;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.MediumFormat;
import org.opengis.util.InternationalString;

@Classifier(value=Stereotype.DATATYPE)
@UML(identifier="MD_Medium", specification=Specification.ISO_19115)
public interface Medium {
    @UML(identifier="name", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Citation getName() {
        return null;
    }

    @UML(identifier="density", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Double getDensity() {
        return null;
    }

    @Deprecated
    default public Collection<Double> getDensities() {
        Double d = this.getDensity();
        return d != null ? Collections.singleton(d) : Collections.emptySet();
    }

    @UML(identifier="densityUnits", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    default public Unit<?> getDensityUnits() {
        return null;
    }

    @UML(identifier="volumes", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Integer getVolumes() {
        return null;
    }

    @UML(identifier="mediumFormat", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<MediumFormat> getMediumFormats() {
        return Collections.emptySet();
    }

    @UML(identifier="mediumNote", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public InternationalString getMediumNote() {
        return null;
    }

    @UML(identifier="identifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Identifier getIdentifier() {
        return null;
    }
}

