/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.referencing;

import java.awt.geom.Point2D;
import java.util.Arrays;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class SimpleDirectPosition
implements DirectPosition {
    protected final double[] ordinates;

    public SimpleDirectPosition(int n) {
        this.ordinates = new double[n];
    }

    public SimpleDirectPosition(Point2D point2D) {
        this.ordinates = new double[]{point2D.getX(), point2D.getY()};
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    public int getDimension() {
        return this.ordinates.length;
    }

    public double[] getCoordinate() {
        return (double[])this.ordinates.clone();
    }

    @Deprecated
    public double[] getCoordinates() {
        return (double[])this.ordinates.clone();
    }

    public double getOrdinate(int n) throws IndexOutOfBoundsException {
        return this.ordinates[n];
    }

    public void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        this.ordinates[n] = d;
    }

    public DirectPosition getDirectPosition() {
        return this;
    }

    public boolean equals(Object object) {
        DirectPosition directPosition;
        if (object instanceof DirectPosition && (directPosition = (DirectPosition)object).getCoordinateReferenceSystem() == null) {
            return Arrays.equals(this.ordinates, directPosition.getCoordinate());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.ordinates);
    }

    public String toString() {
        return Arrays.toString(this.ordinates);
    }
}

