/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.referencing;

import java.util.Date;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.test.Assert;
import org.opengis.test.ValidatorContainer;
import org.opengis.test.referencing.ReferencingValidator;

public class DatumValidator
extends ReferencingValidator {
    public DatumValidator(ValidatorContainer validatorContainer) {
        super(validatorContainer, "org.opengis.referencing.datum");
    }

    public void dispatch(Datum datum) {
        if (datum instanceof GeodeticDatum) {
            this.validate((GeodeticDatum)datum);
        } else if (datum instanceof VerticalDatum) {
            this.validate((VerticalDatum)datum);
        } else if (datum instanceof TemporalDatum) {
            this.validate((TemporalDatum)datum);
        } else if (datum instanceof ImageDatum) {
            this.validate((ImageDatum)datum);
        } else if (datum instanceof EngineeringDatum) {
            this.validate((EngineeringDatum)datum);
        } else {
            this.validateIdentifiedObject((IdentifiedObject)datum);
        }
    }

    public void validate(PrimeMeridian primeMeridian) {
        if (primeMeridian == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)primeMeridian);
        Unit unit = primeMeridian.getAngularUnit();
        this.mandatory("PrimeMeridian: must have a unit of measurement.", unit);
        if (unit != null) {
            Assert.assertTrue((String)"PrimeMeridian: unit must be compatible with degrees.", (boolean)unit.isCompatible(NonSI.DEGREE_ANGLE));
        }
        double d = primeMeridian.getGreenwichLongitude();
        if (unit != null) {
            d = unit.getConverterTo(NonSI.DEGREE_ANGLE).convert(d);
        }
        Assert.assertBetween("PrimeMeridian: expected longitude in [-180 ... +180\u00b0] range.", -180.0, 180.0, d);
    }

    public void validate(Ellipsoid ellipsoid) {
        if (ellipsoid == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)ellipsoid);
        Unit unit = ellipsoid.getAxisUnit();
        this.mandatory("Ellipsoid: must have a unit of measurement.", unit);
        if (unit != null) {
            Assert.assertTrue((String)"Ellipsoid: unit must be compatible with metres.", (boolean)unit.isCompatible((Unit)SI.METRE));
        }
        double d = ellipsoid.getSemiMajorAxis();
        double d2 = ellipsoid.getSemiMinorAxis();
        Assert.assertTrue((String)"Ellipsoid: expected semi-minor <= semi-major axis length.", (d2 <= d ? 1 : 0) != 0);
    }

    public void validate(GeodeticDatum geodeticDatum) {
        if (geodeticDatum == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)geodeticDatum);
        PrimeMeridian primeMeridian = geodeticDatum.getPrimeMeridian();
        this.mandatory("GeodeticDatum: must have a prime meridian.", primeMeridian);
        this.validate(primeMeridian);
        Ellipsoid ellipsoid = geodeticDatum.getEllipsoid();
        this.mandatory("GeodeticDatum: must have an ellipsoid.", ellipsoid);
        this.validate(ellipsoid);
    }

    public void validate(VerticalDatum verticalDatum) {
        if (verticalDatum == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)verticalDatum);
        VerticalDatumType verticalDatumType = verticalDatum.getVerticalDatumType();
        this.mandatory("VerticalDatum: must have a datum type.", verticalDatumType);
    }

    public void validate(TemporalDatum temporalDatum) {
        if (temporalDatum == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)temporalDatum);
        Date date = temporalDatum.getOrigin();
        this.mandatory("TemporalDatum: expected an origin.", date);
        Assert.assertNull((String)"TemporalDatum: should not have anchor point.", (Object)temporalDatum.getAnchorPoint());
        Assert.assertNull((String)"TemporalDatum: should not have realization epoch.", (Object)temporalDatum.getRealizationEpoch());
    }

    public void validate(ImageDatum imageDatum) {
        if (imageDatum == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)imageDatum);
        PixelInCell pixelInCell = imageDatum.getPixelInCell();
        this.mandatory("ImageDatum: must specify PixelInCell.", pixelInCell);
    }

    public void validate(EngineeringDatum engineeringDatum) {
        if (engineeringDatum == null) {
            return;
        }
        this.validateIdentifiedObject((IdentifiedObject)engineeringDatum);
    }
}

