/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.referencing;

import java.util.HashSet;
import java.util.Set;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.test.Assert;
import org.opengis.test.ValidatorContainer;
import org.opengis.test.referencing.ReferencingValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSValidator
extends ReferencingValidator {
    private final ThreadLocal<Boolean> VALIDATING = new ThreadLocal();

    public CRSValidator(ValidatorContainer validatorContainer) {
        super(validatorContainer, "org.opengis.referencing.crs");
    }

    public void dispatch(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof GeocentricCRS) {
            this.validate((GeocentricCRS)coordinateReferenceSystem);
        } else if (coordinateReferenceSystem instanceof GeographicCRS) {
            this.validate((GeographicCRS)coordinateReferenceSystem);
        } else if (coordinateReferenceSystem instanceof ProjectedCRS) {
            this.validate((ProjectedCRS)coordinateReferenceSystem);
        } else if (coordinateReferenceSystem instanceof DerivedCRS) {
            this.validate((DerivedCRS)coordinateReferenceSystem);
        } else if (coordinateReferenceSystem instanceof ImageCRS) {
            this.validate((ImageCRS)coordinateReferenceSystem);
        } else if (coordinateReferenceSystem instanceof EngineeringCRS) {
            this.validate((EngineeringCRS)coordinateReferenceSystem);
        } else if (coordinateReferenceSystem instanceof VerticalCRS) {
            this.validate((VerticalCRS)coordinateReferenceSystem);
        } else if (coordinateReferenceSystem instanceof TemporalCRS) {
            this.validate((TemporalCRS)coordinateReferenceSystem);
        } else if (coordinateReferenceSystem != null) {
            this.validateReferenceSystem((ReferenceSystem)coordinateReferenceSystem);
            this.container.cs.dispatch(coordinateReferenceSystem.getCoordinateSystem());
        }
    }

    public void validate(GeocentricCRS geocentricCRS) {
        Object object;
        if (geocentricCRS == null) {
            return;
        }
        this.validateReferenceSystem((ReferenceSystem)geocentricCRS);
        CoordinateSystem coordinateSystem = geocentricCRS.getCoordinateSystem();
        this.mandatory("GeocentricCRS: must have a CoordinateSystem.", coordinateSystem);
        if (coordinateSystem instanceof CartesianCS) {
            this.container.cs.validate((CartesianCS)coordinateSystem);
            object = this.getAxisDirections(coordinateSystem);
            Assert.assertTrue((String)"GeocentricCRS: expected Geocentric X axis direction.", (boolean)object.remove(AxisDirection.GEOCENTRIC_X));
            Assert.assertTrue((String)"GeocentricCRS: expected Geocentric Y axis direction.", (boolean)object.remove(AxisDirection.GEOCENTRIC_Y));
            Assert.assertTrue((String)"GeocentricCRS: expected Geocentric Z axis direction.", (boolean)object.remove(AxisDirection.GEOCENTRIC_Z));
            Assert.assertTrue((String)"GeocentricCRS: unknown axis direction.", (boolean)object.isEmpty());
        } else if (coordinateSystem instanceof SphericalCS) {
            this.container.cs.validate((SphericalCS)coordinateSystem);
        } else if (coordinateSystem != null) {
            Assert.fail((String)("GeocentricCRS: unknown CoordinateSystem of type " + coordinateSystem.getClass().getCanonicalName() + '.'));
        }
        object = geocentricCRS.getDatum();
        this.mandatory("GeocentricCRS: must have a Datum.", object);
        this.container.datum.validate((GeodeticDatum)object);
    }

    public void validate(GeographicCRS geographicCRS) {
        if (geographicCRS == null) {
            return;
        }
        this.validateReferenceSystem((ReferenceSystem)geographicCRS);
        EllipsoidalCS ellipsoidalCS = geographicCRS.getCoordinateSystem();
        this.mandatory("GeographicCRS: must have a CoordinateSystem.", ellipsoidalCS);
        this.container.cs.validate(ellipsoidalCS);
        GeodeticDatum geodeticDatum = geographicCRS.getDatum();
        this.mandatory("GeographicCRS: must have a Datum.", geodeticDatum);
        this.container.datum.validate(geodeticDatum);
    }

    public void validate(ProjectedCRS projectedCRS) {
        if (projectedCRS == null) {
            return;
        }
        this.validateReferenceSystem((ReferenceSystem)projectedCRS);
        GeographicCRS geographicCRS = projectedCRS.getBaseCRS();
        this.mandatory("ProjectedCRS: must have a base CRS.", geographicCRS);
        this.validate(geographicCRS);
        CartesianCS cartesianCS = projectedCRS.getCoordinateSystem();
        this.mandatory("ProjectedCRS: must have a CoordinateSystem.", cartesianCS);
        this.container.cs.validate(cartesianCS);
        GeodeticDatum geodeticDatum = projectedCRS.getDatum();
        this.mandatory("ProjectedCRS: must have a Datum.", geodeticDatum);
        this.container.datum.validate(geodeticDatum);
        this.validateGeneralDerivedCRS((GeneralDerivedCRS)projectedCRS);
    }

    public void validate(DerivedCRS derivedCRS) {
        if (derivedCRS == null) {
            return;
        }
        this.validateReferenceSystem((ReferenceSystem)derivedCRS);
        CoordinateReferenceSystem coordinateReferenceSystem = derivedCRS.getBaseCRS();
        this.mandatory("DerivedCRS: must have a base CRS.", coordinateReferenceSystem);
        this.dispatch(coordinateReferenceSystem);
        CoordinateSystem coordinateSystem = derivedCRS.getCoordinateSystem();
        this.mandatory("DerivedCRS: must have a CoordinateSystem.", coordinateSystem);
        this.container.cs.dispatch(coordinateSystem);
        Datum datum = derivedCRS.getDatum();
        this.mandatory("DerivedCRS: must have a Datum.", datum);
        this.container.datum.dispatch(datum);
        this.validateGeneralDerivedCRS((GeneralDerivedCRS)derivedCRS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateGeneralDerivedCRS(GeneralDerivedCRS generalDerivedCRS) {
        if (!Boolean.TRUE.equals(this.VALIDATING.get())) {
            try {
                this.VALIDATING.set(Boolean.TRUE);
                Conversion conversion = generalDerivedCRS.getConversionFromBase();
                if (conversion != null) {
                    this.container.coordinateOperation.validate(conversion);
                    CoordinateReferenceSystem coordinateReferenceSystem = generalDerivedCRS.getBaseCRS();
                    CoordinateReferenceSystem coordinateReferenceSystem2 = conversion.getSourceCRS();
                    CoordinateReferenceSystem coordinateReferenceSystem3 = conversion.getTargetCRS();
                    if (coordinateReferenceSystem != null && coordinateReferenceSystem2 != null) {
                        Assert.assertSame((String)"GeneralDerivedCRS: The base CRS should be the source CRS of the conversion.", (Object)coordinateReferenceSystem, (Object)coordinateReferenceSystem2);
                    }
                    if (coordinateReferenceSystem3 != null) {
                        Assert.assertSame((String)"GeneralDerivedCRS: The derived CRS should be the target CRS of the conversion.", (Object)generalDerivedCRS, (Object)coordinateReferenceSystem3);
                    }
                }
            }
            finally {
                this.VALIDATING.set(Boolean.FALSE);
            }
        }
    }

    public void validate(ImageCRS imageCRS) {
        if (imageCRS == null) {
            return;
        }
        this.validateReferenceSystem((ReferenceSystem)imageCRS);
        AffineCS affineCS = imageCRS.getCoordinateSystem();
        this.mandatory("ImageCRS: must have a CoordinateSystem.", affineCS);
        this.container.cs.dispatch((CoordinateSystem)affineCS);
        ImageDatum imageDatum = imageCRS.getDatum();
        this.mandatory("ImageCRS: must have a Datum.", imageDatum);
        this.container.datum.validate(imageDatum);
    }

    public void validate(EngineeringCRS engineeringCRS) {
        if (engineeringCRS == null) {
            return;
        }
        this.validateReferenceSystem((ReferenceSystem)engineeringCRS);
        CoordinateSystem coordinateSystem = engineeringCRS.getCoordinateSystem();
        this.mandatory("EngineeringCRS: must have a CoordinateSystem.", coordinateSystem);
        this.container.cs.dispatch(coordinateSystem);
        EngineeringDatum engineeringDatum = engineeringCRS.getDatum();
        this.mandatory("EngineeringCRS: must have a Datum.", engineeringDatum);
        this.container.datum.dispatch((Datum)engineeringDatum);
    }

    public void validate(VerticalCRS verticalCRS) {
        if (verticalCRS == null) {
            return;
        }
        this.validateReferenceSystem((ReferenceSystem)verticalCRS);
        VerticalCS verticalCS = verticalCRS.getCoordinateSystem();
        this.mandatory("VerticalCRS: must have a CoordinateSystem.", verticalCS);
        this.container.cs.validate(verticalCS);
        VerticalDatum verticalDatum = verticalCRS.getDatum();
        this.mandatory("VerticalCRS: must have a Datum.", verticalDatum);
        this.container.datum.validate(verticalDatum);
    }

    public void validate(TemporalCRS temporalCRS) {
        if (temporalCRS == null) {
            return;
        }
        this.validateReferenceSystem((ReferenceSystem)temporalCRS);
        TimeCS timeCS = temporalCRS.getCoordinateSystem();
        this.mandatory("TemporalCRS: must have a CoordinateSystem.", timeCS);
        this.container.cs.validate(timeCS);
        TemporalDatum temporalDatum = temporalCRS.getDatum();
        this.mandatory("TemporalCRS: must have a Datum.", temporalDatum);
        this.container.datum.validate(temporalDatum);
    }

    private Set<AxisDirection> getAxisDirections(CoordinateSystem coordinateSystem) {
        int n = coordinateSystem.getDimension();
        HashSet<AxisDirection> hashSet = new HashSet<AxisDirection>(n * 4 / 3 + 1);
        for (int i = 0; i < n; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            if (coordinateSystemAxis == null) continue;
            AxisDirection axisDirection = coordinateSystemAxis.getDirection();
            this.mandatory("Axis must have a direction.", axisDirection);
            if (axisDirection == null || hashSet.add(axisDirection)) continue;
            Assert.fail((String)("CoordinateSystem: duplicated axis direction for " + axisDirection));
        }
        return hashSet;
    }
}

