/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.revextensions2;

import android.app.Activity;
import com.qualcomm.hardware.lynx.LynxController;
import com.qualcomm.hardware.lynx.LynxDcMotorController;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxServoController;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.DcMotorEx;
import com.qualcomm.robotcore.hardware.DcMotorImplEx;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.Servo;
import com.qualcomm.robotcore.hardware.ServoControllerEx;
import com.qualcomm.robotcore.hardware.ServoImplEx;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.ServoConfigurationType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.firstinspires.ftc.robotcore.internal.opmode.OpModeManagerImpl;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.openftc.revextensions2.ExpansionHubEx;
import org.openftc.revextensions2.ExpansionHubMotor;
import org.openftc.revextensions2.ExpansionHubServo;
import org.openftc.revextensions2.RE2Exception;

class Utils {
    Utils() {
    }

    static OpModeManagerImpl getOpModeManager() {
        return OpModeManagerImpl.getOpModeManagerOfActivity((Activity)AppUtil.getInstance().getRootActivity());
    }

    static HardwareMap getHardwareMap() {
        return Utils.getOpModeManager().getHardwareMap();
    }

    static void hotswapHardwareMap() {
        HardwareMap map = Utils.getHardwareMap();
        Utils.swapStandardMotorsForLynx(map);
        Utils.swapStandardServosForLynx(map);
        Utils.addExpansionHubExForEachLynxModule(map);
    }

    static void deswapHardwareMap() {
        HardwareMap map = Utils.getHardwareMap();
        Utils.deswapLynxMotors(map);
        Utils.deswapLynxServos(map);
        Utils.removeExpansionHubExForEachLynxModule(map);
    }

    private static void swapStandardMotorsForLynx(HardwareMap map) {
        ArrayList<Map.Entry> motorsToRecreateAsLynx = new ArrayList<Map.Entry>();
        for (Map.Entry entry : map.dcMotor.entrySet()) {
            if (entry.getValue() instanceof ExpansionHubMotor || !(entry.getValue() instanceof DcMotorEx) || !(((DcMotor)entry.getValue()).getController() instanceof LynxDcMotorController)) continue;
            motorsToRecreateAsLynx.add(entry);
        }
        if (!motorsToRecreateAsLynx.isEmpty()) {
            for (Map.Entry entry : motorsToRecreateAsLynx) {
                map.dcMotor.remove((String)entry.getKey());
            }
            for (Map.Entry entry : motorsToRecreateAsLynx) {
                map.dcMotor.put((String)entry.getKey(), (HardwareDevice)new ExpansionHubMotor((DcMotor)entry.getValue()));
            }
        }
    }

    private static void swapStandardServosForLynx(HardwareMap map) {
        ArrayList<Map.Entry> servosToRecreateAsLynx = new ArrayList<Map.Entry>();
        for (Map.Entry entry : map.servo.entrySet()) {
            if (entry.getValue() instanceof ExpansionHubServo || !(entry.getValue() instanceof ServoImplEx) || !(((Servo)entry.getValue()).getController() instanceof LynxServoController)) continue;
            servosToRecreateAsLynx.add(entry);
        }
        if (!servosToRecreateAsLynx.isEmpty()) {
            for (Map.Entry entry : servosToRecreateAsLynx) {
                map.servo.remove((String)entry.getKey());
            }
            for (Map.Entry entry : servosToRecreateAsLynx) {
                map.servo.put((String)entry.getKey(), (HardwareDevice)new ExpansionHubServo((Servo)entry.getValue()));
            }
        }
    }

    private static void addExpansionHubExForEachLynxModule(HardwareMap map) {
        HashMap<String, ExpansionHubEx> enhancedLynxModulesToInject = new HashMap<String, ExpansionHubEx>();
        for (LynxModule lynxModule : map.getAll(LynxModule.class)) {
            if (Utils.hwMapContainsEnhancedModule(lynxModule)) continue;
            enhancedLynxModulesToInject.put(Utils.getHwMapName((HardwareDevice)lynxModule), new ExpansionHubEx(lynxModule));
        }
        for (Map.Entry entry : enhancedLynxModulesToInject.entrySet()) {
            map.put((String)entry.getKey(), (HardwareDevice)entry.getValue());
        }
    }

    private static void deswapLynxMotors(HardwareMap map) {
        ArrayList<Map.Entry> lynxMotorsToRecreateAsStandard = new ArrayList<Map.Entry>();
        for (Map.Entry entry : map.dcMotor.entrySet()) {
            if (!(entry.getValue() instanceof ExpansionHubMotor)) continue;
            lynxMotorsToRecreateAsStandard.add(entry);
        }
        if (!lynxMotorsToRecreateAsStandard.isEmpty()) {
            for (Map.Entry entry : lynxMotorsToRecreateAsStandard) {
                map.dcMotor.remove((String)entry.getKey());
            }
            for (Map.Entry entry : lynxMotorsToRecreateAsStandard) {
                map.dcMotor.put((String)entry.getKey(), (HardwareDevice)new DcMotorImplEx(((DcMotor)entry.getValue()).getController(), ((DcMotor)entry.getValue()).getPortNumber(), ((DcMotor)entry.getValue()).getDirection(), ((DcMotor)entry.getValue()).getMotorType()));
            }
        }
    }

    private static void deswapLynxServos(HardwareMap map) {
        ArrayList<Map.Entry> lynxServosToRecreateAsStandard = new ArrayList<Map.Entry>();
        for (Map.Entry entry : map.servo.entrySet()) {
            if (!(entry.getValue() instanceof ExpansionHubServo)) continue;
            lynxServosToRecreateAsStandard.add(entry);
        }
        if (!lynxServosToRecreateAsStandard.isEmpty()) {
            for (Map.Entry entry : lynxServosToRecreateAsStandard) {
                map.servo.remove((String)entry.getKey());
            }
            for (Map.Entry entry : lynxServosToRecreateAsStandard) {
                map.servo.put((String)entry.getKey(), (HardwareDevice)new ServoImplEx((ServoControllerEx)((Servo)entry.getValue()).getController(), ((Servo)entry.getValue()).getPortNumber(), ((Servo)entry.getValue()).getDirection(), ServoConfigurationType.getStandardServoType()));
            }
        }
    }

    private static void removeExpansionHubExForEachLynxModule(HardwareMap map) {
        HashMap<String, ExpansionHubEx> enhancedLynxModulesToRemove = new HashMap<String, ExpansionHubEx>();
        for (ExpansionHubEx expansionHubEx : map.getAll(ExpansionHubEx.class)) {
            enhancedLynxModulesToRemove.put(Utils.getHwMapName(expansionHubEx), expansionHubEx);
        }
        if (!enhancedLynxModulesToRemove.isEmpty()) {
            for (Map.Entry entry : enhancedLynxModulesToRemove.entrySet()) {
                map.remove((String)entry.getKey(), (HardwareDevice)entry.getValue());
            }
        }
    }

    static String getHwMapName(HardwareDevice device) {
        return (String)Utils.getHardwareMap().getNamesOf(device).iterator().next();
    }

    private static boolean hwMapContainsEnhancedModule(LynxModule module) {
        for (ExpansionHubEx enhancedModule : Utils.getHardwareMap().getAll(ExpansionHubEx.class)) {
            if (module.getModuleAddress() != enhancedModule.getStandardModule().getModuleAddress()) continue;
            return true;
        }
        return false;
    }

    static LynxModule getLynxFromController(LynxController controller) {
        try {
            Field moduleField = LynxController.class.getDeclaredField("module");
            moduleField.setAccessible(true);
            return (LynxModule)moduleField.get(controller);
        }
        catch (Exception e) {
            throw new RE2Exception("Failed to reflect on LynxController! Please report this as an issue on the GitHub repository.");
        }
    }
}

