/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.revextensions2;

import com.qualcomm.hardware.lynx.LynxAnalogInputController;
import com.qualcomm.hardware.lynx.LynxController;
import com.qualcomm.hardware.lynx.LynxDcMotorController;
import com.qualcomm.hardware.lynx.LynxDigitalChannelController;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.commands.core.LynxGetBulkInputDataResponse;
import com.qualcomm.robotcore.hardware.AnalogInput;
import com.qualcomm.robotcore.hardware.AnalogInputController;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.DcMotorSimple;
import com.qualcomm.robotcore.hardware.DigitalChannel;
import com.qualcomm.robotcore.hardware.DigitalChannelController;
import com.qualcomm.robotcore.hardware.DigitalChannelImpl;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.MotorConfigurationType;
import java.lang.reflect.Field;
import org.firstinspires.ftc.robotcore.external.navigation.Rotation;
import org.openftc.revextensions2.RE2Exception;
import org.openftc.revextensions2.RevBulkDataException;
import org.openftc.revextensions2.Utils;

public class RevBulkData {
    private LynxGetBulkInputDataResponse response;
    private LynxModule module;

    RevBulkData(LynxGetBulkInputDataResponse response, LynxModule module) {
        this.response = response;
        this.module = module;
    }

    private static DcMotorSimple.Direction getMotorOperationalDirection(DcMotor dcMotor) {
        MotorConfigurationType motorType = dcMotor.getMotorType();
        DcMotorSimple.Direction direction = dcMotor.getDirection();
        if (motorType.getOrientation() == Rotation.CCW) {
            return direction.inverted();
        }
        return direction;
    }

    public int getMotorCurrentPosition(int motorNum) {
        return this.response.getEncoder(motorNum);
    }

    public int getMotorCurrentPosition(DcMotor motor) {
        this.throwIfMotorInvalid(motor);
        int position = this.getMotorCurrentPosition(motor.getPortNumber());
        if (RevBulkData.getMotorOperationalDirection(motor) == DcMotorSimple.Direction.REVERSE) {
            return -position;
        }
        return position;
    }

    public int getMotorVelocity(int motorNum) {
        return this.response.getVelocity(motorNum);
    }

    public int getMotorVelocity(DcMotor motor) {
        this.throwIfMotorInvalid(motor);
        int velocity = this.getMotorVelocity(motor.getPortNumber());
        if (RevBulkData.getMotorOperationalDirection(motor) == DcMotorSimple.Direction.REVERSE) {
            return -velocity;
        }
        return velocity;
    }

    public boolean isMotorAtTargetPosition(int motorNum) {
        return this.response.isAtTarget(motorNum);
    }

    public boolean isMotorAtTargetPosition(DcMotor motor) {
        this.throwIfMotorInvalid(motor);
        return this.isMotorAtTargetPosition(motor.getPortNumber());
    }

    public int getAnalogInputValue(int pin) {
        return this.response.getAnalogInput(pin);
    }

    public int getAnalogInputValue(AnalogInput input) {
        AnalogInputController controller = null;
        int port = -1;
        try {
            Field controllerField = AnalogInput.class.getDeclaredField("controller");
            controllerField.setAccessible(true);
            controller = (AnalogInputController)controllerField.get(input);
            Field channelField = AnalogInput.class.getDeclaredField("channel");
            channelField.setAccessible(true);
            port = (Integer)channelField.get(input);
        }
        catch (Exception e) {
            throw new RE2Exception("Failed to reflect on AnalogInput! Please report this as an issue on the GitHub repository.");
        }
        if (!(controller instanceof LynxAnalogInputController)) {
            throw new RevBulkDataException(String.format("AnalogInput %s is not attached to a Lynx module!", Utils.getHwMapName((HardwareDevice)input)));
        }
        if (!this.validateLynxController((LynxController)controller)) {
            throw new RevBulkDataException(String.format("AnalogInput %s is attached to a different Lynx module than the one that this bulk command was issued to!", Utils.getHwMapName((HardwareDevice)input)));
        }
        return this.getAnalogInputValue(port);
    }

    public boolean getDigitalInputState(int pin) {
        return this.response.getDigitalInput(pin);
    }

    public boolean getDigitalInputState(DigitalChannel digitalChannel) {
        DigitalChannelController controller = null;
        int port = -1;
        try {
            Field controllerField = DigitalChannelImpl.class.getDeclaredField("controller");
            controllerField.setAccessible(true);
            controller = (DigitalChannelController)controllerField.get(digitalChannel);
            Field channelField = DigitalChannelImpl.class.getDeclaredField("channel");
            channelField.setAccessible(true);
            port = (Integer)channelField.get(digitalChannel);
        }
        catch (Exception e) {
            throw new RE2Exception("Failed to reflect on DigitalChannelImpl! Please report this as an issue on the GitHub repository.");
        }
        if (!(controller instanceof LynxDigitalChannelController)) {
            throw new RevBulkDataException(String.format("DigitalChannel %s is not attached to a Lynx module!", Utils.getHwMapName((HardwareDevice)digitalChannel)));
        }
        if (!this.validateLynxController((LynxController)controller)) {
            throw new RevBulkDataException(String.format("DigitalChannel %s is attached to a different Lynx module than the one that this bulk command was issued to!", Utils.getHwMapName((HardwareDevice)digitalChannel)));
        }
        return this.getDigitalInputState(port);
    }

    private void throwIfMotorInvalid(DcMotor motor) {
        if (!(motor.getController() instanceof LynxDcMotorController)) {
            throw new RevBulkDataException(String.format("Motor %s is not attached to a Lynx module!", Utils.getHwMapName((HardwareDevice)motor)));
        }
        if (!this.validateLynxController((LynxController)motor.getController())) {
            throw new RevBulkDataException(String.format("Motor %s is attached to a different Lynx module than the one that this bulk command was issued to!", Utils.getHwMapName((HardwareDevice)motor)));
        }
    }

    private boolean validateLynxController(LynxController controller) {
        return this.validateLynxModule(Utils.getLynxFromController(controller));
    }

    private boolean validateLynxModule(LynxModule moduleToValidate) {
        return moduleToValidate.getModuleAddress() == this.module.getModuleAddress();
    }
}

