/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.revextensions2;

import android.graphics.Color;
import com.qualcomm.hardware.lynx.LynxCommExceptionHandler;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetBulkInputDataCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetBulkInputDataResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cConfigureChannelCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxPhoneChargeControlCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxPhoneChargeQueryCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxPhoneChargeQueryResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxSetServoPulseWidthCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxGetModuleStatusCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxGetModuleStatusResponse;
import com.qualcomm.hardware.lynx.commands.standard.LynxSetModuleLEDColorCommand;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.openftc.revextensions2.RevBulkData;

public class ExpansionHubEx
extends LynxCommExceptionHandler
implements HardwareDevice {
    private LynxModule expansionHub;

    ExpansionHubEx(LynxModule expansionHub) {
        this.expansionHub = expansionHub;
    }

    public LynxModule getStandardModule() {
        return this.expansionHub;
    }

    public synchronized void setLedColor(int r, int g, int b) {
        if (r > 255 || g > 255 || b > 255) {
            throw new IllegalArgumentException();
        }
        this.setLedColor((byte)r, (byte)g, (byte)b);
    }

    public synchronized void setLedColor(byte r, byte g, byte b) {
        LynxSetModuleLEDColorCommand colorCommand = new LynxSetModuleLEDColorCommand(this.expansionHub, r, g, b);
        try {
            colorCommand.send();
        }
        catch (LynxNackException | InterruptedException e) {
            this.handleException((Exception)e);
        }
    }

    public synchronized void setLedColor(int resId) {
        int color = AppUtil.getInstance().getRootActivity().getResources().getColor(resId);
        byte red = (byte)Color.red((int)color);
        byte green = (byte)Color.green((int)color);
        byte blue = (byte)Color.blue((int)color);
        this.setLedColor(red, green, blue);
    }

    public synchronized void setAllI2cBusSpeeds(I2cBusSpeed speed) {
        for (int i = 0; i < 4; ++i) {
            this.setI2cBusSpeed(i, speed);
        }
    }

    public synchronized void setI2cBusSpeed(int bus, I2cBusSpeed speed) {
        LynxI2cConfigureChannelCommand.SpeedCode speedCode = LynxI2cConfigureChannelCommand.SpeedCode.STANDARD_100K;
        switch (speed) {
            case STANDARD_100K: {
                speedCode = LynxI2cConfigureChannelCommand.SpeedCode.STANDARD_100K;
                break;
            }
            case FAST_400K: {
                speedCode = LynxI2cConfigureChannelCommand.SpeedCode.FAST_400K;
                break;
            }
            case FASTPLUS_1M: {
                speedCode = LynxI2cConfigureChannelCommand.SpeedCode.FASTPLUS_1M;
                break;
            }
            case HIGH_3_4M: {
                speedCode = LynxI2cConfigureChannelCommand.SpeedCode.HIGH_3_4M;
            }
        }
        LynxI2cConfigureChannelCommand command = new LynxI2cConfigureChannelCommand((LynxModuleIntf)this.expansionHub, bus, speedCode);
        try {
            command.send();
        }
        catch (LynxNackException | InterruptedException e) {
            this.handleException((Exception)e);
        }
    }

    public synchronized double getTotalModuleCurrentDraw(CurrentDrawUnits units) {
        LynxGetADCCommand command = new LynxGetADCCommand((LynxModuleIntf)this.expansionHub, LynxGetADCCommand.Channel.BATTERY_CURRENT, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            int ma = response.getValue();
            if (units == CurrentDrawUnits.MILLIAMPS) {
                return ma;
            }
            if (units == CurrentDrawUnits.AMPS) {
                return (double)ma / 1000.0;
            }
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        return 0.0;
    }

    @Deprecated
    public synchronized double getServoBusCurrentDraw(CurrentDrawUnits units) {
        LynxGetADCCommand.Channel channel = LynxGetADCCommand.Channel.SERVO_CURRENT;
        LynxGetADCCommand command = new LynxGetADCCommand((LynxModuleIntf)this.expansionHub, channel, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            int ma = response.getValue();
            if (units == CurrentDrawUnits.MILLIAMPS) {
                return ma;
            }
            if (units == CurrentDrawUnits.AMPS) {
                return (double)ma / 1000.0;
            }
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        return 0.0;
    }

    public synchronized double getGpioBusCurrentDraw(CurrentDrawUnits units) {
        LynxGetADCCommand.Channel channel = LynxGetADCCommand.Channel.GPIO_CURRENT;
        LynxGetADCCommand command = new LynxGetADCCommand((LynxModuleIntf)this.expansionHub, channel, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            int ma = response.getValue();
            if (units == CurrentDrawUnits.MILLIAMPS) {
                return ma;
            }
            if (units == CurrentDrawUnits.AMPS) {
                return (double)ma / 1000.0;
            }
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        return 0.0;
    }

    public synchronized double getI2cBusCurrentDraw(CurrentDrawUnits units) {
        LynxGetADCCommand.Channel channel = LynxGetADCCommand.Channel.I2C_BUS_CURRENT;
        LynxGetADCCommand command = new LynxGetADCCommand((LynxModuleIntf)this.expansionHub, channel, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            int ma = response.getValue();
            if (units == CurrentDrawUnits.MILLIAMPS) {
                return ma;
            }
            if (units == CurrentDrawUnits.AMPS) {
                return (double)ma / 1000.0;
            }
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        return 0.0;
    }

    public synchronized double read5vMonitor(VoltageUnits units) {
        LynxGetADCCommand.Channel channel = LynxGetADCCommand.Channel.FIVE_VOLT_MONITOR;
        LynxGetADCCommand command = new LynxGetADCCommand((LynxModuleIntf)this.expansionHub, channel, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            int mv = response.getValue();
            if (units == VoltageUnits.MILLIVOLTS) {
                return mv;
            }
            if (units == VoltageUnits.VOLTS) {
                return (double)mv / 1000.0;
            }
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        return 0.0;
    }

    public synchronized double read12vMonitor(VoltageUnits units) {
        LynxGetADCCommand.Channel channel = LynxGetADCCommand.Channel.BATTERY_MONITOR;
        LynxGetADCCommand command = new LynxGetADCCommand((LynxModuleIntf)this.expansionHub, channel, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            int mv = response.getValue();
            if (units == VoltageUnits.MILLIVOLTS) {
                return mv;
            }
            if (units == VoltageUnits.VOLTS) {
                return (double)mv / 1000.0;
            }
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        return 0.0;
    }

    public synchronized double getInternalTemperature(TemperatureUnits units) {
        LynxGetADCCommand.Channel channel = LynxGetADCCommand.Channel.CONTROLLER_TEMPERATURE;
        LynxGetADCCommand command = new LynxGetADCCommand((LynxModuleIntf)this.expansionHub, channel, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            int degC = response.getValue();
            if (units == TemperatureUnits.CELSIUS) {
                return degC;
            }
            if (units == TemperatureUnits.FAHRENHEIT) {
                return (double)degC * 1.8 + 32.0;
            }
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        return 0.0;
    }

    public synchronized boolean isModuleOverTemp() {
        LynxGetModuleStatusCommand command = new LynxGetModuleStatusCommand(this.expansionHub);
        try {
            LynxGetModuleStatusResponse response = (LynxGetModuleStatusResponse)command.sendReceive();
            return response.isControllerOverTemp();
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    @Deprecated
    public synchronized boolean isPhoneChargeEnabled() {
        LynxPhoneChargeQueryCommand command = new LynxPhoneChargeQueryCommand((LynxModuleIntf)this.expansionHub);
        try {
            LynxPhoneChargeQueryResponse response = (LynxPhoneChargeQueryResponse)command.sendReceive();
            return response.isChargeEnabled();
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    public synchronized void setPhoneChargeEnabled(boolean chargeEnabled) {
        LynxPhoneChargeControlCommand controlCommand = new LynxPhoneChargeControlCommand((LynxModuleIntf)this.expansionHub, chargeEnabled);
        try {
            controlCommand.send();
        }
        catch (LynxNackException | InterruptedException e) {
            this.handleException((Exception)e);
        }
    }

    public synchronized void setServoPulseWidth(int port, int uS) {
        LynxSetServoPulseWidthCommand command = new LynxSetServoPulseWidthCommand((LynxModuleIntf)this.expansionHub, port, uS);
        try {
            command.send();
        }
        catch (LynxNackException | InterruptedException e) {
            this.handleException((Exception)e);
        }
    }

    public synchronized RevBulkData getBulkInputData() {
        LynxGetBulkInputDataCommand command = new LynxGetBulkInputDataCommand((LynxModuleIntf)this.expansionHub);
        try {
            LynxGetBulkInputDataResponse response = (LynxGetBulkInputDataResponse)command.sendReceive();
            return new RevBulkData(response, this.expansionHub);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public synchronized double getMotorCurrentDraw(CurrentDrawUnits units, int port) {
        LynxConstants.validateMotorZ((int)port);
        LynxGetADCCommand.Channel channel = null;
        if (port == 0) {
            channel = LynxGetADCCommand.Channel.MOTOR0_CURRENT;
        } else if (port == 1) {
            channel = LynxGetADCCommand.Channel.MOTOR1_CURRENT;
        } else if (port == 2) {
            channel = LynxGetADCCommand.Channel.MOTOR2_CURRENT;
        } else if (port == 3) {
            channel = LynxGetADCCommand.Channel.MOTOR3_CURRENT;
        }
        LynxGetADCCommand command = new LynxGetADCCommand((LynxModuleIntf)this.expansionHub, channel, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            int ma = response.getValue();
            if (units == CurrentDrawUnits.MILLIAMPS) {
                return ma;
            }
            if (units == CurrentDrawUnits.AMPS) {
                return (double)ma / 1000.0;
            }
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        return 0.0;
    }

    public synchronized boolean isMotorBridgeOverTemp(int port) {
        LynxGetModuleStatusCommand command = new LynxGetModuleStatusCommand(this.expansionHub);
        try {
            LynxGetModuleStatusResponse response = (LynxGetModuleStatusResponse)command.sendReceive();
            return response.isMotorBridgeOverTemp(port);
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    @Deprecated
    public synchronized boolean hasMotorLostCounts(int port) {
        LynxGetModuleStatusCommand command = new LynxGetModuleStatusCommand(this.expansionHub);
        try {
            LynxGetModuleStatusResponse response = (LynxGetModuleStatusResponse)command.sendReceive();
            return response.hasMotorLostCounts(port);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized String getFirmwareVersion() {
        String inputstring = this.expansionHub.getFirmwareVersionString();
        if (inputstring.equals("unknown firmware") || inputstring.equals("firmware version unavailable")) {
            return inputstring;
        }
        int majVer = this.regexField("Maj", inputstring);
        int minVer = this.regexField("Min", inputstring);
        int engVer = this.regexField("Eng", inputstring);
        return String.format("%s.%s.%s", majVer, minVer, engVer);
    }

    public synchronized int getHardwareRevision() {
        String inputstring = this.expansionHub.getFirmwareVersionString();
        if (inputstring.equals("unknown firmware") || inputstring.equals("firmware version unavailable")) {
            return -1;
        }
        return this.regexField("HW", inputstring);
    }

    private int regexField(String thing, String input) {
        Pattern pattern = Pattern.compile(thing + ":\\ \\d+");
        Matcher matcher = pattern.matcher(input);
        matcher.find();
        String string = matcher.group();
        return this.regexNum(string);
    }

    private int regexNum(String str) {
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(str);
        matcher.find();
        return Integer.parseInt(matcher.group());
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return this.expansionHub.getManufacturer();
    }

    public String getDeviceName() {
        return this.expansionHub.getDeviceName();
    }

    public String getConnectionInfo() {
        return this.expansionHub.getConnectionInfo();
    }

    public int getVersion() {
        return this.expansionHub.getVersion();
    }

    public void resetDeviceConfigurationForOpMode() {
        this.expansionHub.resetDeviceConfigurationForOpMode();
    }

    public void close() {
        this.expansionHub.close();
    }

    public static enum TemperatureUnits {
        CELSIUS,
        FAHRENHEIT;

    }

    public static enum VoltageUnits {
        MILLIVOLTS,
        VOLTS;

    }

    public static enum CurrentDrawUnits {
        MILLIAMPS,
        AMPS;

    }

    public static enum I2cBusSpeed {
        STANDARD_100K,
        FAST_400K,
        FASTPLUS_1M,
        HIGH_3_4M;

    }
}

