/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLProtocolException;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.ClientAuthType;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.ConnectionContext;
import org.openeuler.sun.security.ssl.HandshakeAbsence;
import org.openeuler.sun.security.ssl.HandshakeConsumer;
import org.openeuler.sun.security.ssl.HandshakeProducer;
import org.openeuler.sun.security.ssl.ProtocolVersion;
import org.openeuler.sun.security.ssl.Record;
import org.openeuler.sun.security.ssl.SSLExtension;
import org.openeuler.sun.security.ssl.SSLHandshake;
import org.openeuler.sun.security.ssl.SSLLogger;
import org.openeuler.sun.security.ssl.SSLStringizer;
import org.openeuler.sun.security.ssl.ServerHandshakeContext;
import org.openeuler.sun.security.ssl.SignatureScheme;

final class SignatureAlgorithmsExtension {
    static final HandshakeProducer chNetworkProducer = new CHSignatureSchemesProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHSignatureSchemesConsumer();
    static final HandshakeAbsence chOnLoadAbsence = new CHSignatureSchemesOnLoadAbsence();
    static final HandshakeConsumer chOnTradeConsumer = new CHSignatureSchemesUpdate();
    static final HandshakeAbsence chOnTradeAbsence = new CHSignatureSchemesOnTradeAbsence();
    static final HandshakeProducer crNetworkProducer = new CRSignatureSchemesProducer();
    static final SSLExtension.ExtensionConsumer crOnLoadConsumer = new CRSignatureSchemesConsumer();
    static final HandshakeAbsence crOnLoadAbsence = new CRSignatureSchemesAbsence();
    static final HandshakeConsumer crOnTradeConsumer = new CRSignatureSchemesUpdate();
    static final SSLStringizer ssStringizer = new SignatureSchemesStringizer();

    SignatureAlgorithmsExtension() {
    }

    private static final class CRSignatureSchemesAbsence
    implements HandshakeAbsence {
        private CRSignatureSchemesAbsence() {
        }

        @Override
        public void absent(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            throw chc.conContext.fatal(Alert.MISSING_EXTENSION, "No mandatory signature_algorithms extension in the received CertificateRequest handshake message");
        }
    }

    private static final class CRSignatureSchemesUpdate
    implements HandshakeConsumer {
        private CRSignatureSchemesUpdate() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            List<SignatureScheme> sss;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            SignatureSchemesSpec spec = (SignatureSchemesSpec)chc.handshakeExtensions.get(SSLExtension.CR_SIGNATURE_ALGORITHMS);
            if (spec == null) {
                return;
            }
            chc.peerRequestedSignatureSchemes = sss = SignatureScheme.getSupportedAlgorithms(chc.sslConfig, chc.algorithmConstraints, chc.negotiatedProtocol, spec.signatureSchemes);
            SignatureSchemesSpec certSpec = (SignatureSchemesSpec)chc.handshakeExtensions.get(SSLExtension.CR_SIGNATURE_ALGORITHMS_CERT);
            if (certSpec == null) {
                chc.peerRequestedCertSignSchemes = sss;
                chc.handshakeSession.setPeerSupportedSignatureAlgorithms(sss);
            }
        }
    }

    private static final class CRSignatureSchemesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CRSignatureSchemesConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message, ByteBuffer buffer) throws IOException {
            SignatureSchemesSpec spec;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            if (!chc.sslConfig.isAvailable(SSLExtension.CR_SIGNATURE_ALGORITHMS)) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No available signature_algorithms extension for client certificate authentication");
            }
            try {
                spec = new SignatureSchemesSpec(buffer);
            }
            catch (IOException ioe) {
                throw chc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, ioe);
            }
            LinkedList<SignatureScheme> knownSignatureSchemes = new LinkedList<SignatureScheme>();
            for (int id : spec.signatureSchemes) {
                SignatureScheme ss = SignatureScheme.valueOf(id);
                if (ss == null) continue;
                knownSignatureSchemes.add(ss);
            }
            chc.handshakeExtensions.put(SSLExtension.CR_SIGNATURE_ALGORITHMS, spec);
        }
    }

    private static final class CRSignatureSchemesProducer
    implements HandshakeProducer {
        private CRSignatureSchemesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            if (!shc.sslConfig.isAvailable(SSLExtension.CR_SIGNATURE_ALGORITHMS)) {
                throw shc.conContext.fatal(Alert.MISSING_EXTENSION, "No available signature_algorithms extension for client certificate authentication");
            }
            List<ProtocolVersion> protocols = Arrays.asList(shc.negotiatedProtocol);
            protocols = Collections.unmodifiableList(protocols);
            List<SignatureScheme> sigAlgs = SignatureScheme.getSupportedAlgorithms(shc.sslConfig, shc.algorithmConstraints, protocols);
            int vectorLen = SignatureScheme.sizeInRecord() * sigAlgs.size();
            byte[] extData = new byte[vectorLen + 2];
            ByteBuffer m = ByteBuffer.wrap(extData);
            Record.putInt16(m, vectorLen);
            for (SignatureScheme ss : sigAlgs) {
                Record.putInt16(m, ss.id);
            }
            shc.handshakeExtensions.put(SSLExtension.CR_SIGNATURE_ALGORITHMS, new SignatureSchemesSpec(shc.localSupportedSignAlgs));
            return extData;
        }
    }

    private static final class CHSignatureSchemesOnTradeAbsence
    implements HandshakeAbsence {
        private CHSignatureSchemesOnTradeAbsence() {
        }

        @Override
        public void absent(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            if (shc.negotiatedProtocol.useTLS12PlusSpec()) {
                List<SignatureScheme> schemes;
                shc.peerRequestedSignatureSchemes = schemes = Arrays.asList(SignatureScheme.RSA_PKCS1_SHA1, SignatureScheme.DSA_SHA1, SignatureScheme.ECDSA_SHA1);
                if (shc.peerRequestedCertSignSchemes == null || shc.peerRequestedCertSignSchemes.isEmpty()) {
                    shc.peerRequestedCertSignSchemes = schemes;
                }
                shc.handshakeSession.setUseDefaultPeerSignAlgs();
            }
        }
    }

    private static final class CHSignatureSchemesOnLoadAbsence
    implements HandshakeAbsence {
        private CHSignatureSchemesOnLoadAbsence() {
        }

        @Override
        public void absent(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            if (shc.negotiatedProtocol.useTLS13PlusSpec()) {
                throw shc.conContext.fatal(Alert.MISSING_EXTENSION, "No mandatory signature_algorithms extension in the received CertificateRequest handshake message");
            }
        }
    }

    private static final class CHSignatureSchemesUpdate
    implements HandshakeConsumer {
        private CHSignatureSchemesUpdate() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            List<SignatureScheme> sss;
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            SignatureSchemesSpec spec = (SignatureSchemesSpec)shc.handshakeExtensions.get(SSLExtension.CH_SIGNATURE_ALGORITHMS);
            if (spec == null) {
                return;
            }
            shc.peerRequestedSignatureSchemes = sss = SignatureScheme.getSupportedAlgorithms(shc.sslConfig, shc.algorithmConstraints, shc.negotiatedProtocol, spec.signatureSchemes);
            SignatureSchemesSpec certSpec = (SignatureSchemesSpec)shc.handshakeExtensions.get(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT);
            if (certSpec == null) {
                shc.peerRequestedCertSignSchemes = sss;
                shc.handshakeSession.setPeerSupportedSignatureAlgorithms(sss);
            }
            if (!shc.isResumption && shc.negotiatedProtocol.useTLS13PlusSpec()) {
                if (shc.sslConfig.clientAuthType != ClientAuthType.CLIENT_AUTH_NONE) {
                    shc.handshakeProducers.putIfAbsent(SSLHandshake.CERTIFICATE_REQUEST.id, SSLHandshake.CERTIFICATE_REQUEST);
                }
                shc.handshakeProducers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
                shc.handshakeProducers.putIfAbsent(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            }
        }
    }

    private static final class CHSignatureSchemesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHSignatureSchemesConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message, ByteBuffer buffer) throws IOException {
            SignatureSchemesSpec spec;
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            if (!shc.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms extension", new Object[0]);
                }
                return;
            }
            try {
                spec = new SignatureSchemesSpec(buffer);
            }
            catch (IOException ioe) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, ioe);
            }
            shc.handshakeExtensions.put(SSLExtension.CH_SIGNATURE_ALGORITHMS, spec);
        }
    }

    private static final class CHSignatureSchemesProducer
    implements HandshakeProducer {
        private CHSignatureSchemesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            if (!chc.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms extension", new Object[0]);
                }
                return null;
            }
            if (chc.localSupportedSignAlgs == null) {
                chc.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(chc.sslConfig, chc.algorithmConstraints, chc.activeProtocols);
            }
            int vectorLen = SignatureScheme.sizeInRecord() * chc.localSupportedSignAlgs.size();
            byte[] extData = new byte[vectorLen + 2];
            ByteBuffer m = ByteBuffer.wrap(extData);
            Record.putInt16(m, vectorLen);
            for (SignatureScheme ss : chc.localSupportedSignAlgs) {
                Record.putInt16(m, ss.id);
            }
            chc.handshakeExtensions.put(SSLExtension.CH_SIGNATURE_ALGORITHMS, new SignatureSchemesSpec(chc.localSupportedSignAlgs));
            return extData;
        }
    }

    private static final class SignatureSchemesStringizer
    implements SSLStringizer {
        private SignatureSchemesStringizer() {
        }

        @Override
        public String toString(ByteBuffer buffer) {
            try {
                return new SignatureSchemesSpec(buffer).toString();
            }
            catch (IOException ioe) {
                return ioe.getMessage();
            }
        }
    }

    static final class SignatureSchemesSpec
    implements SSLExtension.SSLExtensionSpec {
        final int[] signatureSchemes;

        SignatureSchemesSpec(List<SignatureScheme> schemes) {
            if (schemes != null) {
                this.signatureSchemes = new int[schemes.size()];
                int i = 0;
                for (SignatureScheme scheme : schemes) {
                    this.signatureSchemes[i++] = scheme.id;
                }
            } else {
                this.signatureSchemes = new int[0];
            }
        }

        SignatureSchemesSpec(ByteBuffer buffer) throws IOException {
            if (buffer.remaining() < 2) {
                throw new SSLProtocolException("Invalid signature_algorithms: insufficient data");
            }
            byte[] algs = Record.getBytes16(buffer);
            if (buffer.hasRemaining()) {
                throw new SSLProtocolException("Invalid signature_algorithms: unknown extra data");
            }
            if (algs == null || algs.length == 0 || (algs.length & 1) != 0) {
                throw new SSLProtocolException("Invalid signature_algorithms: incomplete data");
            }
            int[] schemes = new int[algs.length / 2];
            int i = 0;
            int j = 0;
            while (i < algs.length) {
                byte hash = algs[i++];
                byte sign = algs[i++];
                schemes[j++] = (hash & 0xFF) << 8 | sign & 0xFF;
            }
            this.signatureSchemes = schemes;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"signature schemes\": '['{0}']'", Locale.ENGLISH);
            if (this.signatureSchemes == null || this.signatureSchemes.length == 0) {
                Object[] messageFields = new Object[]{"<no supported signature schemes specified>"};
                return messageFormat.format(messageFields);
            }
            StringBuilder builder = new StringBuilder(512);
            boolean isFirst = true;
            for (int pv : this.signatureSchemes) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append(", ");
                }
                builder.append(SignatureScheme.nameOf(pv));
            }
            Object[] messageFields = new Object[]{builder.toString()};
            return messageFormat.format(messageFields);
        }
    }
}

