/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.AbstractMap;
import java.util.Map;
import javax.net.ssl.X509ExtendedKeyManager;
import org.openeuler.gm.GMConstants;
import org.openeuler.gm.GMTlsUtil;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.HandshakeProducer;
import org.openeuler.sun.security.ssl.SSLAuthentication;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLHandshake;
import org.openeuler.sun.security.ssl.SSLLogger;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.SSLPossessionGenerator;
import org.openeuler.sun.security.ssl.ServerHandshakeContext;
import org.openeuler.sun.security.ssl.SupportedGroupsExtension;

enum GMX509Authentication implements SSLAuthentication
{
    SM2("SM2", new GMX509PossessionGenerator(new String[]{"SM2"}));

    final String keyType;
    final SSLPossessionGenerator possessionGenerator;

    private GMX509Authentication(String keyType, SSLPossessionGenerator possessionGenerator) {
        this.keyType = keyType;
        this.possessionGenerator = possessionGenerator;
    }

    @Override
    public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
        return new SSLHandshake[]{SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_REQUEST};
    }

    @Override
    public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLHandshake>(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE)};
    }

    @Override
    public SSLPossession createPossession(HandshakeContext handshakeContext) {
        return this.possessionGenerator.createPossession(handshakeContext);
    }

    static final class GMX509Credentials
    implements SSLCredentials {
        final PublicKey popSignPublicKey;
        final X509Certificate[] popSignCerts;
        final PublicKey popEncPublicKey;
        final X509Certificate[] popEncCerts;

        public GMX509Credentials(PublicKey popSignPublicKey, X509Certificate[] popSignCerts, PublicKey popEncPublicKey, X509Certificate[] popEncCerts) {
            this.popSignPublicKey = popSignPublicKey;
            this.popSignCerts = popSignCerts;
            this.popEncPublicKey = popEncPublicKey;
            this.popEncCerts = popEncCerts;
        }
    }

    static final class GMX509Possession
    implements SSLPossession {
        final PrivateKey popSignPrivateKey;
        final X509Certificate[] popSignCerts;
        final PrivateKey popEncPrivateKey;
        final X509Certificate[] popEncCerts;

        GMX509Possession(PrivateKey popSignPrivateKey, X509Certificate[] popSignCerts, PrivateKey popEncPrivateKey, X509Certificate[] popEncCerts) {
            this.popSignCerts = popSignCerts;
            this.popSignPrivateKey = popSignPrivateKey;
            this.popEncCerts = popEncCerts;
            this.popEncPrivateKey = popEncPrivateKey;
        }
    }

    private static final class GMX509PossessionGenerator
    implements SSLPossessionGenerator {
        private final String[] keyTypes;

        GMX509PossessionGenerator(String[] keyTypes) {
            this.keyTypes = keyTypes;
        }

        @Override
        public SSLPossession createPossession(HandshakeContext context) {
            if (context.sslConfig.isClientMode) {
                for (String keyType : this.keyTypes) {
                    SSLPossession poss = this.createClientPossession((ClientHandshakeContext)context, keyType);
                    if (poss == null) continue;
                    return poss;
                }
            } else {
                for (String keyType : this.keyTypes) {
                    SSLPossession poss = this.createServerPossession((ServerHandshakeContext)context, keyType);
                    if (poss == null) continue;
                    return poss;
                }
            }
            return null;
        }

        private SSLPossession createClientPossession(ClientHandshakeContext chc, String keyType) {
            X509ExtendedKeyManager km = chc.sslContext.getX509KeyManager();
            String[] clientAliases = km.getClientAliases(keyType, chc.peerSupportedAuthorities == null ? null : (Principal[])chc.peerSupportedAuthorities.clone());
            if (clientAliases == null || clientAliases.length < 2) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest("No X.509 cert selected for " + keyType, new Object[0]);
                }
                return null;
            }
            return this.createGMX509Possession(keyType, clientAliases, km, chc, true);
        }

        private SSLPossession createServerPossession(ServerHandshakeContext shc, String keyType) {
            X509ExtendedKeyManager km = shc.sslContext.getX509KeyManager();
            String[] serverAliases = km.getServerAliases(keyType, shc.peerSupportedAuthorities == null ? null : (Principal[])shc.peerSupportedAuthorities.clone());
            if (serverAliases == null || serverAliases.length < 2) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest("No X.509 cert selected for " + keyType, new Object[0]);
                }
                return null;
            }
            return this.createGMX509Possession(keyType, serverAliases, km, shc, false);
        }

        private GMX509Possession createGMX509Possession(String keyType, String[] serverAliases, X509ExtendedKeyManager km, HandshakeContext shc, boolean isClientMode) {
            PrivateKey signPrivateKey = null;
            X509Certificate[] signCerts = null;
            PrivateKey encPrivateKey = null;
            X509Certificate[] encCerts = null;
            boolean isValid = false;
            for (String serverAlias : serverAliases) {
                PrivateKey serverPrivateKey = km.getPrivateKey(serverAlias);
                if (serverPrivateKey == null) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                    SSLLogger.finest(serverAlias + " is not a private key entry", new Object[0]);
                    continue;
                }
                X509Certificate[] serverCerts = km.getCertificateChain(serverAlias);
                if (serverCerts == null || serverCerts.length == 0) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                    SSLLogger.finest(serverAlias + " is not a certificate entry", new Object[0]);
                    continue;
                }
                PublicKey serverPublicKey = serverCerts[0].getPublicKey();
                if (!GMConstants.equalsAlgorithm(keyType, serverPrivateKey.getAlgorithm()) || !GMConstants.equalsAlgorithm(keyType, serverPublicKey.getAlgorithm())) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                        SSLLogger.fine(serverAlias + " private or public key is not of " + keyType + " algorithm", new Object[0]);
                    }
                    return null;
                }
                if (!isClientMode && "SM2".equals(keyType) && !this.isValidNamedGroup(serverAlias, serverPublicKey, shc)) continue;
                if (GMTlsUtil.isSignCert(serverCerts[0]) && signCerts == null) {
                    signPrivateKey = serverPrivateKey;
                    signCerts = serverCerts;
                } else {
                    if (!GMTlsUtil.isEncCert(serverCerts[0]) || encCerts != null) continue;
                    encPrivateKey = serverPrivateKey;
                    encCerts = serverCerts;
                }
                if (!this.isValidDoubleCertificate(signCerts, encCerts)) continue;
                isValid = true;
                break;
            }
            return isValid ? new GMX509Possession(signPrivateKey, signCerts, encPrivateKey, encCerts) : null;
        }

        private boolean isValidNamedGroup(String alias, PublicKey publicKey, HandshakeContext shc) {
            if (!(publicKey instanceof ECPublicKey)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning(alias + " public key is not an instance of ECPublicKey", new Object[0]);
                }
                return false;
            }
            ECParameterSpec params = ((ECPublicKey)publicKey).getParams();
            SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(params);
            if (namedGroup == null || !SupportedGroupsExtension.SupportedGroups.isSupported(namedGroup) || !namedGroup.isAvailable(shc.negotiatedProtocol) || shc.clientRequestedNamedGroups != null && !shc.clientRequestedNamedGroups.contains((Object)namedGroup)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("Unsupported named group (" + (Object)((Object)namedGroup) + ") used in the " + alias + " certificate", new Object[0]);
                }
                return false;
            }
            return true;
        }

        private boolean isValidDoubleCertificate(X509Certificate[] signCerts, X509Certificate[] encCerts) {
            return signCerts != null && encCerts != null;
        }
    }
}

