/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.com.sun.crypto.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class HmacPKCS12PBECore
extends MacSpi
implements Cloneable {
    private final String kdfAlgorithm;
    private final String hashAlgorithm;
    private final int blockLength;
    private Mac mac;

    HmacPKCS12PBECore(String kdfAlgorithm, String hashAlgorithm, int blockLength) throws NoSuchAlgorithmException {
        this.kdfAlgorithm = kdfAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.blockLength = blockLength;
        this.mac = Mac.getInstance(kdfAlgorithm);
    }

    @Override
    protected int engineGetMacLength() {
        return this.mac.getMacLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        char[] passwdChars;
        byte[] salt = null;
        int iCount = 0;
        if (key instanceof PBEKey) {
            PBEKey pbeKey = (PBEKey)key;
            passwdChars = pbeKey.getPassword();
            salt = pbeKey.getSalt();
            iCount = pbeKey.getIterationCount();
        } else if (key instanceof SecretKey) {
            byte[] passwdBytes;
            if (!key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3) || (passwdBytes = key.getEncoded()) == null) {
                throw new InvalidKeyException("Missing password");
            }
            passwdChars = new char[passwdBytes.length];
            for (int i = 0; i < passwdChars.length; ++i) {
                passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
            }
            Arrays.fill(passwdBytes, (byte)0);
        } else {
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        try {
            if (params == null) {
                if (salt == null || iCount == 0) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec required for salt and iteration count");
                }
            } else {
                if (!(params instanceof PBEParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
                }
                PBEParameterSpec pbeParams = (PBEParameterSpec)params;
                if (salt != null) {
                    if (!Arrays.equals(salt, pbeParams.getSalt())) {
                        throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                    }
                } else {
                    salt = pbeParams.getSalt();
                }
                if (iCount != 0) {
                    if (iCount != pbeParams.getIterationCount()) {
                        throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                    }
                } else {
                    iCount = pbeParams.getIterationCount();
                }
            }
            if (salt.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            if (iCount <= 0) {
                throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
            }
            byte[] derivedKey = HmacPKCS12PBECore.derive(passwdChars, salt, iCount, this.engineGetMacLength(), 3, this.hashAlgorithm, this.blockLength);
            this.mac.init(new SecretKeySpec(derivedKey, this.kdfAlgorithm));
        }
        finally {
            Arrays.fill(passwdChars, '\u0000');
        }
    }

    static byte[] derive(char[] chars, byte[] salt, int ic, int n, int type, String hashAlgo, int blockLength) {
        int length = chars.length * 2;
        if (length == 2 && chars[0] == '\u0000') {
            chars = new char[]{};
            length = 0;
        } else {
            length += 2;
        }
        byte[] passwd = new byte[length];
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            passwd[j] = (byte)(chars[i] >>> 8 & 0xFF);
            passwd[j + 1] = (byte)(chars[i] & 0xFF);
            ++i;
            j += 2;
        }
        byte[] key = new byte[n];
        try {
            MessageDigest sha = MessageDigest.getInstance(hashAlgo);
            int v = blockLength;
            int u = sha.getDigestLength();
            int c = HmacPKCS12PBECore.roundup(n, u) / u;
            byte[] D = new byte[v];
            int s = HmacPKCS12PBECore.roundup(salt.length, v);
            int p = HmacPKCS12PBECore.roundup(passwd.length, v);
            byte[] I = new byte[s + p];
            Arrays.fill(D, (byte)type);
            HmacPKCS12PBECore.concat(salt, I, 0, s);
            HmacPKCS12PBECore.concat(passwd, I, s, p);
            Arrays.fill(passwd, (byte)0);
            byte[] B = new byte[v];
            byte[] tmp = new byte[v];
            int i2 = 0;
            while (true) {
                sha.update(D);
                sha.update(I);
                byte[] Ai = sha.digest();
                for (int r = 1; r < ic; ++r) {
                    Ai = sha.digest(Ai);
                }
                System.arraycopy(Ai, 0, key, u * i2, Math.min(n, u));
                if (i2 + 1 != c) {
                    HmacPKCS12PBECore.concat(Ai, B, 0, B.length);
                    BigInteger B1 = new BigInteger(1, B).add(BigInteger.ONE);
                    for (int j2 = 0; j2 < I.length; j2 += v) {
                        if (tmp.length != v) {
                            tmp = new byte[v];
                        }
                        System.arraycopy(I, j2, tmp, 0, v);
                        BigInteger Ij = new BigInteger(1, tmp);
                        Ij = Ij.add(B1);
                        tmp = Ij.toByteArray();
                        int trunc = tmp.length - v;
                        if (trunc >= 0) {
                            System.arraycopy(tmp, trunc, I, j2, v);
                            continue;
                        }
                        if (trunc >= 0) continue;
                        Arrays.fill(I, j2, j2 + -trunc, (byte)0);
                        System.arraycopy(tmp, 0, I, j2 + -trunc, tmp.length);
                    }
                    ++i2;
                    n -= u;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("internal error: " + e);
        }
        return key;
    }

    private static int roundup(int x, int y) {
        return (x + (y - 1)) / y * y;
    }

    private static void concat(byte[] src, byte[] dst, int start, int len) {
        if (src.length == 0) {
            return;
        }
        int loop = len / src.length;
        int i = 0;
        int off = 0;
        while (i < loop) {
            System.arraycopy(src, 0, dst, off + start, src.length);
            ++i;
            off += src.length;
        }
        System.arraycopy(src, 0, dst, off + start, len - off);
    }

    @Override
    protected void engineUpdate(byte input) {
        this.mac.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.mac.update(input, offset, len);
    }

    @Override
    protected byte[] engineDoFinal() {
        return this.mac.doFinal();
    }

    @Override
    protected void engineReset() {
        this.mac.reset();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        HmacPKCS12PBECore hmacPKCS12PBECore = (HmacPKCS12PBECore)super.clone();
        hmacPKCS12PBECore.mac = (Mac)this.mac.clone();
        return hmacPKCS12PBECore;
    }

    public static final class HmacPKCS12PBESM3
    extends HmacPKCS12PBECore {
        public HmacPKCS12PBESM3() throws NoSuchAlgorithmException {
            super("HmacSM3", "SM3", 64);
        }
    }
}

