/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2KeyExchangeUtil {
    private static final byte[] DEFAULT_ID = "1234567812345678".getBytes();
    private static boolean DEBUG = false;

    public static byte[] generateSharedSecret(ECPublicKey localPublicKey, ECPrivateKey localPrivateKey, BigInteger localRandom, byte[] localId, ECPublicKey peerPublicKey, byte[] peerRBytes, byte[] peerId, int secretLen, boolean active) throws IOException, NoSuchAlgorithmException {
        BigInteger rA = localRandom;
        ECPoint RA = SM2KeyExchangeUtil.generateR(localPublicKey, rA);
        BigInteger n = localPublicKey.getParameters().getN();
        int w = (int)Math.ceil((double)n.subtract(BigInteger.ONE).bitLength() / 2.0) - 1;
        BigInteger wk = BigInteger.ONE.shiftLeft(w);
        BigInteger x1 = RA.getXCoord().toBigInteger();
        x1 = wk.add(x1.and(wk.subtract(BigInteger.ONE)));
        BigInteger dA = localPrivateKey.getD();
        BigInteger tA = dA.add(x1.multiply(rA)).mod(n);
        ECPoint RB = peerPublicKey.getParameters().getCurve().decodePoint(peerRBytes);
        BigInteger x2 = RB.getXCoord().toBigInteger();
        x2 = wk.add(x2.and(wk.subtract(BigInteger.ONE)));
        BigInteger h = localPublicKey.getParameters().getH();
        ECPoint PB = peerPublicKey.getQ();
        ECPoint V = PB.add(RB.multiply(x2)).multiply(h.multiply(tA)).normalize();
        BigInteger xV = V.getXCoord().toBigInteger();
        BigInteger yV = V.getYCoord().toBigInteger();
        MessageDigest messageDigest = MessageDigest.getInstance("SM3");
        byte[] ZA = SM2KeyExchangeUtil.generateZ(localId, localPublicKey, messageDigest);
        byte[] ZB = SM2KeyExchangeUtil.generateZ(peerId, peerPublicKey, messageDigest);
        byte[] bytes = SM2KeyExchangeUtil.concat(xV, yV, ZA, ZB, active);
        byte[] sharedSecret = SM2KeyExchangeUtil.KDF(bytes, secretLen, messageDigest);
        if (DEBUG) {
            System.out.println("xV = " + xV.toString(16));
            System.out.println("yV = " + yV.toString(16));
            System.out.println("ZA =" + new BigInteger(ZA).toString(16));
            System.out.println("ZB =" + new BigInteger(ZB).toString(16));
            System.out.println("(xv || yv || ZA || ZB) = " + Arrays.toString(bytes));
            System.out.println("sharedSecret = " + Arrays.toString(sharedSecret));
        }
        return sharedSecret;
    }

    public static ECPoint generateR(ECPublicKey publicKey, BigInteger random) {
        ECPoint g = publicKey.getParameters().getG();
        return g.multiply(random).normalize();
    }

    public static BigInteger generateRandom(ECPublicKey publicKey, SecureRandom secureRandom) {
        BigInteger n = publicKey.getParameters().getN();
        return SM2KeyExchangeUtil.generateRandom(n, secureRandom);
    }

    public static BigInteger generateRandom(BigInteger n, SecureRandom secureRandom) {
        BigInteger random;
        int len = n.bitLength() / 8;
        int iterationCount = 64;
        int iterationIndex = 0;
        while (true) {
            if ((random = new BigInteger(n.bitLength(), secureRandom)).compareTo(n) >= 0 || BigInteger.ONE.equals(random)) {
                continue;
            }
            if (random.bitLength() / 8 == len) {
                ++iterationIndex;
                continue;
            }
            if (iterationIndex >= iterationCount) break;
        }
        return random;
    }

    public static byte[] generateZ(byte[] idBytes, ECPublicKey publicKey, MessageDigest messageDigest) {
        if (idBytes == null) {
            idBytes = DEFAULT_ID;
        }
        int idBitsLen = idBytes.length * 8;
        ECCurve curve = publicKey.getParameters().getCurve();
        BigInteger a = curve.getA().toBigInteger();
        BigInteger b = curve.getB().toBigInteger();
        ECPoint g = publicKey.getParameters().getG();
        BigInteger gX = g.getXCoord().toBigInteger();
        BigInteger gY = g.getYCoord().toBigInteger();
        ECPoint q = publicKey.getQ();
        BigInteger qX = q.getXCoord().toBigInteger();
        BigInteger qY = q.getYCoord().toBigInteger();
        int m = 0;
        if (curve instanceof ECCurve.F2m) {
            m = ((ECCurve.F2m)curve).getM();
        }
        BigInteger[] elements = new BigInteger[]{a, b, gX, gY, qX, qY};
        byte[] idLenBytes = new byte[]{(byte)(idBitsLen >> 8), (byte)idBitsLen};
        messageDigest.update(idLenBytes);
        messageDigest.update(idBytes);
        for (BigInteger element : elements) {
            messageDigest.update(SM2KeyExchangeUtil.convertToBytes(element, m));
        }
        return messageDigest.digest();
    }

    public static byte[] KDF(byte[] bytes, int keyLength, MessageDigest messageDigest) {
        byte[] digestBytes;
        int digestLength = messageDigest.getDigestLength();
        int hashBitsLen = digestLength * 8;
        byte[] keyBytes = new byte[keyLength];
        int keyBitsLen = keyLength * 8;
        int count = keyBitsLen / hashBitsLen + 1;
        byte[] iBytes = new byte[4];
        for (int i = 1; i < count; ++i) {
            messageDigest.update(bytes);
            SM2KeyExchangeUtil.intToBytes(iBytes, i);
            messageDigest.update(iBytes);
            digestBytes = messageDigest.digest();
            System.arraycopy(digestBytes, 0, keyBytes, (i - 1) * digestLength, digestLength);
        }
        int remainBits = keyBitsLen % hashBitsLen;
        if (remainBits != 0) {
            messageDigest.update(bytes);
            SM2KeyExchangeUtil.intToBytes(iBytes, count);
            messageDigest.update(iBytes);
            digestBytes = messageDigest.digest();
            System.arraycopy(digestBytes, 0, keyBytes, (count - 1) * digestLength, remainBits / 8);
        }
        return keyBytes;
    }

    private static void intToBytes(byte[] iBytes, int num) {
        iBytes[3] = (byte)num;
        iBytes[2] = (byte)(num >> 8 & 0xFF);
        iBytes[1] = (byte)(num >> 16 & 0xFF);
        iBytes[0] = (byte)(num >> 24 & 0xFF);
    }

    private static byte[] concat(BigInteger xV, BigInteger yV, byte[] ZA, byte[] ZB, boolean active) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(SM2KeyExchangeUtil.convertToBytes(xV));
        outputStream.write(SM2KeyExchangeUtil.convertToBytes(yV));
        if (active) {
            outputStream.write(ZA);
            outputStream.write(ZB);
        } else {
            outputStream.write(ZB);
            outputStream.write(ZA);
        }
        return outputStream.toByteArray();
    }

    private static byte[] convertToBytes(BigInteger val) {
        byte[] bytes = val.toByteArray();
        byte[] newBytes = new byte[32];
        if (bytes.length < 32) {
            System.arraycopy(bytes, 0, newBytes, 32 - bytes.length, bytes.length);
        } else {
            System.arraycopy(bytes, bytes.length - 32, newBytes, 0, newBytes.length);
        }
        return newBytes;
    }

    private static byte[] convertToBytes(BigInteger val, int m) {
        if (m == 0) {
            return SM2KeyExchangeUtil.convertToBytes(val);
        }
        int size = m % 8 == 0 ? m / 8 : m / 8 + 1;
        byte[] bytes = SM2KeyExchangeUtil.convertToBytes(val);
        if (bytes.length == size) {
            return bytes;
        }
        byte[] newBytes = new byte[size];
        if (bytes.length >= size) {
            System.arraycopy(bytes, 0, newBytes, size - bytes.length, bytes.length);
        }
        return newBytes;
    }

    public static ECPublicKey generatePublicKey(ECPrivateKey privateKey) throws InvalidKeyException {
        ECParameterSpec parameters = privateKey.getParameters();
        BigInteger d = privateKey.getD();
        ECPoint G = parameters.getG();
        ECPoint P = G.multiply(d);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(P, parameters);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(privateKey.getAlgorithm());
            return (ECPublicKey)keyFactory.generatePublic((KeySpec)ecPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }
}

