/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import java.util.Objects;

public class SegmentFinder {
    private final String segmentName;
    private int repetition;

    private SegmentFinder(String segmentName, int repetition) {
        this.segmentName = Objects.requireNonNull(segmentName);
        if (repetition < 0) {
            throw new IllegalArgumentException("Repetition number must be non-negative");
        }
        this.repetition = repetition;
    }

    public static Segment find(Message message, String segmentName, int repetition) throws HL7Exception {
        Objects.requireNonNull(message);
        SegmentFinder segmentFinder = new SegmentFinder(segmentName, repetition);
        return segmentFinder.find((Group)message);
    }

    private Segment find(Group group) throws HL7Exception {
        for (String name : group.getNames()) {
            Structure[] structures = group.getAll(name);
            if (structures.length <= 0) continue;
            if (structures[0] instanceof Segment && this.segmentName.equals(structures[0].getName())) {
                if (structures.length > this.repetition) {
                    return (Segment)structures[this.repetition];
                }
                this.repetition -= structures.length;
                continue;
            }
            if (!(structures[0] instanceof Group)) continue;
            for (Structure structure : structures) {
                Segment segment = this.find((Group)structure);
                if (segment == null) continue;
                return segment;
            }
        }
        return null;
    }
}

