/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.xml;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import net.sf.saxon.lib.StandardURIResolver;
import org.openehealth.ipf.commons.core.modules.api.Transmogrifier;
import org.openehealth.ipf.commons.xml.AbstractCachingXmlProcessor;
import org.openehealth.ipf.commons.xml.ClasspathUriResolver;
import org.openehealth.ipf.commons.xml.ResultHolder;
import org.openehealth.ipf.commons.xml.ResultHolderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltTransmogrifier<T>
extends AbstractCachingXmlProcessor<Templates>
implements Transmogrifier<Source, T> {
    private static final Logger LOG = LoggerFactory.getLogger(XsltTransmogrifier.class);
    private static final ConcurrentMap<String, AbstractCachingXmlProcessor.Loader<Templates>> XSLT_CACHE = new ConcurrentHashMap<String, AbstractCachingXmlProcessor.Loader<Templates>>();
    private Map<String, Object> staticParams;
    private final TransformerFactory factory = TransformerFactory.newInstance();
    private final URIResolver resolver = this.factory.getURIResolver() != null ? new ClasspathUriResolver(this.factory.getURIResolver()) : new ClasspathUriResolver((URIResolver)new StandardURIResolver());
    private final Class<T> outputFormat;

    public XsltTransmogrifier() {
        this(String.class, null, null);
    }

    public XsltTransmogrifier(Class<T> outputFormat) {
        this(outputFormat, null, null);
    }

    public XsltTransmogrifier(Class<T> outputFormat, ClassLoader classLoader) {
        this(outputFormat, classLoader, null);
    }

    public XsltTransmogrifier(Class<T> outputFormat, Map<String, Object> staticParams) {
        this(outputFormat, null, staticParams);
    }

    public TransformerFactory getFactory() {
        return this.factory;
    }

    @Override
    protected ConcurrentMap<String, AbstractCachingXmlProcessor.Loader<Templates>> getCache() {
        return XSLT_CACHE;
    }

    public XsltTransmogrifier(Class<T> outputFormat, ClassLoader classLoader, Map<String, Object> staticParams) {
        super(classLoader);
        this.factory.setURIResolver(this.resolver);
        this.outputFormat = outputFormat;
        this.staticParams = staticParams;
    }

    public T zap(Source source, Object ... params) {
        ResultHolder<T> accessor = ResultHolderFactory.create(this.outputFormat);
        if (accessor == null) {
            throw new IllegalArgumentException("Format " + this.outputFormat + " is not supported");
        }
        Result result = accessor.createResult();
        this.doZap(source, result, params);
        return accessor.getResult();
    }

    private void doZap(Source source, Result result, Object ... params) {
        if (params.length == 0) {
            throw new IllegalArgumentException("Expected XSL location in first parameter");
        }
        try {
            Templates template = (Templates)this.resource(params);
            Transformer transformer = template.newTransformer();
            transformer.setURIResolver(this.resolver);
            this.setXsltParameters(transformer, this.staticParams);
            this.setXsltParameters(transformer, this.resourceParameters(params));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException("XSLT processing failed", e);
        }
    }

    protected void setXsltParameters(Transformer transformer, Map<String, Object> param) {
        if (param == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            LOG.debug("Add new parameter for transformer: {}", (Object)entry.getKey());
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected Templates createResource(Object ... params) {
        try {
            return this.factory.newTemplates(this.resourceContent(params));
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalArgumentException("Could not initialize XSLT template", e);
        }
    }

    public Map<String, Object> getStaticParams() {
        return this.staticParams;
    }

    public void setStaticParams(Map<String, Object> staticParams) {
        this.staticParams = staticParams;
    }
}

