/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.xml;

import java.util.Objects;
import org.openehealth.ipf.commons.core.modules.api.ValidationException;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.xml.CombinedXmlValidationProfile;
import org.openehealth.ipf.commons.xml.SchematronProfile;
import org.openehealth.ipf.commons.xml.SchematronValidator;
import org.openehealth.ipf.commons.xml.XmlUtils;
import org.openehealth.ipf.commons.xml.XsdValidator;

public class CombinedXmlValidator
implements Validator<String, CombinedXmlValidationProfile> {
    private static final XsdValidator XSD_VALIDATOR = new XsdValidator(CombinedXmlValidator.class.getClassLoader());
    private static final SchematronValidator SCHEMATRON_VALIDATOR = new SchematronValidator();

    public void validate(String message, CombinedXmlValidationProfile profile) throws ValidationException {
        String schematronPath;
        Objects.requireNonNull(profile, "validation profile must be not null");
        String rootElementName = XmlUtils.rootElementName(Objects.requireNonNull(message, "message must be not null"));
        if (!profile.isValidRootElement(rootElementName)) {
            throw new ValidationException("Invalid root element '" + rootElementName + "'");
        }
        String xsdPath = profile.getXsdPath(rootElementName);
        if (xsdPath != null) {
            XSD_VALIDATOR.validate(XmlUtils.source(message), xsdPath);
        }
        if ((schematronPath = profile.getSchematronPath(rootElementName)) != null) {
            SchematronProfile schematronProfile = new SchematronProfile(schematronPath, profile.getCustomSchematronParameters(rootElementName));
            SCHEMATRON_VALIDATOR.validate(XmlUtils.source(message), schematronProfile);
        }
    }
}

