/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.xml;

import java.net.URL;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;

public class ClasspathResourceResolver
implements ResourceResolver {
    private final ResourceResolver standardResolver;

    public ClasspathResourceResolver(ResourceResolver resolver) {
        this.standardResolver = Objects.requireNonNull(resolver);
    }

    public Source resolve(ResourceRequest resourceRequest) throws XPathException {
        URL url = this.getClass().getClassLoader().getResource(resourceRequest.relativeUri);
        if (url != null) {
            SAXSource saxSource = new SAXSource();
            saxSource.setInputSource(new InputSource(url.toString()));
            saxSource.setSystemId(url.toString());
            return saxSource;
        }
        return this.standardResolver.resolve(resourceRequest);
    }
}

