/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.xml;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.transform.stream.StreamSource;
import org.openehealth.ipf.commons.xml.SchematronProfile;

public abstract class AbstractCachingXmlProcessor<T> {
    public static final String RESOURCE_LOCATION = "org.openehealth.ipf.commons.xml.ResourceLocation";

    protected AbstractCachingXmlProcessor(ClassLoader classLoader) {
    }

    protected abstract ConcurrentMap<String, Loader<T>> getCache();

    protected String resourceLocation(Object ... params) {
        if (params[0] instanceof String) {
            return (String)params[0];
        }
        if (params[0] instanceof Map) {
            return (String)((Map)params[0]).get(RESOURCE_LOCATION);
        }
        if (params[0] instanceof SchematronProfile) {
            SchematronProfile p = (SchematronProfile)params[0];
            return p.getRules();
        }
        throw new IllegalStateException("Cannot extract resource location");
    }

    protected String resourceCacheKey(Object ... params) {
        return this.resourceLocation(params);
    }

    protected Map<String, Object> resourceParameters(Object ... params) {
        if (params[0] instanceof Map) {
            return (Map)params[0];
        }
        if (params[0] instanceof SchematronProfile) {
            SchematronProfile p = (SchematronProfile)params[0];
            return p.getParameters();
        }
        if (params.length > 1 && params[1] instanceof Map) {
            return (Map)params[1];
        }
        return null;
    }

    protected T resource(final Object ... params) throws Exception {
        String key = this.resourceCacheKey(params);
        this.getCache().putIfAbsent(key, new Loader<T>(){

            @Override
            protected T load() throws RuntimeException {
                return AbstractCachingXmlProcessor.this.createResource(params);
            }
        });
        return (T)((Loader)this.getCache().get(key)).get();
    }

    protected abstract T createResource(Object ... var1);

    protected StreamSource resourceContent(Object ... params) {
        String location = this.resourceLocation(params);
        try {
            URL url;
            block6: {
                if (location.startsWith("/")) {
                    url = this.getClass().getResource(location);
                } else {
                    try {
                        url = new URL(location);
                    }
                    catch (MalformedURLException ex) {
                        url = this.getClass().getClassLoader().getResource(location);
                        if (url != null) break block6;
                        throw new IOException("Location not found");
                    }
                }
            }
            return new StreamSource(url.openStream(), url.toExternalForm());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The resource " + location + " is not valid", e);
        }
    }

    protected static abstract class Loader<S> {
        private S loaded;

        protected Loader() {
        }

        protected abstract S load() throws RuntimeException;

        synchronized S get() {
            if (this.loaded == null) {
                this.loaded = this.load();
            }
            return this.loaded;
        }
    }
}

