/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.vpp.nsh.state.nsh.maps;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.ActionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.EncapType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.NshMapBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.vpp.nsh.state.nsh.maps.NshMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.vpp.nsh.state.nsh.maps.NshMapKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NshMapBuilder
implements Builder<NshMap> {
    private String _encapIfName;
    private Class<? extends EncapType> _encapType;
    private NshMapKey _key;
    private Short _mappedNsi;
    private Long _mappedNsp;
    private String _name;
    private Class<? extends ActionType> _nshAction;
    private Short _nsi;
    private Long _nsp;
    Map<Class<? extends Augmentation<NshMap>>, Augmentation<NshMap>> augmentation = Collections.emptyMap();

    public NshMapBuilder() {
    }

    public NshMapBuilder(NshMapBaseAttributes arg) {
        this._name = arg.getName();
        this._nsp = arg.getNsp();
        this._nsi = arg.getNsi();
        this._mappedNsp = arg.getMappedNsp();
        this._mappedNsi = arg.getMappedNsi();
        this._nshAction = arg.getNshAction();
        this._encapType = arg.getEncapType();
        this._encapIfName = arg.getEncapIfName();
    }

    public NshMapBuilder(NshMap base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new NshMapKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._encapIfName = base.getEncapIfName();
        this._encapType = base.getEncapType();
        this._mappedNsi = base.getMappedNsi();
        this._mappedNsp = base.getMappedNsp();
        this._nshAction = base.getNshAction();
        this._nsi = base.getNsi();
        this._nsp = base.getNsp();
        if (base instanceof NshMapImpl) {
            NshMapImpl impl = (NshMapImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NshMap>>, Augmentation<NshMap>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NshMap>>, Augmentation<NshMap>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NshMapBaseAttributes) {
            this._name = ((NshMapBaseAttributes)arg).getName();
            this._nsp = ((NshMapBaseAttributes)arg).getNsp();
            this._nsi = ((NshMapBaseAttributes)arg).getNsi();
            this._mappedNsp = ((NshMapBaseAttributes)arg).getMappedNsp();
            this._mappedNsi = ((NshMapBaseAttributes)arg).getMappedNsi();
            this._nshAction = ((NshMapBaseAttributes)arg).getNshAction();
            this._encapType = ((NshMapBaseAttributes)arg).getEncapType();
            this._encapIfName = ((NshMapBaseAttributes)arg).getEncapIfName();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.NshMapBaseAttributes] \nbut was: " + arg);
        }
    }

    public String getEncapIfName() {
        return this._encapIfName;
    }

    public Class<? extends EncapType> getEncapType() {
        return this._encapType;
    }

    public NshMapKey getKey() {
        return this._key;
    }

    public Short getMappedNsi() {
        return this._mappedNsi;
    }

    public Long getMappedNsp() {
        return this._mappedNsp;
    }

    public String getName() {
        return this._name;
    }

    public Class<? extends ActionType> getNshAction() {
        return this._nshAction;
    }

    public Short getNsi() {
        return this._nsi;
    }

    public Long getNsp() {
        return this._nsp;
    }

    public <E extends Augmentation<NshMap>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NshMapBuilder setEncapIfName(String value) {
        this._encapIfName = value;
        return this;
    }

    public NshMapBuilder setEncapType(Class<? extends EncapType> value) {
        this._encapType = value;
        return this;
    }

    public NshMapBuilder setKey(NshMapKey value) {
        this._key = value;
        return this;
    }

    private static void checkMappedNsiRange(short value) {
        if (value >= 1 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..255]].", value));
    }

    public NshMapBuilder setMappedNsi(Short value) {
        if (value != null) {
            NshMapBuilder.checkMappedNsiRange(value);
        }
        this._mappedNsi = value;
        return this;
    }

    private static void checkMappedNspRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777215]].", value));
    }

    public NshMapBuilder setMappedNsp(Long value) {
        if (value != null) {
            NshMapBuilder.checkMappedNspRange(value);
        }
        this._mappedNsp = value;
        return this;
    }

    public NshMapBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public NshMapBuilder setNshAction(Class<? extends ActionType> value) {
        this._nshAction = value;
        return this;
    }

    private static void checkNsiRange(short value) {
        if (value >= 1 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..255]].", value));
    }

    public NshMapBuilder setNsi(Short value) {
        if (value != null) {
            NshMapBuilder.checkNsiRange(value);
        }
        this._nsi = value;
        return this;
    }

    private static void checkNspRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777215]].", value));
    }

    public NshMapBuilder setNsp(Long value) {
        if (value != null) {
            NshMapBuilder.checkNspRange(value);
        }
        this._nsp = value;
        return this;
    }

    public NshMapBuilder addAugmentation(Class<? extends Augmentation<NshMap>> augmentationType, Augmentation<NshMap> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NshMap>>, Augmentation<NshMap>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NshMapBuilder removeAugmentation(Class<? extends Augmentation<NshMap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NshMap build() {
        return new NshMapImpl(this);
    }

    private static final class NshMapImpl
    implements NshMap {
        private final String _encapIfName;
        private final Class<? extends EncapType> _encapType;
        private final NshMapKey _key;
        private final Short _mappedNsi;
        private final Long _mappedNsp;
        private final String _name;
        private final Class<? extends ActionType> _nshAction;
        private final Short _nsi;
        private final Long _nsp;
        private Map<Class<? extends Augmentation<NshMap>>, Augmentation<NshMap>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NshMap> getImplementedInterface() {
            return NshMap.class;
        }

        private NshMapImpl(NshMapBuilder base) {
            if (base.getKey() == null) {
                this._key = new NshMapKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._encapIfName = base.getEncapIfName();
            this._encapType = base.getEncapType();
            this._mappedNsi = base.getMappedNsi();
            this._mappedNsp = base.getMappedNsp();
            this._nshAction = base.getNshAction();
            this._nsi = base.getNsi();
            this._nsp = base.getNsp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NshMap>>, Augmentation<NshMap>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NshMap>>, Augmentation<NshMap>>(base.augmentation);
                }
            }
        }

        @Override
        public String getEncapIfName() {
            return this._encapIfName;
        }

        @Override
        public Class<? extends EncapType> getEncapType() {
            return this._encapType;
        }

        @Override
        public NshMapKey getKey() {
            return this._key;
        }

        @Override
        public Short getMappedNsi() {
            return this._mappedNsi;
        }

        @Override
        public Long getMappedNsp() {
            return this._mappedNsp;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Class<? extends ActionType> getNshAction() {
            return this._nshAction;
        }

        @Override
        public Short getNsi() {
            return this._nsi;
        }

        @Override
        public Long getNsp() {
            return this._nsp;
        }

        public <E extends Augmentation<NshMap>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._encapIfName);
            result = 31 * result + Objects.hashCode(this._encapType);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._mappedNsi);
            result = 31 * result + Objects.hashCode(this._mappedNsp);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._nshAction);
            result = 31 * result + Objects.hashCode(this._nsi);
            result = 31 * result + Objects.hashCode(this._nsp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NshMap.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NshMap other = (NshMap)obj;
            if (!Objects.equals(this._encapIfName, other.getEncapIfName())) {
                return false;
            }
            if (!Objects.equals(this._encapType, other.getEncapType())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._mappedNsi, other.getMappedNsi())) {
                return false;
            }
            if (!Objects.equals(this._mappedNsp, other.getMappedNsp())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._nshAction, other.getNshAction())) {
                return false;
            }
            if (!Objects.equals(this._nsi, other.getNsi())) {
                return false;
            }
            if (!Objects.equals(this._nsp, other.getNsp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NshMapImpl otherImpl = (NshMapImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NshMap>>, Augmentation<NshMap>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NshMap [";
            StringBuilder builder = new StringBuilder(name);
            if (this._encapIfName != null) {
                builder.append("_encapIfName=");
                builder.append(this._encapIfName);
                builder.append(", ");
            }
            if (this._encapType != null) {
                builder.append("_encapType=");
                builder.append(this._encapType);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._mappedNsi != null) {
                builder.append("_mappedNsi=");
                builder.append(this._mappedNsi);
                builder.append(", ");
            }
            if (this._mappedNsp != null) {
                builder.append("_mappedNsp=");
                builder.append(this._mappedNsp);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._nshAction != null) {
                builder.append("_nshAction=");
                builder.append(this._nshAction);
                builder.append(", ");
            }
            if (this._nsi != null) {
                builder.append("_nsi=");
                builder.append(this._nsi);
                builder.append(", ");
            }
            if (this._nsp != null) {
                builder.append("_nsp=");
                builder.append(this._nsp);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

