/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.vpp.nsh.nsh.entries;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.MdType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.NextProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.NshEntryBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.vpp.nsh.nsh.entries.NshEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.vpp.nsh.nsh.entries.NshEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NshEntryBuilder
implements Builder<NshEntry> {
    private NshEntryKey _key;
    private Short _length;
    private Class<? extends MdType> _mdType;
    private String _name;
    private Class<? extends NextProtocol> _nextProtocol;
    private Short _nsi;
    private Long _nsp;
    private Short _version;
    Map<Class<? extends Augmentation<NshEntry>>, Augmentation<NshEntry>> augmentation = Collections.emptyMap();

    public NshEntryBuilder() {
    }

    public NshEntryBuilder(NshEntryBaseAttributes arg) {
        this._name = arg.getName();
        this._nsp = arg.getNsp();
        this._nsi = arg.getNsi();
        this._mdType = arg.getMdType();
        this._version = arg.getVersion();
        this._length = arg.getLength();
        this._nextProtocol = arg.getNextProtocol();
    }

    public NshEntryBuilder(NshEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new NshEntryKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._length = base.getLength();
        this._mdType = base.getMdType();
        this._nextProtocol = base.getNextProtocol();
        this._nsi = base.getNsi();
        this._nsp = base.getNsp();
        this._version = base.getVersion();
        if (base instanceof NshEntryImpl) {
            NshEntryImpl impl = (NshEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NshEntry>>, Augmentation<NshEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NshEntry>>, Augmentation<NshEntry>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NshEntryBaseAttributes) {
            this._name = ((NshEntryBaseAttributes)arg).getName();
            this._nsp = ((NshEntryBaseAttributes)arg).getNsp();
            this._nsi = ((NshEntryBaseAttributes)arg).getNsi();
            this._mdType = ((NshEntryBaseAttributes)arg).getMdType();
            this._version = ((NshEntryBaseAttributes)arg).getVersion();
            this._length = ((NshEntryBaseAttributes)arg).getLength();
            this._nextProtocol = ((NshEntryBaseAttributes)arg).getNextProtocol();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.NshEntryBaseAttributes] \nbut was: " + arg);
        }
    }

    public NshEntryKey getKey() {
        return this._key;
    }

    public Short getLength() {
        return this._length;
    }

    public Class<? extends MdType> getMdType() {
        return this._mdType;
    }

    public String getName() {
        return this._name;
    }

    public Class<? extends NextProtocol> getNextProtocol() {
        return this._nextProtocol;
    }

    public Short getNsi() {
        return this._nsi;
    }

    public Long getNsp() {
        return this._nsp;
    }

    public Short getVersion() {
        return this._version;
    }

    public <E extends Augmentation<NshEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NshEntryBuilder setKey(NshEntryKey value) {
        this._key = value;
        return this;
    }

    private static void checkLengthRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public NshEntryBuilder setLength(Short value) {
        if (value != null) {
            NshEntryBuilder.checkLengthRange(value);
        }
        this._length = value;
        return this;
    }

    public NshEntryBuilder setMdType(Class<? extends MdType> value) {
        this._mdType = value;
        return this;
    }

    public NshEntryBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public NshEntryBuilder setNextProtocol(Class<? extends NextProtocol> value) {
        this._nextProtocol = value;
        return this;
    }

    private static void checkNsiRange(short value) {
        if (value >= 1 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..255]].", value));
    }

    public NshEntryBuilder setNsi(Short value) {
        if (value != null) {
            NshEntryBuilder.checkNsiRange(value);
        }
        this._nsi = value;
        return this;
    }

    private static void checkNspRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777215]].", value));
    }

    public NshEntryBuilder setNsp(Long value) {
        if (value != null) {
            NshEntryBuilder.checkNspRange(value);
        }
        this._nsp = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public NshEntryBuilder setVersion(Short value) {
        if (value != null) {
            NshEntryBuilder.checkVersionRange(value);
        }
        this._version = value;
        return this;
    }

    public NshEntryBuilder addAugmentation(Class<? extends Augmentation<NshEntry>> augmentationType, Augmentation<NshEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NshEntry>>, Augmentation<NshEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NshEntryBuilder removeAugmentation(Class<? extends Augmentation<NshEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NshEntry build() {
        return new NshEntryImpl(this);
    }

    private static final class NshEntryImpl
    implements NshEntry {
        private final NshEntryKey _key;
        private final Short _length;
        private final Class<? extends MdType> _mdType;
        private final String _name;
        private final Class<? extends NextProtocol> _nextProtocol;
        private final Short _nsi;
        private final Long _nsp;
        private final Short _version;
        private Map<Class<? extends Augmentation<NshEntry>>, Augmentation<NshEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NshEntry> getImplementedInterface() {
            return NshEntry.class;
        }

        private NshEntryImpl(NshEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new NshEntryKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._length = base.getLength();
            this._mdType = base.getMdType();
            this._nextProtocol = base.getNextProtocol();
            this._nsi = base.getNsi();
            this._nsp = base.getNsp();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NshEntry>>, Augmentation<NshEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NshEntry>>, Augmentation<NshEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public NshEntryKey getKey() {
            return this._key;
        }

        @Override
        public Short getLength() {
            return this._length;
        }

        @Override
        public Class<? extends MdType> getMdType() {
            return this._mdType;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Class<? extends NextProtocol> getNextProtocol() {
            return this._nextProtocol;
        }

        @Override
        public Short getNsi() {
            return this._nsi;
        }

        @Override
        public Long getNsp() {
            return this._nsp;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        public <E extends Augmentation<NshEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._length);
            result = 31 * result + Objects.hashCode(this._mdType);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._nextProtocol);
            result = 31 * result + Objects.hashCode(this._nsi);
            result = 31 * result + Objects.hashCode(this._nsp);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NshEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NshEntry other = (NshEntry)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._length, other.getLength())) {
                return false;
            }
            if (!Objects.equals(this._mdType, other.getMdType())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._nextProtocol, other.getNextProtocol())) {
                return false;
            }
            if (!Objects.equals(this._nsi, other.getNsi())) {
                return false;
            }
            if (!Objects.equals(this._nsp, other.getNsp())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NshEntryImpl otherImpl = (NshEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NshEntry>>, Augmentation<NshEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NshEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._length != null) {
                builder.append("_length=");
                builder.append(this._length);
                builder.append(", ");
            }
            if (this._mdType != null) {
                builder.append("_mdType=");
                builder.append(this._mdType);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._nextProtocol != null) {
                builder.append("_nextProtocol=");
                builder.append(this._nextProtocol);
                builder.append(", ");
            }
            if (this._nsi != null) {
                builder.append("_nsi=");
                builder.append(this._nsi);
                builder.append(", ");
            }
            if (this._nsp != null) {
                builder.append("_nsp=");
                builder.append(this._nsp);
                builder.append(", ");
            }
            if (this._version != null) {
                builder.append("_version=");
                builder.append(this._version);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

