/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.VppNsh;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.vpp.nsh.NshEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.nsh.rev161214.vpp.nsh.NshMaps;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VppNshBuilder
implements Builder<VppNsh> {
    private NshEntries _nshEntries;
    private NshMaps _nshMaps;
    Map<Class<? extends Augmentation<VppNsh>>, Augmentation<VppNsh>> augmentation = Collections.emptyMap();

    public VppNshBuilder() {
    }

    public VppNshBuilder(VppNsh base) {
        AugmentationHolder casted;
        this._nshEntries = base.getNshEntries();
        this._nshMaps = base.getNshMaps();
        if (base instanceof VppNshImpl) {
            VppNshImpl impl = (VppNshImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<VppNsh>>, Augmentation<VppNsh>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VppNsh>>, Augmentation<VppNsh>>(casted.augmentations());
        }
    }

    public NshEntries getNshEntries() {
        return this._nshEntries;
    }

    public NshMaps getNshMaps() {
        return this._nshMaps;
    }

    public <E extends Augmentation<VppNsh>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VppNshBuilder setNshEntries(NshEntries value) {
        this._nshEntries = value;
        return this;
    }

    public VppNshBuilder setNshMaps(NshMaps value) {
        this._nshMaps = value;
        return this;
    }

    public VppNshBuilder addAugmentation(Class<? extends Augmentation<VppNsh>> augmentationType, Augmentation<VppNsh> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VppNsh>>, Augmentation<VppNsh>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public VppNshBuilder removeAugmentation(Class<? extends Augmentation<VppNsh>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VppNsh build() {
        return new VppNshImpl(this);
    }

    private static final class VppNshImpl
    implements VppNsh {
        private final NshEntries _nshEntries;
        private final NshMaps _nshMaps;
        private Map<Class<? extends Augmentation<VppNsh>>, Augmentation<VppNsh>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<VppNsh> getImplementedInterface() {
            return VppNsh.class;
        }

        private VppNshImpl(VppNshBuilder base) {
            this._nshEntries = base.getNshEntries();
            this._nshMaps = base.getNshMaps();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VppNsh>>, Augmentation<VppNsh>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VppNsh>>, Augmentation<VppNsh>>(base.augmentation);
                }
            }
        }

        @Override
        public NshEntries getNshEntries() {
            return this._nshEntries;
        }

        @Override
        public NshMaps getNshMaps() {
            return this._nshMaps;
        }

        public <E extends Augmentation<VppNsh>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._nshEntries);
            result = 31 * result + Objects.hashCode(this._nshMaps);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VppNsh.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VppNsh other = (VppNsh)obj;
            if (!Objects.equals(this._nshEntries, other.getNshEntries())) {
                return false;
            }
            if (!Objects.equals(this._nshMaps, other.getNshMaps())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VppNshImpl otherImpl = (VppNshImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VppNsh>>, Augmentation<VppNsh>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "VppNsh [";
            StringBuilder builder = new StringBuilder(name);
            if (this._nshEntries != null) {
                builder.append("_nshEntries=");
                builder.append(this._nshEntries);
                builder.append(", ");
            }
            if (this._nshMaps != null) {
                builder.append("_nshMaps=");
                builder.append(this._nshMaps);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

