/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.vpp.classifier;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.HexString;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.ClassifyTableBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.ClassifyTableConfigAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.VppNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.VppNodeName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.classify.table.base.attributes.ClassifySession;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.vpp.classifier.ClassifyTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.vpp.classifier.ClassifyTableKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ClassifyTableBuilder
implements Builder<ClassifyTable> {
    private VppNodeName _classifierNode;
    private List<ClassifySession> _classifySession;
    private ClassifyTableKey _key;
    private HexString _mask;
    private Long _memorySize;
    private VppNode _missNext;
    private String _name;
    private Long _nbuckets;
    private String _nextTable;
    private Long _skipNVectors;
    Map<Class<? extends Augmentation<ClassifyTable>>, Augmentation<ClassifyTable>> augmentation = Collections.emptyMap();

    public ClassifyTableBuilder() {
    }

    public ClassifyTableBuilder(ClassifyTableBaseAttributes arg) {
        this._classifierNode = arg.getClassifierNode();
        this._nbuckets = arg.getNbuckets();
        this._skipNVectors = arg.getSkipNVectors();
        this._nextTable = arg.getNextTable();
        this._missNext = arg.getMissNext();
        this._mask = arg.getMask();
        this._classifySession = arg.getClassifySession();
    }

    public ClassifyTableBuilder(ClassifyTableConfigAttributes arg) {
        this._memorySize = arg.getMemorySize();
    }

    public ClassifyTableBuilder(ClassifyTable base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ClassifyTableKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._classifierNode = base.getClassifierNode();
        this._classifySession = base.getClassifySession();
        this._mask = base.getMask();
        this._memorySize = base.getMemorySize();
        this._missNext = base.getMissNext();
        this._nbuckets = base.getNbuckets();
        this._nextTable = base.getNextTable();
        this._skipNVectors = base.getSkipNVectors();
        if (base instanceof ClassifyTableImpl) {
            ClassifyTableImpl impl = (ClassifyTableImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ClassifyTable>>, Augmentation<ClassifyTable>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ClassifyTable>>, Augmentation<ClassifyTable>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ClassifyTableBaseAttributes) {
            this._classifierNode = ((ClassifyTableBaseAttributes)arg).getClassifierNode();
            this._nbuckets = ((ClassifyTableBaseAttributes)arg).getNbuckets();
            this._skipNVectors = ((ClassifyTableBaseAttributes)arg).getSkipNVectors();
            this._nextTable = ((ClassifyTableBaseAttributes)arg).getNextTable();
            this._missNext = ((ClassifyTableBaseAttributes)arg).getMissNext();
            this._mask = ((ClassifyTableBaseAttributes)arg).getMask();
            this._classifySession = ((ClassifyTableBaseAttributes)arg).getClassifySession();
            isValidArg = true;
        }
        if (arg instanceof ClassifyTableConfigAttributes) {
            this._memorySize = ((ClassifyTableConfigAttributes)arg).getMemorySize();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.ClassifyTableBaseAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.ClassifyTableConfigAttributes] \nbut was: " + arg);
        }
    }

    public VppNodeName getClassifierNode() {
        return this._classifierNode;
    }

    public List<ClassifySession> getClassifySession() {
        return this._classifySession;
    }

    public ClassifyTableKey getKey() {
        return this._key;
    }

    public HexString getMask() {
        return this._mask;
    }

    public Long getMemorySize() {
        return this._memorySize;
    }

    public VppNode getMissNext() {
        return this._missNext;
    }

    public String getName() {
        return this._name;
    }

    public Long getNbuckets() {
        return this._nbuckets;
    }

    public String getNextTable() {
        return this._nextTable;
    }

    public Long getSkipNVectors() {
        return this._skipNVectors;
    }

    public <E extends Augmentation<ClassifyTable>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ClassifyTableBuilder setClassifierNode(VppNodeName value) {
        this._classifierNode = value;
        return this;
    }

    public ClassifyTableBuilder setClassifySession(List<ClassifySession> value) {
        this._classifySession = value;
        return this;
    }

    public ClassifyTableBuilder setKey(ClassifyTableKey value) {
        this._key = value;
        return this;
    }

    public ClassifyTableBuilder setMask(HexString value) {
        this._mask = value;
        return this;
    }

    private static void checkMemorySizeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ClassifyTableBuilder setMemorySize(Long value) {
        if (value != null) {
            ClassifyTableBuilder.checkMemorySizeRange(value);
        }
        this._memorySize = value;
        return this;
    }

    public ClassifyTableBuilder setMissNext(VppNode value) {
        this._missNext = value;
        return this;
    }

    public ClassifyTableBuilder setName(String value) {
        this._name = value;
        return this;
    }

    private static void checkNbucketsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ClassifyTableBuilder setNbuckets(Long value) {
        if (value != null) {
            ClassifyTableBuilder.checkNbucketsRange(value);
        }
        this._nbuckets = value;
        return this;
    }

    public ClassifyTableBuilder setNextTable(String value) {
        this._nextTable = value;
        return this;
    }

    private static void checkSkipNVectorsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ClassifyTableBuilder setSkipNVectors(Long value) {
        if (value != null) {
            ClassifyTableBuilder.checkSkipNVectorsRange(value);
        }
        this._skipNVectors = value;
        return this;
    }

    public ClassifyTableBuilder addAugmentation(Class<? extends Augmentation<ClassifyTable>> augmentationType, Augmentation<ClassifyTable> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ClassifyTable>>, Augmentation<ClassifyTable>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ClassifyTableBuilder removeAugmentation(Class<? extends Augmentation<ClassifyTable>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ClassifyTable build() {
        return new ClassifyTableImpl(this);
    }

    private static final class ClassifyTableImpl
    implements ClassifyTable {
        private final VppNodeName _classifierNode;
        private final List<ClassifySession> _classifySession;
        private final ClassifyTableKey _key;
        private final HexString _mask;
        private final Long _memorySize;
        private final VppNode _missNext;
        private final String _name;
        private final Long _nbuckets;
        private final String _nextTable;
        private final Long _skipNVectors;
        private Map<Class<? extends Augmentation<ClassifyTable>>, Augmentation<ClassifyTable>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ClassifyTable> getImplementedInterface() {
            return ClassifyTable.class;
        }

        private ClassifyTableImpl(ClassifyTableBuilder base) {
            if (base.getKey() == null) {
                this._key = new ClassifyTableKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._classifierNode = base.getClassifierNode();
            this._classifySession = base.getClassifySession();
            this._mask = base.getMask();
            this._memorySize = base.getMemorySize();
            this._missNext = base.getMissNext();
            this._nbuckets = base.getNbuckets();
            this._nextTable = base.getNextTable();
            this._skipNVectors = base.getSkipNVectors();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ClassifyTable>>, Augmentation<ClassifyTable>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ClassifyTable>>, Augmentation<ClassifyTable>>(base.augmentation);
                }
            }
        }

        @Override
        public VppNodeName getClassifierNode() {
            return this._classifierNode;
        }

        @Override
        public List<ClassifySession> getClassifySession() {
            return this._classifySession;
        }

        @Override
        public ClassifyTableKey getKey() {
            return this._key;
        }

        @Override
        public HexString getMask() {
            return this._mask;
        }

        @Override
        public Long getMemorySize() {
            return this._memorySize;
        }

        @Override
        public VppNode getMissNext() {
            return this._missNext;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Long getNbuckets() {
            return this._nbuckets;
        }

        @Override
        public String getNextTable() {
            return this._nextTable;
        }

        @Override
        public Long getSkipNVectors() {
            return this._skipNVectors;
        }

        public <E extends Augmentation<ClassifyTable>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._classifierNode);
            result = 31 * result + Objects.hashCode(this._classifySession);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._mask);
            result = 31 * result + Objects.hashCode(this._memorySize);
            result = 31 * result + Objects.hashCode(this._missNext);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._nbuckets);
            result = 31 * result + Objects.hashCode(this._nextTable);
            result = 31 * result + Objects.hashCode(this._skipNVectors);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ClassifyTable.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ClassifyTable other = (ClassifyTable)obj;
            if (!Objects.equals(this._classifierNode, other.getClassifierNode())) {
                return false;
            }
            if (!Objects.equals(this._classifySession, other.getClassifySession())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(this._memorySize, other.getMemorySize())) {
                return false;
            }
            if (!Objects.equals(this._missNext, other.getMissNext())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._nbuckets, other.getNbuckets())) {
                return false;
            }
            if (!Objects.equals(this._nextTable, other.getNextTable())) {
                return false;
            }
            if (!Objects.equals(this._skipNVectors, other.getSkipNVectors())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ClassifyTableImpl otherImpl = (ClassifyTableImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ClassifyTable>>, Augmentation<ClassifyTable>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ClassifyTable [";
            StringBuilder builder = new StringBuilder(name);
            if (this._classifierNode != null) {
                builder.append("_classifierNode=");
                builder.append(this._classifierNode);
                builder.append(", ");
            }
            if (this._classifySession != null) {
                builder.append("_classifySession=");
                builder.append(this._classifySession);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._mask != null) {
                builder.append("_mask=");
                builder.append(this._mask);
                builder.append(", ");
            }
            if (this._memorySize != null) {
                builder.append("_memorySize=");
                builder.append(this._memorySize);
                builder.append(", ");
            }
            if (this._missNext != null) {
                builder.append("_missNext=");
                builder.append(this._missNext);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._nbuckets != null) {
                builder.append("_nbuckets=");
                builder.append(this._nbuckets);
                builder.append(", ");
            }
            if (this._nextTable != null) {
                builder.append("_nextTable=");
                builder.append(this._nextTable);
                builder.append(", ");
            }
            if (this._skipNVectors != null) {
                builder.append("_skipNVectors=");
                builder.append(this._skipNVectors);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

