/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.classify.table.base.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.HexString;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.ClassifySessionAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.OpaqueIndex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.VppNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.classify.table.base.attributes.ClassifySession;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.classify.table.base.attributes.ClassifySessionKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ClassifySessionBuilder
implements Builder<ClassifySession> {
    private Integer _advance;
    private VppNode _hitNext;
    private ClassifySessionKey _key;
    private HexString _match;
    private OpaqueIndex _opaqueIndex;
    Map<Class<? extends Augmentation<ClassifySession>>, Augmentation<ClassifySession>> augmentation = Collections.emptyMap();

    public ClassifySessionBuilder() {
    }

    public ClassifySessionBuilder(ClassifySessionAttributes arg) {
        this._hitNext = arg.getHitNext();
        this._opaqueIndex = arg.getOpaqueIndex();
        this._advance = arg.getAdvance();
    }

    public ClassifySessionBuilder(ClassifySession base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ClassifySessionKey(base.getMatch());
            this._match = base.getMatch();
        } else {
            this._key = base.getKey();
            this._match = this._key.getMatch();
        }
        this._advance = base.getAdvance();
        this._hitNext = base.getHitNext();
        this._opaqueIndex = base.getOpaqueIndex();
        if (base instanceof ClassifySessionImpl) {
            ClassifySessionImpl impl = (ClassifySessionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ClassifySession>>, Augmentation<ClassifySession>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ClassifySession>>, Augmentation<ClassifySession>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ClassifySessionAttributes) {
            this._hitNext = ((ClassifySessionAttributes)arg).getHitNext();
            this._opaqueIndex = ((ClassifySessionAttributes)arg).getOpaqueIndex();
            this._advance = ((ClassifySessionAttributes)arg).getAdvance();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.ClassifySessionAttributes] \nbut was: " + arg);
        }
    }

    public Integer getAdvance() {
        return this._advance;
    }

    public VppNode getHitNext() {
        return this._hitNext;
    }

    public ClassifySessionKey getKey() {
        return this._key;
    }

    public HexString getMatch() {
        return this._match;
    }

    public OpaqueIndex getOpaqueIndex() {
        return this._opaqueIndex;
    }

    public <E extends Augmentation<ClassifySession>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ClassifySessionBuilder setAdvance(Integer value) {
        this._advance = value;
        return this;
    }

    public ClassifySessionBuilder setHitNext(VppNode value) {
        this._hitNext = value;
        return this;
    }

    public ClassifySessionBuilder setKey(ClassifySessionKey value) {
        this._key = value;
        return this;
    }

    public ClassifySessionBuilder setMatch(HexString value) {
        this._match = value;
        return this;
    }

    public ClassifySessionBuilder setOpaqueIndex(OpaqueIndex value) {
        this._opaqueIndex = value;
        return this;
    }

    public ClassifySessionBuilder addAugmentation(Class<? extends Augmentation<ClassifySession>> augmentationType, Augmentation<ClassifySession> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ClassifySession>>, Augmentation<ClassifySession>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ClassifySessionBuilder removeAugmentation(Class<? extends Augmentation<ClassifySession>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ClassifySession build() {
        return new ClassifySessionImpl(this);
    }

    private static final class ClassifySessionImpl
    implements ClassifySession {
        private final Integer _advance;
        private final VppNode _hitNext;
        private final ClassifySessionKey _key;
        private final HexString _match;
        private final OpaqueIndex _opaqueIndex;
        private Map<Class<? extends Augmentation<ClassifySession>>, Augmentation<ClassifySession>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ClassifySession> getImplementedInterface() {
            return ClassifySession.class;
        }

        private ClassifySessionImpl(ClassifySessionBuilder base) {
            if (base.getKey() == null) {
                this._key = new ClassifySessionKey(base.getMatch());
                this._match = base.getMatch();
            } else {
                this._key = base.getKey();
                this._match = this._key.getMatch();
            }
            this._advance = base.getAdvance();
            this._hitNext = base.getHitNext();
            this._opaqueIndex = base.getOpaqueIndex();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ClassifySession>>, Augmentation<ClassifySession>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ClassifySession>>, Augmentation<ClassifySession>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getAdvance() {
            return this._advance;
        }

        @Override
        public VppNode getHitNext() {
            return this._hitNext;
        }

        @Override
        public ClassifySessionKey getKey() {
            return this._key;
        }

        @Override
        public HexString getMatch() {
            return this._match;
        }

        @Override
        public OpaqueIndex getOpaqueIndex() {
            return this._opaqueIndex;
        }

        public <E extends Augmentation<ClassifySession>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._advance);
            result = 31 * result + Objects.hashCode(this._hitNext);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._match);
            result = 31 * result + Objects.hashCode(this._opaqueIndex);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ClassifySession.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ClassifySession other = (ClassifySession)obj;
            if (!Objects.equals(this._advance, other.getAdvance())) {
                return false;
            }
            if (!Objects.equals(this._hitNext, other.getHitNext())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._match, other.getMatch())) {
                return false;
            }
            if (!Objects.equals(this._opaqueIndex, other.getOpaqueIndex())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ClassifySessionImpl otherImpl = (ClassifySessionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ClassifySession>>, Augmentation<ClassifySession>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ClassifySession [";
            StringBuilder builder = new StringBuilder(name);
            if (this._advance != null) {
                builder.append("_advance=");
                builder.append(this._advance);
                builder.append(", ");
            }
            if (this._hitNext != null) {
                builder.append("_hitNext=");
                builder.append(this._hitNext);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._match != null) {
                builder.append("_match=");
                builder.append(this._match);
                builder.append(", ");
            }
            if (this._opaqueIndex != null) {
                builder.append("_opaqueIndex=");
                builder.append(this._opaqueIndex);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

