/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.VppClassifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214.vpp.classifier.ClassifyTable;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VppClassifierBuilder
implements Builder<VppClassifier> {
    private List<ClassifyTable> _classifyTable;
    Map<Class<? extends Augmentation<VppClassifier>>, Augmentation<VppClassifier>> augmentation = Collections.emptyMap();

    public VppClassifierBuilder() {
    }

    public VppClassifierBuilder(VppClassifier base) {
        AugmentationHolder casted;
        this._classifyTable = base.getClassifyTable();
        if (base instanceof VppClassifierImpl) {
            VppClassifierImpl impl = (VppClassifierImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<VppClassifier>>, Augmentation<VppClassifier>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VppClassifier>>, Augmentation<VppClassifier>>(casted.augmentations());
        }
    }

    public List<ClassifyTable> getClassifyTable() {
        return this._classifyTable;
    }

    public <E extends Augmentation<VppClassifier>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VppClassifierBuilder setClassifyTable(List<ClassifyTable> value) {
        this._classifyTable = value;
        return this;
    }

    public VppClassifierBuilder addAugmentation(Class<? extends Augmentation<VppClassifier>> augmentationType, Augmentation<VppClassifier> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VppClassifier>>, Augmentation<VppClassifier>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public VppClassifierBuilder removeAugmentation(Class<? extends Augmentation<VppClassifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VppClassifier build() {
        return new VppClassifierImpl(this);
    }

    private static final class VppClassifierImpl
    implements VppClassifier {
        private final List<ClassifyTable> _classifyTable;
        private Map<Class<? extends Augmentation<VppClassifier>>, Augmentation<VppClassifier>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<VppClassifier> getImplementedInterface() {
            return VppClassifier.class;
        }

        private VppClassifierImpl(VppClassifierBuilder base) {
            this._classifyTable = base.getClassifyTable();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VppClassifier>>, Augmentation<VppClassifier>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VppClassifier>>, Augmentation<VppClassifier>>(base.augmentation);
                }
            }
        }

        @Override
        public List<ClassifyTable> getClassifyTable() {
            return this._classifyTable;
        }

        public <E extends Augmentation<VppClassifier>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._classifyTable);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VppClassifier.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VppClassifier other = (VppClassifier)obj;
            if (!Objects.equals(this._classifyTable, other.getClassifyTable())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VppClassifierImpl otherImpl = (VppClassifierImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VppClassifier>>, Augmentation<VppClassifier>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "VppClassifier [";
            StringBuilder builder = new StringBuilder(name);
            if (this._classifyTable != null) {
                builder.append("_classifyTable=");
                builder.append(this._classifyTable);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

