/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classifier.rev161214;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum PacketHandlingAction {
    Deny(0, "deny"),
    Permit(-1, "permit");

    private static final Map<Integer, PacketHandlingAction> VALUE_MAP;
    private final String name;
    private final int value;

    private PacketHandlingAction(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static PacketHandlingAction forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (PacketHandlingAction enumItem : PacketHandlingAction.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

