/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.ietf.acl.base.attributes.access.lists;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.AclBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.ietf.acl.base.attributes.access.lists.Acl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.ietf.acl.base.attributes.access.lists.AclKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AclBuilder
implements Builder<Acl> {
    private AclKey _key;
    private String _name;
    private Class<? extends AclBase> _type;
    Map<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> augmentation = Collections.emptyMap();

    public AclBuilder() {
    }

    public AclBuilder(Acl base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new AclKey(base.getName(), base.getType());
            this._name = base.getName();
            this._type = base.getType();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
            this._type = this._key.getType();
        }
        if (base instanceof AclImpl) {
            AclImpl impl = (AclImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>(casted.augmentations());
        }
    }

    public AclKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public Class<? extends AclBase> getType() {
        return this._type;
    }

    public <E extends Augmentation<Acl>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AclBuilder setKey(AclKey value) {
        this._key = value;
        return this;
    }

    public AclBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public AclBuilder setType(Class<? extends AclBase> value) {
        this._type = value;
        return this;
    }

    public AclBuilder addAugmentation(Class<? extends Augmentation<Acl>> augmentationType, Augmentation<Acl> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AclBuilder removeAugmentation(Class<? extends Augmentation<Acl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Acl build() {
        return new AclImpl(this);
    }

    private static final class AclImpl
    implements Acl {
        private final AclKey _key;
        private final String _name;
        private final Class<? extends AclBase> _type;
        private Map<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Acl> getImplementedInterface() {
            return Acl.class;
        }

        private AclImpl(AclBuilder base) {
            if (base.getKey() == null) {
                this._key = new AclKey(base.getName(), base.getType());
                this._name = base.getName();
                this._type = base.getType();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
                this._type = this._key.getType();
            }
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>(base.augmentation);
                }
            }
        }

        @Override
        public AclKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Class<? extends AclBase> getType() {
            return this._type;
        }

        public <E extends Augmentation<Acl>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Acl.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Acl other = (Acl)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AclImpl otherImpl = (AclImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Acl [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

