/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.access.lists.acl.access.list.entries.ace.matches.ace.type.ace.ip.and.eth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Dscp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclEthHeaderFields;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclIpHeaderFields;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclTransportHeaderFields;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.DestinationPortRange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.SourcePortRange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.access.lists.acl.access.list.entries.ace.matches.ace.type.ace.ip.and.eth.AceIpAndEthNodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.access.lists.acl.access.list.entries.ace.matches.ace.type.ace.ip.and.eth.ace.ip.and.eth.nodes.AceIpVersion;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AceIpAndEthNodesBuilder
implements Builder<AceIpAndEthNodes> {
    private AceIpVersion _aceIpVersion;
    private MacAddress _destinationMacAddress;
    private MacAddress _destinationMacAddressMask;
    private DestinationPortRange _destinationPortRange;
    private Dscp _dscp;
    private Short _protocol;
    private MacAddress _sourceMacAddress;
    private MacAddress _sourceMacAddressMask;
    private SourcePortRange _sourcePortRange;
    Map<Class<? extends Augmentation<AceIpAndEthNodes>>, Augmentation<AceIpAndEthNodes>> augmentation = Collections.emptyMap();

    public AceIpAndEthNodesBuilder() {
    }

    public AceIpAndEthNodesBuilder(AclIpHeaderFields arg) {
        this._dscp = arg.getDscp();
        this._protocol = arg.getProtocol();
        this._sourcePortRange = arg.getSourcePortRange();
        this._destinationPortRange = arg.getDestinationPortRange();
    }

    public AceIpAndEthNodesBuilder(AclTransportHeaderFields arg) {
        this._sourcePortRange = arg.getSourcePortRange();
        this._destinationPortRange = arg.getDestinationPortRange();
    }

    public AceIpAndEthNodesBuilder(AclEthHeaderFields arg) {
        this._destinationMacAddress = arg.getDestinationMacAddress();
        this._destinationMacAddressMask = arg.getDestinationMacAddressMask();
        this._sourceMacAddress = arg.getSourceMacAddress();
        this._sourceMacAddressMask = arg.getSourceMacAddressMask();
    }

    public AceIpAndEthNodesBuilder(AceIpAndEthNodes base) {
        AugmentationHolder casted;
        this._aceIpVersion = base.getAceIpVersion();
        this._destinationMacAddress = base.getDestinationMacAddress();
        this._destinationMacAddressMask = base.getDestinationMacAddressMask();
        this._destinationPortRange = base.getDestinationPortRange();
        this._dscp = base.getDscp();
        this._protocol = base.getProtocol();
        this._sourceMacAddress = base.getSourceMacAddress();
        this._sourceMacAddressMask = base.getSourceMacAddressMask();
        this._sourcePortRange = base.getSourcePortRange();
        if (base instanceof AceIpAndEthNodesImpl) {
            AceIpAndEthNodesImpl impl = (AceIpAndEthNodesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AceIpAndEthNodes>>, Augmentation<AceIpAndEthNodes>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AceIpAndEthNodes>>, Augmentation<AceIpAndEthNodes>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AclIpHeaderFields) {
            this._dscp = ((AclIpHeaderFields)arg).getDscp();
            this._protocol = ((AclIpHeaderFields)arg).getProtocol();
            isValidArg = true;
        }
        if (arg instanceof AclEthHeaderFields) {
            this._destinationMacAddress = ((AclEthHeaderFields)arg).getDestinationMacAddress();
            this._destinationMacAddressMask = ((AclEthHeaderFields)arg).getDestinationMacAddressMask();
            this._sourceMacAddress = ((AclEthHeaderFields)arg).getSourceMacAddress();
            this._sourceMacAddressMask = ((AclEthHeaderFields)arg).getSourceMacAddressMask();
            isValidArg = true;
        }
        if (arg instanceof AclTransportHeaderFields) {
            this._sourcePortRange = ((AclTransportHeaderFields)arg).getSourcePortRange();
            this._destinationPortRange = ((AclTransportHeaderFields)arg).getDestinationPortRange();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclIpHeaderFields, org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclEthHeaderFields, org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclTransportHeaderFields] \nbut was: " + arg);
        }
    }

    public AceIpVersion getAceIpVersion() {
        return this._aceIpVersion;
    }

    public MacAddress getDestinationMacAddress() {
        return this._destinationMacAddress;
    }

    public MacAddress getDestinationMacAddressMask() {
        return this._destinationMacAddressMask;
    }

    public DestinationPortRange getDestinationPortRange() {
        return this._destinationPortRange;
    }

    public Dscp getDscp() {
        return this._dscp;
    }

    public Short getProtocol() {
        return this._protocol;
    }

    public MacAddress getSourceMacAddress() {
        return this._sourceMacAddress;
    }

    public MacAddress getSourceMacAddressMask() {
        return this._sourceMacAddressMask;
    }

    public SourcePortRange getSourcePortRange() {
        return this._sourcePortRange;
    }

    public <E extends Augmentation<AceIpAndEthNodes>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AceIpAndEthNodesBuilder setAceIpVersion(AceIpVersion value) {
        this._aceIpVersion = value;
        return this;
    }

    public AceIpAndEthNodesBuilder setDestinationMacAddress(MacAddress value) {
        this._destinationMacAddress = value;
        return this;
    }

    public AceIpAndEthNodesBuilder setDestinationMacAddressMask(MacAddress value) {
        this._destinationMacAddressMask = value;
        return this;
    }

    public AceIpAndEthNodesBuilder setDestinationPortRange(DestinationPortRange value) {
        this._destinationPortRange = value;
        return this;
    }

    public AceIpAndEthNodesBuilder setDscp(Dscp value) {
        this._dscp = value;
        return this;
    }

    private static void checkProtocolRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public AceIpAndEthNodesBuilder setProtocol(Short value) {
        if (value != null) {
            AceIpAndEthNodesBuilder.checkProtocolRange(value);
        }
        this._protocol = value;
        return this;
    }

    public AceIpAndEthNodesBuilder setSourceMacAddress(MacAddress value) {
        this._sourceMacAddress = value;
        return this;
    }

    public AceIpAndEthNodesBuilder setSourceMacAddressMask(MacAddress value) {
        this._sourceMacAddressMask = value;
        return this;
    }

    public AceIpAndEthNodesBuilder setSourcePortRange(SourcePortRange value) {
        this._sourcePortRange = value;
        return this;
    }

    public AceIpAndEthNodesBuilder addAugmentation(Class<? extends Augmentation<AceIpAndEthNodes>> augmentationType, Augmentation<AceIpAndEthNodes> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AceIpAndEthNodes>>, Augmentation<AceIpAndEthNodes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AceIpAndEthNodesBuilder removeAugmentation(Class<? extends Augmentation<AceIpAndEthNodes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AceIpAndEthNodes build() {
        return new AceIpAndEthNodesImpl(this);
    }

    private static final class AceIpAndEthNodesImpl
    implements AceIpAndEthNodes {
        private final AceIpVersion _aceIpVersion;
        private final MacAddress _destinationMacAddress;
        private final MacAddress _destinationMacAddressMask;
        private final DestinationPortRange _destinationPortRange;
        private final Dscp _dscp;
        private final Short _protocol;
        private final MacAddress _sourceMacAddress;
        private final MacAddress _sourceMacAddressMask;
        private final SourcePortRange _sourcePortRange;
        private Map<Class<? extends Augmentation<AceIpAndEthNodes>>, Augmentation<AceIpAndEthNodes>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AceIpAndEthNodes> getImplementedInterface() {
            return AceIpAndEthNodes.class;
        }

        private AceIpAndEthNodesImpl(AceIpAndEthNodesBuilder base) {
            this._aceIpVersion = base.getAceIpVersion();
            this._destinationMacAddress = base.getDestinationMacAddress();
            this._destinationMacAddressMask = base.getDestinationMacAddressMask();
            this._destinationPortRange = base.getDestinationPortRange();
            this._dscp = base.getDscp();
            this._protocol = base.getProtocol();
            this._sourceMacAddress = base.getSourceMacAddress();
            this._sourceMacAddressMask = base.getSourceMacAddressMask();
            this._sourcePortRange = base.getSourcePortRange();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AceIpAndEthNodes>>, Augmentation<AceIpAndEthNodes>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AceIpAndEthNodes>>, Augmentation<AceIpAndEthNodes>>(base.augmentation);
                }
            }
        }

        @Override
        public AceIpVersion getAceIpVersion() {
            return this._aceIpVersion;
        }

        @Override
        public MacAddress getDestinationMacAddress() {
            return this._destinationMacAddress;
        }

        @Override
        public MacAddress getDestinationMacAddressMask() {
            return this._destinationMacAddressMask;
        }

        @Override
        public DestinationPortRange getDestinationPortRange() {
            return this._destinationPortRange;
        }

        @Override
        public Dscp getDscp() {
            return this._dscp;
        }

        @Override
        public Short getProtocol() {
            return this._protocol;
        }

        @Override
        public MacAddress getSourceMacAddress() {
            return this._sourceMacAddress;
        }

        @Override
        public MacAddress getSourceMacAddressMask() {
            return this._sourceMacAddressMask;
        }

        @Override
        public SourcePortRange getSourcePortRange() {
            return this._sourcePortRange;
        }

        public <E extends Augmentation<AceIpAndEthNodes>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._aceIpVersion);
            result = 31 * result + Objects.hashCode(this._destinationMacAddress);
            result = 31 * result + Objects.hashCode(this._destinationMacAddressMask);
            result = 31 * result + Objects.hashCode(this._destinationPortRange);
            result = 31 * result + Objects.hashCode(this._dscp);
            result = 31 * result + Objects.hashCode(this._protocol);
            result = 31 * result + Objects.hashCode(this._sourceMacAddress);
            result = 31 * result + Objects.hashCode(this._sourceMacAddressMask);
            result = 31 * result + Objects.hashCode(this._sourcePortRange);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AceIpAndEthNodes.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AceIpAndEthNodes other = (AceIpAndEthNodes)obj;
            if (!Objects.equals(this._aceIpVersion, other.getAceIpVersion())) {
                return false;
            }
            if (!Objects.equals(this._destinationMacAddress, other.getDestinationMacAddress())) {
                return false;
            }
            if (!Objects.equals(this._destinationMacAddressMask, other.getDestinationMacAddressMask())) {
                return false;
            }
            if (!Objects.equals(this._destinationPortRange, other.getDestinationPortRange())) {
                return false;
            }
            if (!Objects.equals(this._dscp, other.getDscp())) {
                return false;
            }
            if (!Objects.equals(this._protocol, other.getProtocol())) {
                return false;
            }
            if (!Objects.equals(this._sourceMacAddress, other.getSourceMacAddress())) {
                return false;
            }
            if (!Objects.equals(this._sourceMacAddressMask, other.getSourceMacAddressMask())) {
                return false;
            }
            if (!Objects.equals(this._sourcePortRange, other.getSourcePortRange())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AceIpAndEthNodesImpl otherImpl = (AceIpAndEthNodesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AceIpAndEthNodes>>, Augmentation<AceIpAndEthNodes>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "AceIpAndEthNodes [";
            StringBuilder builder = new StringBuilder(name);
            if (this._aceIpVersion != null) {
                builder.append("_aceIpVersion=");
                builder.append(this._aceIpVersion);
                builder.append(", ");
            }
            if (this._destinationMacAddress != null) {
                builder.append("_destinationMacAddress=");
                builder.append(this._destinationMacAddress);
                builder.append(", ");
            }
            if (this._destinationMacAddressMask != null) {
                builder.append("_destinationMacAddressMask=");
                builder.append(this._destinationMacAddressMask);
                builder.append(", ");
            }
            if (this._destinationPortRange != null) {
                builder.append("_destinationPortRange=");
                builder.append(this._destinationPortRange);
                builder.append(", ");
            }
            if (this._dscp != null) {
                builder.append("_dscp=");
                builder.append(this._dscp);
                builder.append(", ");
            }
            if (this._protocol != null) {
                builder.append("_protocol=");
                builder.append(this._protocol);
                builder.append(", ");
            }
            if (this._sourceMacAddress != null) {
                builder.append("_sourceMacAddress=");
                builder.append(this._sourceMacAddress);
                builder.append(", ");
            }
            if (this._sourceMacAddressMask != null) {
                builder.append("_sourceMacAddressMask=");
                builder.append(this._sourceMacAddressMask);
                builder.append(", ");
            }
            if (this._sourcePortRange != null) {
                builder.append("_sourcePortRange=");
                builder.append(this._sourcePortRange);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

