/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.vpp.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.vpp.state.Version;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VersionBuilder
implements Builder<Version> {
    private String _branch;
    private String _buildDate;
    private String _buildDirectory;
    private String _name;
    private Long _pid;
    Map<Class<? extends Augmentation<Version>>, Augmentation<Version>> augmentation = Collections.emptyMap();

    public VersionBuilder() {
    }

    public VersionBuilder(Version base) {
        AugmentationHolder casted;
        this._branch = base.getBranch();
        this._buildDate = base.getBuildDate();
        this._buildDirectory = base.getBuildDirectory();
        this._name = base.getName();
        this._pid = base.getPid();
        if (base instanceof VersionImpl) {
            VersionImpl impl = (VersionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Version>>, Augmentation<Version>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Version>>, Augmentation<Version>>(casted.augmentations());
        }
    }

    public String getBranch() {
        return this._branch;
    }

    public String getBuildDate() {
        return this._buildDate;
    }

    public String getBuildDirectory() {
        return this._buildDirectory;
    }

    public String getName() {
        return this._name;
    }

    public Long getPid() {
        return this._pid;
    }

    public <E extends Augmentation<Version>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VersionBuilder setBranch(String value) {
        this._branch = value;
        return this;
    }

    public VersionBuilder setBuildDate(String value) {
        this._buildDate = value;
        return this;
    }

    public VersionBuilder setBuildDirectory(String value) {
        this._buildDirectory = value;
        return this;
    }

    public VersionBuilder setName(String value) {
        this._name = value;
        return this;
    }

    private static void checkPidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public VersionBuilder setPid(Long value) {
        if (value != null) {
            VersionBuilder.checkPidRange(value);
        }
        this._pid = value;
        return this;
    }

    public VersionBuilder addAugmentation(Class<? extends Augmentation<Version>> augmentationType, Augmentation<Version> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Version>>, Augmentation<Version>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public VersionBuilder removeAugmentation(Class<? extends Augmentation<Version>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Version build() {
        return new VersionImpl(this);
    }

    private static final class VersionImpl
    implements Version {
        private final String _branch;
        private final String _buildDate;
        private final String _buildDirectory;
        private final String _name;
        private final Long _pid;
        private Map<Class<? extends Augmentation<Version>>, Augmentation<Version>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Version> getImplementedInterface() {
            return Version.class;
        }

        private VersionImpl(VersionBuilder base) {
            this._branch = base.getBranch();
            this._buildDate = base.getBuildDate();
            this._buildDirectory = base.getBuildDirectory();
            this._name = base.getName();
            this._pid = base.getPid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Version>>, Augmentation<Version>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Version>>, Augmentation<Version>>(base.augmentation);
                }
            }
        }

        @Override
        public String getBranch() {
            return this._branch;
        }

        @Override
        public String getBuildDate() {
            return this._buildDate;
        }

        @Override
        public String getBuildDirectory() {
            return this._buildDirectory;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Long getPid() {
            return this._pid;
        }

        public <E extends Augmentation<Version>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._branch);
            result = 31 * result + Objects.hashCode(this._buildDate);
            result = 31 * result + Objects.hashCode(this._buildDirectory);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._pid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Version.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Version other = (Version)obj;
            if (!Objects.equals(this._branch, other.getBranch())) {
                return false;
            }
            if (!Objects.equals(this._buildDate, other.getBuildDate())) {
                return false;
            }
            if (!Objects.equals(this._buildDirectory, other.getBuildDirectory())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._pid, other.getPid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VersionImpl otherImpl = (VersionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Version>>, Augmentation<Version>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Version [";
            StringBuilder builder = new StringBuilder(name);
            if (this._branch != null) {
                builder.append("_branch=");
                builder.append(this._branch);
                builder.append(", ");
            }
            if (this._buildDate != null) {
                builder.append("_buildDate=");
                builder.append(this._buildDate);
                builder.append(", ");
            }
            if (this._buildDirectory != null) {
                builder.append("_buildDirectory=");
                builder.append(this._buildDirectory);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._pid != null) {
                builder.append("_pid=");
                builder.append(this._pid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

