/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.vpp.bridge.domains;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.BridgeDomainAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.L2FibAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.bridge.domain.attributes.ArpTerminationTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.l2.fib.attributes.L2FibTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.vpp.bridge.domains.BridgeDomain;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.vpp.bridge.domains.BridgeDomainKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BridgeDomainBuilder
implements Builder<BridgeDomain> {
    private ArpTerminationTable _arpTerminationTable;
    private BridgeDomainKey _key;
    private L2FibTable _l2FibTable;
    private String _name;
    private Boolean _arpTermination;
    private Boolean _flood;
    private Boolean _forward;
    private Boolean _learn;
    private Boolean _unknownUnicastFlood;
    Map<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>> augmentation = Collections.emptyMap();

    public BridgeDomainBuilder() {
    }

    public BridgeDomainBuilder(L2FibAttributes arg) {
        this._l2FibTable = arg.getL2FibTable();
    }

    public BridgeDomainBuilder(BridgeDomainAttributes arg) {
        this._flood = arg.isFlood();
        this._forward = arg.isForward();
        this._learn = arg.isLearn();
        this._unknownUnicastFlood = arg.isUnknownUnicastFlood();
        this._arpTermination = arg.isArpTermination();
        this._arpTerminationTable = arg.getArpTerminationTable();
    }

    public BridgeDomainBuilder(BridgeDomain base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BridgeDomainKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._arpTerminationTable = base.getArpTerminationTable();
        this._l2FibTable = base.getL2FibTable();
        this._arpTermination = base.isArpTermination();
        this._flood = base.isFlood();
        this._forward = base.isForward();
        this._learn = base.isLearn();
        this._unknownUnicastFlood = base.isUnknownUnicastFlood();
        if (base instanceof BridgeDomainImpl) {
            BridgeDomainImpl impl = (BridgeDomainImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof L2FibAttributes) {
            this._l2FibTable = ((L2FibAttributes)arg).getL2FibTable();
            isValidArg = true;
        }
        if (arg instanceof BridgeDomainAttributes) {
            this._flood = ((BridgeDomainAttributes)arg).isFlood();
            this._forward = ((BridgeDomainAttributes)arg).isForward();
            this._learn = ((BridgeDomainAttributes)arg).isLearn();
            this._unknownUnicastFlood = ((BridgeDomainAttributes)arg).isUnknownUnicastFlood();
            this._arpTermination = ((BridgeDomainAttributes)arg).isArpTermination();
            this._arpTerminationTable = ((BridgeDomainAttributes)arg).getArpTerminationTable();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.L2FibAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.BridgeDomainAttributes] \nbut was: " + arg);
        }
    }

    public ArpTerminationTable getArpTerminationTable() {
        return this._arpTerminationTable;
    }

    public BridgeDomainKey getKey() {
        return this._key;
    }

    public L2FibTable getL2FibTable() {
        return this._l2FibTable;
    }

    public String getName() {
        return this._name;
    }

    public Boolean isArpTermination() {
        return this._arpTermination;
    }

    public Boolean isFlood() {
        return this._flood;
    }

    public Boolean isForward() {
        return this._forward;
    }

    public Boolean isLearn() {
        return this._learn;
    }

    public Boolean isUnknownUnicastFlood() {
        return this._unknownUnicastFlood;
    }

    public <E extends Augmentation<BridgeDomain>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BridgeDomainBuilder setArpTerminationTable(ArpTerminationTable value) {
        this._arpTerminationTable = value;
        return this;
    }

    public BridgeDomainBuilder setKey(BridgeDomainKey value) {
        this._key = value;
        return this;
    }

    public BridgeDomainBuilder setL2FibTable(L2FibTable value) {
        this._l2FibTable = value;
        return this;
    }

    public BridgeDomainBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public BridgeDomainBuilder setArpTermination(Boolean value) {
        this._arpTermination = value;
        return this;
    }

    public BridgeDomainBuilder setFlood(Boolean value) {
        this._flood = value;
        return this;
    }

    public BridgeDomainBuilder setForward(Boolean value) {
        this._forward = value;
        return this;
    }

    public BridgeDomainBuilder setLearn(Boolean value) {
        this._learn = value;
        return this;
    }

    public BridgeDomainBuilder setUnknownUnicastFlood(Boolean value) {
        this._unknownUnicastFlood = value;
        return this;
    }

    public BridgeDomainBuilder addAugmentation(Class<? extends Augmentation<BridgeDomain>> augmentationType, Augmentation<BridgeDomain> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BridgeDomainBuilder removeAugmentation(Class<? extends Augmentation<BridgeDomain>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BridgeDomain build() {
        return new BridgeDomainImpl(this);
    }

    private static final class BridgeDomainImpl
    implements BridgeDomain {
        private final ArpTerminationTable _arpTerminationTable;
        private final BridgeDomainKey _key;
        private final L2FibTable _l2FibTable;
        private final String _name;
        private final Boolean _arpTermination;
        private final Boolean _flood;
        private final Boolean _forward;
        private final Boolean _learn;
        private final Boolean _unknownUnicastFlood;
        private Map<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BridgeDomain> getImplementedInterface() {
            return BridgeDomain.class;
        }

        private BridgeDomainImpl(BridgeDomainBuilder base) {
            if (base.getKey() == null) {
                this._key = new BridgeDomainKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._arpTerminationTable = base.getArpTerminationTable();
            this._l2FibTable = base.getL2FibTable();
            this._arpTermination = base.isArpTermination();
            this._flood = base.isFlood();
            this._forward = base.isForward();
            this._learn = base.isLearn();
            this._unknownUnicastFlood = base.isUnknownUnicastFlood();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>>(base.augmentation);
                }
            }
        }

        @Override
        public ArpTerminationTable getArpTerminationTable() {
            return this._arpTerminationTable;
        }

        @Override
        public BridgeDomainKey getKey() {
            return this._key;
        }

        @Override
        public L2FibTable getL2FibTable() {
            return this._l2FibTable;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Boolean isArpTermination() {
            return this._arpTermination;
        }

        @Override
        public Boolean isFlood() {
            return this._flood;
        }

        @Override
        public Boolean isForward() {
            return this._forward;
        }

        @Override
        public Boolean isLearn() {
            return this._learn;
        }

        @Override
        public Boolean isUnknownUnicastFlood() {
            return this._unknownUnicastFlood;
        }

        public <E extends Augmentation<BridgeDomain>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._arpTerminationTable);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._l2FibTable);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._arpTermination);
            result = 31 * result + Objects.hashCode(this._flood);
            result = 31 * result + Objects.hashCode(this._forward);
            result = 31 * result + Objects.hashCode(this._learn);
            result = 31 * result + Objects.hashCode(this._unknownUnicastFlood);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BridgeDomain.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BridgeDomain other = (BridgeDomain)obj;
            if (!Objects.equals(this._arpTerminationTable, other.getArpTerminationTable())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._l2FibTable, other.getL2FibTable())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._arpTermination, other.isArpTermination())) {
                return false;
            }
            if (!Objects.equals(this._flood, other.isFlood())) {
                return false;
            }
            if (!Objects.equals(this._forward, other.isForward())) {
                return false;
            }
            if (!Objects.equals(this._learn, other.isLearn())) {
                return false;
            }
            if (!Objects.equals(this._unknownUnicastFlood, other.isUnknownUnicastFlood())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BridgeDomainImpl otherImpl = (BridgeDomainImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BridgeDomain [";
            StringBuilder builder = new StringBuilder(name);
            if (this._arpTerminationTable != null) {
                builder.append("_arpTerminationTable=");
                builder.append(this._arpTerminationTable);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._l2FibTable != null) {
                builder.append("_l2FibTable=");
                builder.append(this._l2FibTable);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._arpTermination != null) {
                builder.append("_arpTermination=");
                builder.append(this._arpTermination);
                builder.append(", ");
            }
            if (this._flood != null) {
                builder.append("_flood=");
                builder.append(this._flood);
                builder.append(", ");
            }
            if (this._forward != null) {
                builder.append("_forward=");
                builder.append(this._forward);
                builder.append(", ");
            }
            if (this._learn != null) {
                builder.append("_learn=");
                builder.append(this._learn);
                builder.append(", ");
            }
            if (this._unknownUnicastFlood != null) {
                builder.append("_unknownUnicastFlood=");
                builder.append(this._unknownUnicastFlood);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

