/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.l2.fib.attributes.l2.fib.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.L2FibAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.l2.fib.attributes.l2.fib.table.L2FibEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.l2.fib.attributes.l2.fib.table.L2FibEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class L2FibEntryBuilder
implements Builder<L2FibEntry> {
    private Class<? extends L2FibAction> _action;
    private L2FibEntryKey _key;
    private String _outgoingInterface;
    private PhysAddress _physAddress;
    private Boolean _bridgedVirtualInterface;
    private Boolean _staticConfig;
    Map<Class<? extends Augmentation<L2FibEntry>>, Augmentation<L2FibEntry>> augmentation = Collections.emptyMap();

    public L2FibEntryBuilder() {
    }

    public L2FibEntryBuilder(L2FibEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new L2FibEntryKey(base.getPhysAddress());
            this._physAddress = base.getPhysAddress();
        } else {
            this._key = base.getKey();
            this._physAddress = this._key.getPhysAddress();
        }
        this._action = base.getAction();
        this._outgoingInterface = base.getOutgoingInterface();
        this._bridgedVirtualInterface = base.isBridgedVirtualInterface();
        this._staticConfig = base.isStaticConfig();
        if (base instanceof L2FibEntryImpl) {
            L2FibEntryImpl impl = (L2FibEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<L2FibEntry>>, Augmentation<L2FibEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<L2FibEntry>>, Augmentation<L2FibEntry>>(casted.augmentations());
        }
    }

    public Class<? extends L2FibAction> getAction() {
        return this._action;
    }

    public L2FibEntryKey getKey() {
        return this._key;
    }

    public String getOutgoingInterface() {
        return this._outgoingInterface;
    }

    public PhysAddress getPhysAddress() {
        return this._physAddress;
    }

    public Boolean isBridgedVirtualInterface() {
        return this._bridgedVirtualInterface;
    }

    public Boolean isStaticConfig() {
        return this._staticConfig;
    }

    public <E extends Augmentation<L2FibEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public L2FibEntryBuilder setAction(Class<? extends L2FibAction> value) {
        this._action = value;
        return this;
    }

    public L2FibEntryBuilder setKey(L2FibEntryKey value) {
        this._key = value;
        return this;
    }

    public L2FibEntryBuilder setOutgoingInterface(String value) {
        this._outgoingInterface = value;
        return this;
    }

    public L2FibEntryBuilder setPhysAddress(PhysAddress value) {
        this._physAddress = value;
        return this;
    }

    public L2FibEntryBuilder setBridgedVirtualInterface(Boolean value) {
        this._bridgedVirtualInterface = value;
        return this;
    }

    public L2FibEntryBuilder setStaticConfig(Boolean value) {
        this._staticConfig = value;
        return this;
    }

    public L2FibEntryBuilder addAugmentation(Class<? extends Augmentation<L2FibEntry>> augmentationType, Augmentation<L2FibEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<L2FibEntry>>, Augmentation<L2FibEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public L2FibEntryBuilder removeAugmentation(Class<? extends Augmentation<L2FibEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public L2FibEntry build() {
        return new L2FibEntryImpl(this);
    }

    private static final class L2FibEntryImpl
    implements L2FibEntry {
        private final Class<? extends L2FibAction> _action;
        private final L2FibEntryKey _key;
        private final String _outgoingInterface;
        private final PhysAddress _physAddress;
        private final Boolean _bridgedVirtualInterface;
        private final Boolean _staticConfig;
        private Map<Class<? extends Augmentation<L2FibEntry>>, Augmentation<L2FibEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<L2FibEntry> getImplementedInterface() {
            return L2FibEntry.class;
        }

        private L2FibEntryImpl(L2FibEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new L2FibEntryKey(base.getPhysAddress());
                this._physAddress = base.getPhysAddress();
            } else {
                this._key = base.getKey();
                this._physAddress = this._key.getPhysAddress();
            }
            this._action = base.getAction();
            this._outgoingInterface = base.getOutgoingInterface();
            this._bridgedVirtualInterface = base.isBridgedVirtualInterface();
            this._staticConfig = base.isStaticConfig();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<L2FibEntry>>, Augmentation<L2FibEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<L2FibEntry>>, Augmentation<L2FibEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public Class<? extends L2FibAction> getAction() {
            return this._action;
        }

        @Override
        public L2FibEntryKey getKey() {
            return this._key;
        }

        @Override
        public String getOutgoingInterface() {
            return this._outgoingInterface;
        }

        @Override
        public PhysAddress getPhysAddress() {
            return this._physAddress;
        }

        @Override
        public Boolean isBridgedVirtualInterface() {
            return this._bridgedVirtualInterface;
        }

        @Override
        public Boolean isStaticConfig() {
            return this._staticConfig;
        }

        public <E extends Augmentation<L2FibEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._action);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._outgoingInterface);
            result = 31 * result + Objects.hashCode(this._physAddress);
            result = 31 * result + Objects.hashCode(this._bridgedVirtualInterface);
            result = 31 * result + Objects.hashCode(this._staticConfig);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!L2FibEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            L2FibEntry other = (L2FibEntry)obj;
            if (!Objects.equals(this._action, other.getAction())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._outgoingInterface, other.getOutgoingInterface())) {
                return false;
            }
            if (!Objects.equals(this._physAddress, other.getPhysAddress())) {
                return false;
            }
            if (!Objects.equals(this._bridgedVirtualInterface, other.isBridgedVirtualInterface())) {
                return false;
            }
            if (!Objects.equals(this._staticConfig, other.isStaticConfig())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                L2FibEntryImpl otherImpl = (L2FibEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<L2FibEntry>>, Augmentation<L2FibEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "L2FibEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._action != null) {
                builder.append("_action=");
                builder.append(this._action);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._outgoingInterface != null) {
                builder.append("_outgoingInterface=");
                builder.append(this._outgoingInterface);
                builder.append(", ");
            }
            if (this._physAddress != null) {
                builder.append("_physAddress=");
                builder.append(this._physAddress);
                builder.append(", ");
            }
            if (this._bridgedVirtualInterface != null) {
                builder.append("_bridgedVirtualInterface=");
                builder.append(this._bridgedVirtualInterface);
                builder.append(", ");
            }
            if (this._staticConfig != null) {
                builder.append("_staticConfig=");
                builder.append(this._staticConfig);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

