/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.l2.base.attributes.interconnection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.l2.base.attributes.interconnection.BridgeBased;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BridgeBasedBuilder
implements Builder<BridgeBased> {
    private String _bridgeDomain;
    private Short _splitHorizonGroup;
    private Boolean _bridgedVirtualInterface;
    Map<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>> augmentation = Collections.emptyMap();

    public BridgeBasedBuilder() {
    }

    public BridgeBasedBuilder(BridgeBased base) {
        AugmentationHolder casted;
        this._bridgeDomain = base.getBridgeDomain();
        this._splitHorizonGroup = base.getSplitHorizonGroup();
        this._bridgedVirtualInterface = base.isBridgedVirtualInterface();
        if (base instanceof BridgeBasedImpl) {
            BridgeBasedImpl impl = (BridgeBasedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>>(casted.augmentations());
        }
    }

    public String getBridgeDomain() {
        return this._bridgeDomain;
    }

    public Short getSplitHorizonGroup() {
        return this._splitHorizonGroup;
    }

    public Boolean isBridgedVirtualInterface() {
        return this._bridgedVirtualInterface;
    }

    public <E extends Augmentation<BridgeBased>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BridgeBasedBuilder setBridgeDomain(String value) {
        this._bridgeDomain = value;
        return this;
    }

    private static void checkSplitHorizonGroupRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public BridgeBasedBuilder setSplitHorizonGroup(Short value) {
        if (value != null) {
            BridgeBasedBuilder.checkSplitHorizonGroupRange(value);
        }
        this._splitHorizonGroup = value;
        return this;
    }

    public BridgeBasedBuilder setBridgedVirtualInterface(Boolean value) {
        this._bridgedVirtualInterface = value;
        return this;
    }

    public BridgeBasedBuilder addAugmentation(Class<? extends Augmentation<BridgeBased>> augmentationType, Augmentation<BridgeBased> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BridgeBasedBuilder removeAugmentation(Class<? extends Augmentation<BridgeBased>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BridgeBased build() {
        return new BridgeBasedImpl(this);
    }

    private static final class BridgeBasedImpl
    implements BridgeBased {
        private final String _bridgeDomain;
        private final Short _splitHorizonGroup;
        private final Boolean _bridgedVirtualInterface;
        private Map<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BridgeBased> getImplementedInterface() {
            return BridgeBased.class;
        }

        private BridgeBasedImpl(BridgeBasedBuilder base) {
            this._bridgeDomain = base.getBridgeDomain();
            this._splitHorizonGroup = base.getSplitHorizonGroup();
            this._bridgedVirtualInterface = base.isBridgedVirtualInterface();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>>(base.augmentation);
                }
            }
        }

        @Override
        public String getBridgeDomain() {
            return this._bridgeDomain;
        }

        @Override
        public Short getSplitHorizonGroup() {
            return this._splitHorizonGroup;
        }

        @Override
        public Boolean isBridgedVirtualInterface() {
            return this._bridgedVirtualInterface;
        }

        public <E extends Augmentation<BridgeBased>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bridgeDomain);
            result = 31 * result + Objects.hashCode(this._splitHorizonGroup);
            result = 31 * result + Objects.hashCode(this._bridgedVirtualInterface);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BridgeBased.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BridgeBased other = (BridgeBased)obj;
            if (!Objects.equals(this._bridgeDomain, other.getBridgeDomain())) {
                return false;
            }
            if (!Objects.equals(this._splitHorizonGroup, other.getSplitHorizonGroup())) {
                return false;
            }
            if (!Objects.equals(this._bridgedVirtualInterface, other.isBridgedVirtualInterface())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BridgeBasedImpl otherImpl = (BridgeBasedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BridgeBased [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bridgeDomain != null) {
                builder.append("_bridgeDomain=");
                builder.append(this._bridgeDomain);
                builder.append(", ");
            }
            if (this._splitHorizonGroup != null) {
                builder.append("_splitHorizonGroup=");
                builder.append(this._splitHorizonGroup);
                builder.append(", ");
            }
            if (this._bridgedVirtualInterface != null) {
                builder.append("_bridgedVirtualInterface=");
                builder.append(this._bridgedVirtualInterface);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

