/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface.acl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface.acl.Ingress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.AclBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.acl.base.attributes.Ip4Acl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.acl.base.attributes.Ip6Acl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.acl.base.attributes.L2Acl;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IngressBuilder
implements Builder<Ingress> {
    private Ip4Acl _ip4Acl;
    private Ip6Acl _ip6Acl;
    private L2Acl _l2Acl;
    Map<Class<? extends Augmentation<Ingress>>, Augmentation<Ingress>> augmentation = Collections.emptyMap();

    public IngressBuilder() {
    }

    public IngressBuilder(AclBaseAttributes arg) {
        this._l2Acl = arg.getL2Acl();
        this._ip4Acl = arg.getIp4Acl();
        this._ip6Acl = arg.getIp6Acl();
    }

    public IngressBuilder(Ingress base) {
        AugmentationHolder casted;
        this._ip4Acl = base.getIp4Acl();
        this._ip6Acl = base.getIp6Acl();
        this._l2Acl = base.getL2Acl();
        if (base instanceof IngressImpl) {
            IngressImpl impl = (IngressImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ingress>>, Augmentation<Ingress>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ingress>>, Augmentation<Ingress>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AclBaseAttributes) {
            this._l2Acl = ((AclBaseAttributes)arg).getL2Acl();
            this._ip4Acl = ((AclBaseAttributes)arg).getIp4Acl();
            this._ip6Acl = ((AclBaseAttributes)arg).getIp6Acl();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.AclBaseAttributes] \nbut was: " + arg);
        }
    }

    public Ip4Acl getIp4Acl() {
        return this._ip4Acl;
    }

    public Ip6Acl getIp6Acl() {
        return this._ip6Acl;
    }

    public L2Acl getL2Acl() {
        return this._l2Acl;
    }

    public <E extends Augmentation<Ingress>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public IngressBuilder setIp4Acl(Ip4Acl value) {
        this._ip4Acl = value;
        return this;
    }

    public IngressBuilder setIp6Acl(Ip6Acl value) {
        this._ip6Acl = value;
        return this;
    }

    public IngressBuilder setL2Acl(L2Acl value) {
        this._l2Acl = value;
        return this;
    }

    public IngressBuilder addAugmentation(Class<? extends Augmentation<Ingress>> augmentationType, Augmentation<Ingress> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ingress>>, Augmentation<Ingress>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IngressBuilder removeAugmentation(Class<? extends Augmentation<Ingress>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ingress build() {
        return new IngressImpl(this);
    }

    private static final class IngressImpl
    implements Ingress {
        private final Ip4Acl _ip4Acl;
        private final Ip6Acl _ip6Acl;
        private final L2Acl _l2Acl;
        private Map<Class<? extends Augmentation<Ingress>>, Augmentation<Ingress>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ingress> getImplementedInterface() {
            return Ingress.class;
        }

        private IngressImpl(IngressBuilder base) {
            this._ip4Acl = base.getIp4Acl();
            this._ip6Acl = base.getIp6Acl();
            this._l2Acl = base.getL2Acl();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ingress>>, Augmentation<Ingress>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ingress>>, Augmentation<Ingress>>(base.augmentation);
                }
            }
        }

        @Override
        public Ip4Acl getIp4Acl() {
            return this._ip4Acl;
        }

        @Override
        public Ip6Acl getIp6Acl() {
            return this._ip6Acl;
        }

        @Override
        public L2Acl getL2Acl() {
            return this._l2Acl;
        }

        public <E extends Augmentation<Ingress>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip4Acl);
            result = 31 * result + Objects.hashCode(this._ip6Acl);
            result = 31 * result + Objects.hashCode(this._l2Acl);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ingress.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ingress other = (Ingress)obj;
            if (!Objects.equals(this._ip4Acl, other.getIp4Acl())) {
                return false;
            }
            if (!Objects.equals(this._ip6Acl, other.getIp6Acl())) {
                return false;
            }
            if (!Objects.equals(this._l2Acl, other.getL2Acl())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IngressImpl otherImpl = (IngressImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ingress>>, Augmentation<Ingress>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Ingress [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ip4Acl != null) {
                builder.append("_ip4Acl=");
                builder.append(this._ip4Acl);
                builder.append(", ");
            }
            if (this._ip6Acl != null) {
                builder.append("_ip6Acl=");
                builder.append(this._ip6Acl);
                builder.append(", ");
            }
            if (this._l2Acl != null) {
                builder.append("_l2Acl=");
                builder.append(this._l2Acl);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

