/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface.acl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface.acl.Egress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.AclBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.acl.base.attributes.Ip4Acl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.acl.base.attributes.Ip6Acl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.acl.base.attributes.L2Acl;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EgressBuilder
implements Builder<Egress> {
    private Ip4Acl _ip4Acl;
    private Ip6Acl _ip6Acl;
    private L2Acl _l2Acl;
    Map<Class<? extends Augmentation<Egress>>, Augmentation<Egress>> augmentation = Collections.emptyMap();

    public EgressBuilder() {
    }

    public EgressBuilder(AclBaseAttributes arg) {
        this._l2Acl = arg.getL2Acl();
        this._ip4Acl = arg.getIp4Acl();
        this._ip6Acl = arg.getIp6Acl();
    }

    public EgressBuilder(Egress base) {
        AugmentationHolder casted;
        this._ip4Acl = base.getIp4Acl();
        this._ip6Acl = base.getIp6Acl();
        this._l2Acl = base.getL2Acl();
        if (base instanceof EgressImpl) {
            EgressImpl impl = (EgressImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Egress>>, Augmentation<Egress>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Egress>>, Augmentation<Egress>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AclBaseAttributes) {
            this._l2Acl = ((AclBaseAttributes)arg).getL2Acl();
            this._ip4Acl = ((AclBaseAttributes)arg).getIp4Acl();
            this._ip6Acl = ((AclBaseAttributes)arg).getIp6Acl();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vpp.classfier.acl.rev161214.AclBaseAttributes] \nbut was: " + arg);
        }
    }

    public Ip4Acl getIp4Acl() {
        return this._ip4Acl;
    }

    public Ip6Acl getIp6Acl() {
        return this._ip6Acl;
    }

    public L2Acl getL2Acl() {
        return this._l2Acl;
    }

    public <E extends Augmentation<Egress>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EgressBuilder setIp4Acl(Ip4Acl value) {
        this._ip4Acl = value;
        return this;
    }

    public EgressBuilder setIp6Acl(Ip6Acl value) {
        this._ip6Acl = value;
        return this;
    }

    public EgressBuilder setL2Acl(L2Acl value) {
        this._l2Acl = value;
        return this;
    }

    public EgressBuilder addAugmentation(Class<? extends Augmentation<Egress>> augmentationType, Augmentation<Egress> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Egress>>, Augmentation<Egress>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EgressBuilder removeAugmentation(Class<? extends Augmentation<Egress>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Egress build() {
        return new EgressImpl(this);
    }

    private static final class EgressImpl
    implements Egress {
        private final Ip4Acl _ip4Acl;
        private final Ip6Acl _ip6Acl;
        private final L2Acl _l2Acl;
        private Map<Class<? extends Augmentation<Egress>>, Augmentation<Egress>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Egress> getImplementedInterface() {
            return Egress.class;
        }

        private EgressImpl(EgressBuilder base) {
            this._ip4Acl = base.getIp4Acl();
            this._ip6Acl = base.getIp6Acl();
            this._l2Acl = base.getL2Acl();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Egress>>, Augmentation<Egress>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Egress>>, Augmentation<Egress>>(base.augmentation);
                }
            }
        }

        @Override
        public Ip4Acl getIp4Acl() {
            return this._ip4Acl;
        }

        @Override
        public Ip6Acl getIp6Acl() {
            return this._ip6Acl;
        }

        @Override
        public L2Acl getL2Acl() {
            return this._l2Acl;
        }

        public <E extends Augmentation<Egress>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip4Acl);
            result = 31 * result + Objects.hashCode(this._ip6Acl);
            result = 31 * result + Objects.hashCode(this._l2Acl);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Egress.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Egress other = (Egress)obj;
            if (!Objects.equals(this._ip4Acl, other.getIp4Acl())) {
                return false;
            }
            if (!Objects.equals(this._ip6Acl, other.getIp6Acl())) {
                return false;
            }
            if (!Objects.equals(this._l2Acl, other.getL2Acl())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EgressImpl otherImpl = (EgressImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Egress>>, Augmentation<Egress>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Egress [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ip4Acl != null) {
                builder.append("_ip4Acl=");
                builder.append(this._ip4Acl);
                builder.append(", ");
            }
            if (this._ip6Acl != null) {
                builder.append("_ip6Acl=");
                builder.append(this._ip6Acl);
                builder.append(", ");
            }
            if (this._l2Acl != null) {
                builder.append("_l2Acl=");
                builder.append(this._l2Acl);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

